/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef VIEWCONTROL_H
#define	VIEWCONTROL_H

#include <string>
#include <vector>
#include <iostream>
#include <strstream>

#include <qnamespace.h>
#include <qstring.h>
#include <qfont.h>
#include <qfontinfo.h>
#include <qpalette.h>
#include <qwidget.h>
#include <q3frame.h>
#include <q3vbox.h>
#include <qsplitter.h>
#include <qlabel.h>
#include <q3listview.h>
#include <qlayout.h>
#include <q3valuelist.h>
#include <qevent.h>

class CViewNode;
class CSplitterWidget;
class CSplitterView;
class CSubView;
class CFrameWidget;

#include "stringToken.h"
#include "optionData.h"
#include "interfaceControl.h"
#include "fontchangeControl.h"
#include "replaceNode.h"
#include "connectionInterface.h"

using namespace ConnectionInterface;

class CViewNode
{
	public:
	CViewNode(	QWidget *p,
				CViewNode *n,
				CInterfaceControl *ic,
				SMainViewControl *mvc,
				const string &dfs,
				CPaletteData *dpd):
		parent_widget(p), parent_node(n), interface_control(ic),
		main_view_control(mvc), default_font_string(dfs),
		default_palette_data(dpd), node_indicator(false) { }
	CViewNode(CViewNode *n): parent_node(n) { }

	virtual ~CViewNode() { }

	QWidget				*GetParentWidget()		{ return parent_widget; }
	CViewNode			*GetParentNode()		{ return parent_node; }
	CInterfaceControl	*GetInterfaceControl()	{ return interface_control; }
	SMainViewControl	*GetMainViewControl()	{ return main_view_control; }
	bool				GetNodeIndicator()		{ return node_indicator; }
	void				SetParentNode(CViewNode *n)	{ parent_node = n; }
	void				SetNodeIndicator(bool b) { node_indicator = b; }
	void				SetPositionAndSize(bool pf = false);

	virtual QWidget		*GetWidget() { return 0; }
	virtual void		SetProcessCloseEventFlag(bool f) { }
	virtual void		CapturePaneSizes(bool rf = false) = 0;
	virtual void		SetPaneSizes() = 0;

	virtual COptionData::SViewNodeData::ViewNodeType	GetNodeType() = 0;
	virtual vector<int>		*GetViewNodeIndex() = 0;

	virtual bool		AddViewNode(COptionData::SViewNodeData *d) = 0;
	virtual bool		AddViewNode(COptionData::SViewNodeData *d,
									vector<int> &iv) = 0;

	virtual CViewNode	*NavigateViewNodeTree(NavigationType nt) = 0;
	virtual CViewNode	*LocateViewNode(vector<int> *index) = 0;
	virtual CViewNode	*LocateViewNode(vector<int> &iv) = 0;

	const string	&GetDefaultFontData()
	{ return default_font_string; }
	CPaletteData	*GetDefaultPaletteData()
	{ return default_palette_data; }

	virtual void		ResetFontData() { }
	virtual void		ResetPaletteData() { }
	virtual void		SetFontData(const string &fd) { }
	virtual void		SetPaletteData(CPaletteData *pd) { }
	virtual void		SetHighlightPalette(CPaletteData *pd) { }
	virtual void		RestorePalette() { }
	virtual bool		SetupViewNodeFont(QFont &f) = 0;
	virtual bool		SetupViewNodePalette(QPalette &p) = 0;

	static void		CreateReplacementSubtree(
		COptionData::SMainViewData *mvd, SReplaceNode &rn, vector<int> *iv);
	virtual COptionData::SMainViewData	*CreateMainViewDataWithReplace(
		string &mvn, bool ddf, SReplaceNode &rn) = 0;
	virtual void	CreateMainViewDataWithReplace(
		COptionData::SMainViewData *mvd, SReplaceNode &rn) = 0;

	CViewNode			*AddNodeBefore(SAddNode &an, CViewNode **rvn);
	CViewNode			*AddNodeAfter(SAddNode &an, CViewNode **rvn);
	CViewNode			*AddNodeSubtree(
		SAddNode &an, CViewNode **rvn, AddNodeType t);
	CViewNode			*CreateAddSubtree(COptionData::SMainViewData *mvd,
		SAddNode &an, AddNodeType t, int index);
	CViewNode			*DeleteNode();
	virtual COptionData::SMainViewData  *ReindexAndCreateMainViewData(
		string &mvn, bool ddf) = 0;
	virtual void	ReindexAndCreateMainViewData(
		COptionData::SMainViewData *mvd, vector<int> &iv) = 0;

	virtual void	CreateRuntimeModuleMap(RuntimeMainViewMap *rmvm) = 0;
	virtual void	StoreRuntimeModulePointers(RuntimeMainViewMap *rmvm) = 0;
	virtual CSubView	*FindSubviewTypePointer(const string &type) = 0;

	protected:
	QWidget				*parent_widget;
	CViewNode			*parent_node;
	CInterfaceControl	*interface_control;
	SMainViewControl	*main_view_control;
	string				default_font_string;
	CPaletteData		*default_palette_data;
	bool				process_close_event_flag;
	bool				node_indicator;
	QPalette			restore_palette;
};

class CSplitterWidget: public QSplitter
{
	Q_OBJECT
	public:
	CSplitterWidget(Qt::Orientation o, QWidget *parent,
					CInterfaceControl *ic, SMainViewControl *mvc)
		: QSplitter(o, parent), interface_control(ic), main_view_control(mvc),
			process_close_event_flag(false) { }
	virtual ~CSplitterWidget() { }

	void	SetProcessCloseEventFlag(bool f) { process_close_event_flag = f; }

	CInterfaceControl   *GetInterfaceControl() const
	{ return interface_control; }
	SMainViewControl	*GetMainViewControl() const
	{ return main_view_control; }

	protected:
	virtual void	closeEvent(QCloseEvent *ev);

	private:
	bool				process_close_event_flag;
	CInterfaceControl	*interface_control;
	SMainViewControl	*main_view_control;
};

class CSplitterView: public CViewNode
{
	public:
	CSplitterView(	QWidget *p,
					CViewNode *n,
					CInterfaceControl *ic,
					SMainViewControl *mvc,
					const string &dfs,
					CPaletteData *dpd,
					COptionData::SSplitterData *d);
	CSplitterView(CViewNode *n, COptionData::SSplitterData *d)
		: CViewNode(n), splitter_data(d), splitter(0) { }

	virtual ~CSplitterView();

	virtual QWidget		*GetWidget() { return splitter; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ splitter->SetProcessCloseEventFlag(f); }
	virtual void		CapturePaneSizes(bool rf = false);
	virtual void		SetPaneSizes();

	virtual COptionData::SViewNodeData::ViewNodeType	GetNodeType()
	{ return COptionData::SViewNodeData::SplitterNode; }
	COptionData::SSplitterData	*GetSplitterOptionData()
	{ return splitter_data; }
	virtual vector<int>		*GetViewNodeIndex()
	{ return splitter_data->GetIndex(); }

	virtual bool		AddViewNode(COptionData::SViewNodeData *d);
	virtual bool		AddViewNode(COptionData::SViewNodeData *d,
									vector<int> &iv);

	int					GetDescendantCount() { return descendants.size(); }
	CViewNode			*GetDescendant(int index);
	void				RemoveDescendant(int index);
	void				AddDescendantBefore(CViewNode *n, int index);
	void				AddDescendantAfter(CViewNode *n, int index);
	virtual CViewNode	*NavigateViewNodeTree(NavigationType nt);
	virtual CViewNode	*LocateViewNode(vector<int> *index);
	virtual CViewNode	*LocateViewNode(vector<int> &iv);

	virtual void		ResetFontData();
	virtual void		ResetPaletteData();
	virtual void		SetFontData(const string &fd);
	virtual void		SetPaletteData(CPaletteData *pd);
	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();
	virtual bool		SetupViewNodeFont(QFont &f);
	virtual bool		SetupViewNodePalette(QPalette &p);

	virtual COptionData::SMainViewData	*CreateMainViewDataWithReplace(
		string &mvn, bool ddf, SReplaceNode &rn);
	virtual void	CreateMainViewDataWithReplace(
		COptionData::SMainViewData *mvd, SReplaceNode &rn);

	virtual COptionData::SMainViewData  *ReindexAndCreateMainViewData(
		string &mvn, bool ddf);
	virtual void	ReindexAndCreateMainViewData(
		COptionData::SMainViewData *mvd, vector<int> &iv);

	virtual void	CreateRuntimeModuleMap(RuntimeMainViewMap *rmvm);
	virtual void	StoreRuntimeModulePointers(RuntimeMainViewMap *rmvm);
	virtual CSubView	*FindSubviewTypePointer(const string &type);

	private:
	COptionData::SSplitterData	*splitter_data;
	CSplitterWidget				*splitter;
	vector<CViewNode *>			descendants;
};

class CSubView: public CViewNode
{
	public:
	CSubView(	QWidget *p,
				CViewNode *n,
				CInterfaceControl *ic,
				SMainViewControl *mvc,
				const string &dfs,
				CPaletteData *dpd,
				COptionData::SSubViewData *d)
		: CViewNode(p, n, ic, mvc, dfs, dpd), subview_data(d) { }
	CSubView(CViewNode *n, COptionData::SSubViewData *d)
		: CViewNode(n), subview_data(d) { }

	virtual ~CSubView() { }

	virtual COptionData::SViewNodeData::ViewNodeType	GetNodeType()
	{ return COptionData::SViewNodeData::SubViewNode; }
	COptionData::SSubViewData	*GetSubViewOptionData()
	{ return subview_data; }
	virtual vector<int>		*GetViewNodeIndex()
	{ return subview_data->GetIndex(); }

	virtual void		CapturePaneSizes(bool rf = false) { return; }
	virtual void		SetPaneSizes() { return; }

	virtual bool		AddViewNode(COptionData::SViewNodeData *d)
						{ return false; }
	virtual bool		AddViewNode(COptionData::SViewNodeData *d,
									vector<int> &iv)
						{ return false; }

	virtual CViewNode	*NavigateViewNodeTree(NavigationType nt);
	virtual CViewNode	*LocateViewNode(vector<int> *index);
	virtual CViewNode	*LocateViewNode(vector<int> &iv);

	virtual void		ResetFontData();
	virtual void		ResetPaletteData();
	virtual void		SetFontData(const string &fd);
	virtual void		SetPaletteData(CPaletteData *pd);
	virtual bool		SetupViewNodeFont(QFont &f);
	virtual bool		SetupViewNodePalette(QPalette &p);

	virtual COptionData::SMainViewData	*CreateMainViewDataWithReplace(
		string &mvn, bool ddf, SReplaceNode &rn);
	virtual void	CreateMainViewDataWithReplace(
		COptionData::SMainViewData *mvd, SReplaceNode &rn);

	virtual COptionData::SMainViewData  *ReindexAndCreateMainViewData(
		string &mvn, bool ddf);
	virtual void	ReindexAndCreateMainViewData(
		COptionData::SMainViewData *mvd, vector<int> &iv);

	virtual void	CreateRuntimeModuleMap(RuntimeMainViewMap *rmvm);
	virtual void	StoreRuntimeModulePointers(RuntimeMainViewMap *rmvm);
	virtual CSubView	*FindSubviewTypePointer(const string &type);

	virtual void	InitializeModulePointers() { }

	ModulePtrMap	&GetModulePtrMap()
	{ return module_ptr_map; }

	protected:
	COptionData::SSubViewData	*subview_data;
	ModulePtrMap				module_ptr_map;
};

class CFrameWidget: public Q3Frame
{
	Q_OBJECT
	public:
	CFrameWidget(	QWidget *parent,
					CInterfaceControl *ic,
					SMainViewControl *mvc)
		: Q3Frame(parent), interface_control(ic),
			main_view_control(mvc), process_close_event_flag(false) { }
	virtual ~CFrameWidget() { }

	void	SetProcessCloseEventFlag(bool f) { process_close_event_flag = f; }

	CInterfaceControl   *GetInterfaceControl() const
	{ return interface_control; }
	SMainViewControl	*GetMainViewControl() const
	{ return main_view_control; }

	protected:
	virtual void	closeEvent(QCloseEvent *ev);

	private:
	bool				process_close_event_flag;
	CInterfaceControl	*interface_control;
	SMainViewControl	*main_view_control;
};

class CVBoxWidget: public Q3VBox
{
	Q_OBJECT
	public:
	CVBoxWidget(	QWidget *parent,
					CInterfaceControl *ic,
					SMainViewControl *mvc)
		: Q3VBox(parent), interface_control(ic),
			main_view_control(mvc), process_close_event_flag(false) { }
	virtual ~CVBoxWidget() { }

	void	SetProcessCloseEventFlag(bool f) { process_close_event_flag = f; }

	CInterfaceControl   *GetInterfaceControl() const
	{ return interface_control; }
	SMainViewControl	*GetMainViewControl() const
	{ return main_view_control; }

	protected:
	virtual void	closeEvent(QCloseEvent *ev);

	private:
	bool				process_close_event_flag;
	CInterfaceControl	*interface_control;
	SMainViewControl	*main_view_control;
};

#endif
