/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include	"memoryAllocator.h"

CMemoryAllocator::SBlock	*CMemoryAllocator::allocate_block()
{
	SBlock	*block = new SBlock;

	block->next				= 0;
	char	*e_array		= new char[block_size * element_size];
	block->element_array	= (void *)e_array;

	char	*current_element = e_array;
	char	*next_element;

	for (int i=0; i<block_size-1; i++)
	{
		next_element = current_element + element_size;
		*(char **)current_element = next_element;
		current_element = next_element;
	}

	*(char **)current_element = 0;

	free_list	= (void *)e_array;

	return block;
}

void	*CMemoryAllocator::allocate_element(size_t size)
{
	if (!free_list)
	{
		SBlock	*block		= allocate_block();
		last_block->next	= block;
		last_block			= block;
	}

	void	*memory = free_list;

	free_list = *(void **)(free_list);

	return memory;
}

void	CMemoryAllocator::release_element(void *ptr)
{
	if (!free_list)
		*(void **)ptr = 0;
	else
		*(void **)ptr = free_list;

	free_list = ptr;
}

CMemoryAllocator::CMemoryAllocator(int e_size, int b_size)
{
	if (b_size < 1)
		block_size = 1;
	else
		block_size = b_size;

	int		ptr_size = sizeof(void *);

	element_size = ptr_size * ((e_size + ptr_size - 1) / ptr_size);

	first_block = allocate_block();
	last_block	= first_block;
}

CMemoryAllocator::~CMemoryAllocator()
{
	SBlock	*current_block = first_block;
	SBlock	*next_block;

	while (current_block)
	{
		next_block = current_block->next;
		delete [] (char *)current_block->element_array;
		delete current_block;
		current_block = next_block;
	}
}
