/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef MEMORYALLOCATOR_H
#define MEMORYALLOCATOR_H

#include	<stdlib.h>
#include	<memory.h>

class CMemoryAllocator
{
	public:
	CMemoryAllocator(int e_size, int b_size);
	~CMemoryAllocator();

	void	*allocate_element(size_t size);
	void	release_element(void *ptr);

	private:
	struct SBlock
	{
		SBlock	*next;
		void	*element_array;
	};
	
	int		element_size;
	int		block_size;
	SBlock	*allocate_block();
	SBlock	*first_block;
	SBlock	*last_block;
	void	*free_list;
};

#endif
