/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "parse.h"

bool	CParse::CalculateParser(ParserType type)
{
	bool	r1 = DerivesTerminal();
	bool	r2 = AccessibleSymbol();
	bool	r  = r1 && r2;

	if (r)
	{
		parser_type = type;

		switch (type)
		{
			case SLR_1:
			DerivesEmpty();
			ItemCores();
			RelationLR0Domain();
			RelationBegins();
			RelationEnds();
			RelationTerminal();
			RelationFirstOf();
			RelationPoints();
			RelationAdjoins();
			RelationFollows();
			RelationLR0Descendant();
			RelationLR0PassesX();
			RelationLR0Machine();
			ComputeLR0Machine();
			ComputeSLR1Lookaheads();
			ComputeSLR1ActionTable();
			DefaultConflictResolution();
			break;

			case LALR_1:
			DerivesEmpty();
			ItemCores();
			RelationLR0Domain();
			RelationBegins();
			RelationEnds();
			RelationTerminal();
			RelationFirstOf();
			RelationPoints();
			RelationAdjoins();
			RelationFollows();
			RelationLR0Descendant();
			RelationLR0PassesX();
			RelationLR0Machine();
			ComputeLR0Machine();
			ComputeLALR1Domains();
			ComputeLALR1Relations();
			ComputeLALR1Lookaheads();
			ComputeLALR1ActionTable();
			DefaultConflictResolution();
			break;

			case LR_1:
			DerivesEmpty();
			ItemCores();
			LR1Items();
			RelationLR1Domain();
			RelationBegins();
			RelationTerminal();
			RelationFirstOf();
			RelationLR1Descendant();
			RelationLR1PassesX();
			RelationLR1Machine();
			ComputeLR1Machine();
			ComputeLR1Lookaheads();
			ComputeLR1ActionTable();
			DefaultConflictResolution();
			break;
		}
	}

	return r;
}

void	CParse::ResetCalculationStatus()
{
	calculation_status = NoCalculation;
}

void	CParse::CalculateEssentialErrorEntries(
						ErrorCalculation c, ErrorFunctionNumbering n)
{
	delete [] error_action_table;

	error_action_table = new int[machine_count * terminal_count_e];

	int		i;
	int		j;
	int		a_offset;
	int		e_index;

	for (i=0; i<machine_count * terminal_count_e; i++)
		error_action_table[i] = action_table[i];

	switch (c)
	{
		case NoCalculation:
		switch (n)
		{
			case OneNumber:
			break;

			case NumberPerState:
			{
				a_offset	= 0;
				e_index		= -1;

				for (i=0; i<machine_count; i++)
				{
					for (j=0; j<terminal_count_e; j++)
						if (error_action_table[a_offset + j] == -1)
							error_action_table[a_offset + j] = e_index;

					a_offset += terminal_count_e;
					e_index--;
				}
			}
			break;

			case NumberPerEntry:
			{
				a_offset	= 0;
				e_index		= -1;

				for (i=0; i<machine_count; i++)
				{
					for (j=0; j<terminal_count_e; j++)
						if (error_action_table[a_offset + j] == -1)
						{
							error_action_table[a_offset + j] = e_index;
							e_index--;
						}

					a_offset += terminal_count_e;
				}
			}
			break;
		}
		break;

		case ApproximateEssential:
		if (calculation_status != ApproximateEssential)
		{
			if (parser_type == LR_1)
				ComputeLR1ErrorEntries();
			else
				ComputeApproximateEssentialErrorEntries();

			calculation_status = c;
		}

		CreateEssentialErrorActionTable(n);
		break;

		case ExactEssential:
		if (calculation_status != ExactEssential)
		{
			if (parser_type == LR_1)
				ComputeLR1ErrorEntries();
			else
				ComputeExactEssentialErrorEntries();

			calculation_status = c;
		}

		CreateEssentialErrorActionTable(n);
		break;
	}
}

void	CParse::CreateEssentialErrorActionTable(ErrorFunctionNumbering n)
{
	int		i;
	int		j;
	int		a_offset;
	int		e_index;

	for (i=0; i<machine_count*terminal_count_e; i++)
		if (essential_error_entries[i])
			error_action_table[i] = -2;

	switch (n)
	{
		case OneNumber:
		break;

		case NumberPerState:
		{
			a_offset	= 0;
			e_index		= -2;

			for (i=0; i<machine_count; i++)
			{
				for (j=0; j<terminal_count_e; j++)
					if (error_action_table[a_offset + j] == -2)
						error_action_table[a_offset + j] = e_index;

				a_offset += terminal_count_e;
				e_index--;
			}
		}
		break;

		case NumberPerEntry:
		{
			a_offset	= 0;
			e_index		= -2;

			for (i=0; i<machine_count; i++)
			{
				for (j=0; j<terminal_count_e; j++)
					if (error_action_table[a_offset + j] == -2)
					{
						error_action_table[a_offset + j] = e_index;
						e_index--;
					}

				a_offset += terminal_count_e;
			}
		}
		break;
	}
}

void	CParse::CalculateUnitRuleElimination(int u_count, int *order_list)
{
	delete [] unit_action_table;
	delete [] unit_goto_table;

	int		maximum_count	= 2 * machine_count;
	int		a_table_size	= maximum_count * terminal_count_e;
	int		g_table_size	= maximum_count * symbol_count_a;

	unit_action_table	= new int[a_table_size];
	unit_goto_table		= new int[g_table_size];

	int		i;
	int		j;

	for (i=0; i<machine_count * terminal_count_e; i++)
		unit_action_table[i] = error_action_table[i];

	for (i=0; i<machine_count * symbol_count_a; i++)
		unit_goto_table[i] = goto_table[i];

	TLeftSymbolGotoList		left_symbol_goto_list(10);

	unit_machine_count = machine_count;

	for (i=0; i<u_count; i++)
	{
		int					reduce	= order_list[i];
		CRuleInformation	&r		= rules[reduce];

		int		left_index		= r.left_symbol_index;
		int		right_index		= r.right_symbol_indexes[0];
		int		current_state	= 0;

		int		a_offset = 0;
		int		g_offset = 0;

		while (current_state < unit_machine_count)
		{
			for (j=0; j<terminal_count_e; j++)
				if (unit_action_table[a_offset + j] == reduce)
					break;

			if (j < terminal_count_e)
			{
				int		from_state;
				int		from_a_offset;
				int		from_g_offset;
				int		to_state;
				int		to_a_offset;
				int		to_g_offset;
				int		merge_state;
				int		merge_a_offset;
				int		merge_g_offset;

				TLeftSymbolGotoListPtr		lsgl_listptr;

				left_symbol_goto_list.Clear();

				from_g_offset = 0;

				for (from_state=0; from_state<unit_machine_count; from_state++)
				{
					if (unit_goto_table[from_g_offset + right_index] ==
						current_state)
					{
						to_state = unit_goto_table[from_g_offset + left_index];

						lsgl_listptr = left_symbol_goto_list.FirstListPtr();

						while (lsgl_listptr)
						{
							CLeftSymbolGoto		&lsg =
								left_symbol_goto_list.Data(lsgl_listptr);

							if (lsg.to_state_index == to_state)
								break;

							left_symbol_goto_list.NextListPtr(lsgl_listptr);
						}

						if (lsgl_listptr)
						{
							CLeftSymbolGoto		&lsg =
								left_symbol_goto_list.Data(lsgl_listptr);

							lsg.from_state_index_list.PushBack(from_state);
						}
						else
						{
							CLeftSymbolGoto		lsg(to_state);

							lsg.from_state_index_list.PushBack(from_state);

							left_symbol_goto_list.PushBack(lsg);
						}
					}

					from_g_offset += symbol_count_a;
				}

				lsgl_listptr = left_symbol_goto_list.FirstListPtr();

				while (lsgl_listptr)
				{
					CLeftSymbolGoto		&lsg =
						left_symbol_goto_list.Data(lsgl_listptr);

					to_state	= lsg.to_state_index;
					to_a_offset	= to_state * terminal_count_e;
					to_g_offset	= to_state * symbol_count_a;

					merge_state		= unit_machine_count;
					merge_a_offset	= merge_state * terminal_count_e;
					merge_g_offset	= merge_state * symbol_count_a;

					for (j=0; j<terminal_count_e; j++)
					{
						if (unit_action_table[a_offset + j] ==
							unit_action_table[to_a_offset + j])
						{
							unit_action_table[merge_a_offset + j] =
								unit_action_table[a_offset + j];
						}
						else if (unit_action_table[a_offset + j] == -1)
						{
							unit_action_table[merge_a_offset + j] =
								unit_action_table[to_a_offset + j];
						}
						else if (unit_action_table[to_a_offset + j]	== -1)
						{
							unit_action_table[merge_a_offset + j] =
								unit_action_table[a_offset + j];
						}
						else if (unit_action_table[a_offset + j] == reduce)
						{
							unit_action_table[merge_a_offset + j] =
								unit_action_table[to_a_offset + j];
						}
						else
							break;
					}

					if (j == terminal_count_e)
					{
						for (j=0; j<symbol_count_a; j++)
						{
							if (unit_goto_table[g_offset + j] ==
								unit_goto_table[to_g_offset + j])
							{
								unit_goto_table[merge_g_offset + j] =
									unit_goto_table[g_offset + j];
							}
							else if (unit_goto_table[g_offset + j] == -1)
							{
								unit_goto_table[merge_g_offset + j] =
									unit_goto_table[to_g_offset + j];
							}
							else if (unit_goto_table[to_g_offset + j] == -1)
							{
								unit_goto_table[merge_g_offset + j] =
									unit_goto_table[g_offset + j];
							}
							else
								break;
						}

						if (j == symbol_count_a)
						{
							VListIntPtr		int_listptr =
								lsg.from_state_index_list.FirstListPtr();

							while (int_listptr)
							{
								from_state = lsg.from_state_index_list.
														NextData(int_listptr);

								from_a_offset	= from_state * terminal_count_e;
								from_g_offset	= from_state * symbol_count_a;
								
								unit_goto_table[from_g_offset + right_index] =
									merge_state;

								unit_goto_table[from_g_offset + left_index] =
									merge_state;
							}

							unit_machine_count++;

							if (unit_machine_count == maximum_count)
							{
								maximum_count *= 2;

								a_table_size = maximum_count * terminal_count_e;
								g_table_size = maximum_count * symbol_count_a;

								int		*u_a_table	= new int[a_table_size];
								int		*u_g_table	= new int[g_table_size];

								for (j=0; j<unit_machine_count *
														terminal_count_e; j++)
									u_a_table[j] = unit_action_table[j];

								for (j=0; j<unit_machine_count *
														symbol_count_a; j++)
									u_g_table[j] = unit_goto_table[j];

								delete [] unit_action_table;
								delete [] unit_goto_table;

								unit_action_table	= u_a_table;
								unit_goto_table		= u_g_table;
							}
						}
					}

					left_symbol_goto_list.NextListPtr(lsgl_listptr);
				}
			}

			a_offset += terminal_count_e;
			g_offset += symbol_count_a;

			current_state++;
		}
	}
}

bool	CParse::ValidateConflict(int index, int state, int symbol, int action)
{
	ListConflict::listptr	c_listptr = parsing_conflicts->FindIndex(index);

	if (!c_listptr)
		return false;

	CConflict	*conflict = parsing_conflicts->Data(c_listptr);

	if (state != conflict->machine_state_index ||
		symbol != conflict->terminal_symbol_index)
		return false;

	if (!conflict->action_set->FindData(action, 0))
		return false;

	return true;
}

void	CParse::ModifyActionTable(int index, int state, int symbol, int action)
{
	ListConflict::listptr	c_listptr = parsing_conflicts->FindIndex(index);

	CConflict	*conflict = parsing_conflicts->Data(c_listptr);

	conflict->resolve_listptr = conflict->action_set->FindData(action, 0);

	int		action_table_index = state * terminal_count_e + symbol;

	if (action == conflict_entry)
		action_table[action_table_index] = conflict_entry + index;
	else
		action_table[action_table_index] = action;
}

bool	CParse::DerivesTerminal()
{
	int		i;
	int		j;
	int		k;

	symbol_status	= new CSymbolStatus[symbol_count_a];

	for (i=0; i<symbol_count_a; i++)
		if (symbols[i].nonterminal_flag)
			symbol_status[i].derives_terminal_flag = false;
		else
			symbol_status[i].derives_terminal_flag = true;

	VListInt		derives_terminal_list(nonterminal_count_a);
	VListInt		pending_list(nonterminal_count_a);

	for (i=0; i<nonterminal_count_a; i++)
		pending_list.PushBack(nonterminal_indexes[i]);

	while (1)
	{
		int		previous_pending_list_count = pending_list.Size();

		VListInt::listptr	pending_listptr = pending_list.FirstListPtr();

		while (pending_listptr)
		{
			int		index = pending_list.Data(pending_listptr);

			CSymbolInformation	&si = symbols[index];

			for (i=0; i<si.left_symbol_count; i++)
			{
				CRuleInformation	&ri = rules[si.left_symbol_indexes[i]];

				for (j=0; j<ri.right_symbol_count; j++)
				{
					k = ri.right_symbol_indexes[j];
					if (!symbol_status[k].derives_terminal_flag)
						break;
				}

				if (j == ri.right_symbol_count)
					break;
			}

			if (i == si.left_symbol_count)
			{
				pending_list.NextData(pending_listptr);
			}
			else
			{
				pending_listptr = pending_list.Erase(pending_listptr);
				derives_terminal_list.PushBack(index);
				symbol_status[index].derives_terminal_flag = true;
			}
		}

		if (previous_pending_list_count == pending_list.Size())
			break;
		else
			previous_pending_list_count = pending_list.Size();
	}

	if (pending_list.Size())
		derives_terminal_flag = false;
	else
		derives_terminal_flag = true;

	return derives_terminal_flag;
}

bool	CParse::AccessibleSymbol()
{
	int		i;
	int		j;

	for (i=0; i<symbol_count_a; i++)
		symbol_status[i].accessible_flag = false;

	VListOrdPairInt		*contains = new VListOrdPairInt(rule_count_a);

	for (i=0; i<rule_count_a; i++)
	{
		CRuleInformation	&ri = rules[i];

		for (j=0; j<ri.right_symbol_count; j++)

			contains->PushBack(OrdPairInt(	ri.left_symbol_index,
											ri.right_symbol_indexes[j]));
	}

	RelationInt		*r = new RelationInt(contains);
	
	RelationInt		*closure =
		ImageClosure<int>(r, augmented_symbol_index, symbol_count_a);

	VListOrdPairInt				*pair_list = closure->pairs;
	VListOrdPairInt::listptr	pair_listptr;

	pair_listptr = pair_list->FirstListPtr();

	while (pair_listptr)
		symbol_status[pair_list->NextData(pair_listptr).Second()].
														accessible_flag = true;

	if (pair_list->Size() < symbol_count_a)
		accessible_flag = false;
	else
		accessible_flag = true;

	delete closure;
	delete r;

	return accessible_flag;
}

void	CParse::DerivesEmpty()
{
	int		i;
	int		j;
	int		k;

	for (i=0; i<symbol_count_a; i++)
		symbol_status[i].derives_empty_flag = false;

	VListInt		derives_empty_list(nonterminal_count_a);
	VListInt		pending_list(nonterminal_count_a);

	for (i=0; i<nonterminal_count_a; i++)
		pending_list.PushBack(nonterminal_indexes[i]);

	while (1)
	{
		int		previous_pending_list_count = pending_list.Size();

		VListInt::listptr	pending_listptr = pending_list.FirstListPtr();

		while (pending_listptr)
		{
			int		index = pending_list.Data(pending_listptr);

			CSymbolInformation	&si = symbols[index];

			for (i=0; i<si.left_symbol_count; i++)
			{
				CRuleInformation	&ri = rules[si.left_symbol_indexes[i]];

				if (!ri.right_symbol_count)
					break;

				for (j=0; j<ri.right_symbol_count; j++)
				{
					k = ri.right_symbol_indexes[j];
					if (!symbol_status[k].derives_empty_flag)
						break;
				}

				if (j == ri.right_symbol_count)
					break;
			}

			if (i == si.left_symbol_count)
			{
				pending_list.NextData(pending_listptr);
			}
			else
			{
				pending_listptr = pending_list.Erase(pending_listptr);
				derives_empty_list.PushBack(index);
				symbol_status[index].derives_empty_flag = true;
			}
		}

		if (previous_pending_list_count == pending_list.Size())
			break;
		else
			previous_pending_list_count = pending_list.Size();
	}

	if (pending_list.Size() == nonterminal_count_a)
		derives_empty_flag = false;
	else
		derives_empty_flag = true;
}

void	CParse::ItemCores()
{
	int		i;
	int		j;

	item_core_count		= 0;
	item_points_count	= 0;

	for (i=0; i<rule_count_a; i++)
	{
		CRuleInformation	&ri = rules[i];

		ri.item_core_block_index = item_core_count;

		item_core_count		+= ri.right_symbol_count + 1;
		item_points_count	+= ri.right_symbol_count;
	}

	item_cores = new CItemCore[item_core_count];

	maximum_right_symbol_count = 0;

	for (i=0; i<rule_count_a; i++)
	{
		CRuleInformation	&ri = rules[i];

		if (maximum_right_symbol_count < ri.right_symbol_count)
			maximum_right_symbol_count = ri.right_symbol_count;

		for (j=0; j<=ri.right_symbol_count; j++)
		{
			item_cores[ri.item_core_block_index + j].
							Initialize(ri.item_core_block_index + j, i, j);
		}

		item_cores[ri.item_core_block_index + j - 1].reduce_item_flag = true;
	}
}

void	CParse::LR1Items()
{
	int		i;
	int		j;

	lr1_item_count = 0;

	for (i=0; i<item_core_count; i++)
	{
		CItemCore	&ic = item_cores[i];

		ic.lr1_item_block_index = lr1_item_count;

		lr1_item_count += terminal_count_e + 1;
	}

	lr1_items = new CLR1Item[lr1_item_count];

	for (i=0; i<item_core_count; i++)
	{
		CItemCore	&ic = item_cores[i];

		for (j=0; j<terminal_count_e; j++)
		{
			lr1_items[ic.lr1_item_block_index + j].
							Initialize(ic.lr1_item_block_index + j, i, j);
		}

		lr1_items[ic.lr1_item_block_index + j].
						Initialize(ic.lr1_item_block_index + j, i, -1);
	}
}

void	CParse::RelationLR0Domain()
{
	int		domain_size = 	symbol_count_a > item_core_count ?
							symbol_count_a : item_core_count;

	relation_domain = new VListInt(domain_size);

	int i;
	for (i=0; i<domain_size; i++)
		relation_domain->PushBack(i);
}

void	CParse::RelationLR1Domain()
{
	int		domain_size = 	symbol_count_a > lr1_item_count ?
							symbol_count_a : lr1_item_count;

	relation_domain = new VListInt(domain_size);

	int i;
	for (i=0; i<domain_size; i++)
		relation_domain->PushBack(i);
}

void	CParse::RelationBegins()
{
	VListOrdPairInt		*bp = new VListOrdPairInt(rule_count_a);

	int		i;
	int		j;

	unsigned int	array_size = ((symbol_count_a * symbol_count_a) +
						bool_per_unsigned_long - 1) / bool_per_unsigned_long;

	bool	added_flags[array_size * bool_per_unsigned_long];

	unsigned int	*af = (unsigned int *)added_flags;
	for (i=0; i<array_size; i++)
		af[i] = 0;

	for (i=0; i<rule_count_a; i++)
	{
		CRuleInformation	&ri = rules[i];

		if (ri.right_symbol_count)
		{
			int		first	= ri.right_symbol_indexes[0];
			int		second	= ri.left_symbol_index;
			int		index	= symbol_count_a * first + second;

			if (!added_flags[index])
			{
				bp->PushBack(OrdPairInt(first, second));
				added_flags[index] = true;
			}

			for (j=1; j<ri.right_symbol_count; j++)
			{
				if (!symbol_status[ri.right_symbol_indexes[j - 1]].
													derives_empty_flag)
						break;
				else
				{
					first	= ri.right_symbol_indexes[j];
					second	= ri.left_symbol_index;
					index	= symbol_count_a * first + second;

					if (!added_flags[index])
					{
						bp->PushBack(OrdPairInt(first, second));
						added_flags[index] = true;
					}
				}
			}
		}
	}

	begins = new RelationInt(bp);
}

void	CParse::RelationEnds()
{
	VListOrdPairInt		*ep = new VListOrdPairInt(rule_count_a);

	int		i;
	int		j;

	unsigned int	array_size = ((symbol_count_a * symbol_count_a) +
						bool_per_unsigned_long - 1) / bool_per_unsigned_long;

	bool	added_flags[array_size * bool_per_unsigned_long];

	unsigned int	*af = (unsigned int *)added_flags;
	for (i=0; i<array_size; i++)
		af[i] = 0;

	for (i=0; i<rule_count_a; i++)
	{
		CRuleInformation	&ri = rules[i];

		if (ri.right_symbol_count)
		{
			int	first	= ri.right_symbol_indexes[ri.right_symbol_count - 1];
			int	second	= ri.left_symbol_index;
			int	index	= symbol_count_a * first + second;

			if (!added_flags[index])
			{
				ep->PushBack(OrdPairInt(first, second));
				added_flags[index] = true;
			}

			for (j=ri.right_symbol_count-2; j>=0; j--)
			{
				if (!symbol_status[ri.right_symbol_indexes[j + 1]].
													derives_empty_flag)
						break;
				else
				{
					first	= ri.right_symbol_indexes[j];
					second	= ri.left_symbol_index;
					index	= symbol_count_a * first + second;

					if (!added_flags[index])
					{
						ep->PushBack(OrdPairInt(first, second));
						added_flags[index] = true;
					}
				}
			}
		}
	}

	ends = new RelationInt(ep);
}

void	CParse::RelationTerminal()
{
	VListOrdPairInt		*tp = new VListOrdPairInt(terminal_count_e);

	int		i;

	for (i=0; i<terminal_count_e; i++)
		tp->PushBack(OrdPairInt(terminal_indexes[i], terminal_indexes[i]));

	terminal = new RelationInt(tp);
}

void	CParse::RelationFirstOf()
{
	RelationInt		*closure_of_begins =
		ReflexiveTransitiveClosure(begins, relation_domain, symbol_count_a);

	first_of = Composition(	terminal,
							closure_of_begins,
							symbol_count_a,
							symbol_count_a,
							symbol_count_a);

	delete closure_of_begins;
}

void	CParse::RelationPoints()
{
	VListOrdPairInt	*p_points		= new VListOrdPairInt(item_points_count);
	VListOrdPairInt	*p_passes_any	= new VListOrdPairInt(item_points_count);
	VListOrdPairInt	*p_passes_null	= new VListOrdPairInt(item_points_count);

	int		i;
	int		j;

	for (i=0; i<rule_count_a; i++)
	{
		CRuleInformation	&ri = rules[i];

		for (j=0; j<ri.right_symbol_count; j++)
		{
			int		item_core_index = ri.item_core_block_index + j;

			p_points->PushBack(OrdPairInt(	item_core_index,
											ri.right_symbol_indexes[j]));

			p_passes_any->PushBack(OrdPairInt(	item_core_index,
												item_core_index + 1));

			if (symbol_status[ri.right_symbol_indexes[j]].derives_empty_flag)
				p_passes_null->PushBack(OrdPairInt(	item_core_index,
													item_core_index + 1));
		}
	}

	points		= new RelationInt(p_points);
	passes_any	= new RelationInt(p_passes_any);
	passes_null	= new RelationInt(p_passes_null);
}

void	CParse::RelationAdjoins()
{
	if (passes_null->count)
	{
		RelationInt		*inverse_of_points = points->Inverse();

		RelationInt		*closure_of_passes_null =
			ReflexiveTransitiveClosure(	passes_null,
										relation_domain,
										item_core_count);

		RelationInt		*c1 = Composition(	inverse_of_points,
											passes_any,
											symbol_count_a,
											item_core_count,
											item_core_count);

		RelationInt		*c2 = Composition(	c1,
											closure_of_passes_null,
											symbol_count_a,
											item_core_count,
											item_core_count);

		adjoins = Composition(	c2,
								points,
								symbol_count_a,
								item_core_count,
								symbol_count_a);

		delete inverse_of_points;
		delete closure_of_passes_null;
		delete c1;
		delete c2;
	}
	else
	{
		RelationInt		*inverse_of_points = points->Inverse();

		RelationInt		*c1 = Composition(	inverse_of_points,
											passes_any,
											symbol_count_a,
											item_core_count,
											item_core_count);

		adjoins = Composition(	c1,
								points,
								symbol_count_a,
								item_core_count,
								symbol_count_a);

		delete inverse_of_points;
		delete c1;
	}
}

void	CParse::RelationFollows()
{
	RelationInt		*inverse_of_adjoins	= adjoins->Inverse();
	RelationInt		*inverse_of_ends	= ends->Inverse();

	RelationInt		*closure_of_inverse_of_ends =
		ReflexiveTransitiveClosure(	inverse_of_ends,
									relation_domain,
									symbol_count_a);

	RelationInt		*c1 = Composition(	first_of,
										inverse_of_adjoins,
										symbol_count_a,
										symbol_count_a,
										symbol_count_a);

	follows = Composition(	c1,
							closure_of_inverse_of_ends,
							symbol_count_a,
							symbol_count_a,
							symbol_count_a);

	delete inverse_of_adjoins;
	delete inverse_of_ends;
	delete closure_of_inverse_of_ends;
	delete c1;
}

void	CParse::RelationLR0Descendant()
{
	VListOrdPairInt		*dp = new VListOrdPairInt(item_core_count);

	int		i;
	int		j;

	for (i=0; i<item_core_count; i++)
	{
		CItemCore	&ic = item_cores[i];

		CRuleInformation	&ri = rules[ic.rule_index];

		if (ic.right_symbol_after_dot_index < ri.right_symbol_count)
		{
			CSymbolInformation	&si = symbols[ri.right_symbol_indexes[
											ic.right_symbol_after_dot_index]];

			if (si.nonterminal_flag)
			{
				for (j=0; j<si.left_symbol_count; j++)
					dp->PushBack(
						OrdPairInt(i, rules[si.left_symbol_indexes[j]].
													item_core_block_index));
			}
		}
	}

	lr0descendant = new RelationInt(dp);
}

void	CParse::LR1First()
{
	lr1_first_symbols->Clear();

	int		prefix_count = lr1_first_prefix->Size();

	if (prefix_count)
	{
		int		i;
		int		j;
		bool	symbol_set[symbol_count_a];
		bool	null_flag = true;

		for (i=0; i<symbol_count_a; i++)
			symbol_set[i] = false;

		VListInt::listptr	prefix_listptr = lr1_first_prefix->FirstListPtr();

		for (i=0; i<prefix_count; i++)
		{
			int p = lr1_first_prefix->NextData(prefix_listptr);

			CSymbolInformation	&si = symbols[p];

			if (si.nonterminal_flag)
			{
				for (j=0; j<si.first_count; j++)
					symbol_set[si.first_x[j]] = true;

				if (!symbol_status[p].derives_empty_flag)
				{
					null_flag = false;
					break;
				}
			}
			else
			{
				symbol_set[p]	= true;
				null_flag		= false;
				break;
			}
		}

		for (i=0; i<symbol_count_a; i++)
			if (symbol_set[i])
				lr1_first_symbols->PushBack(i);

		if (null_flag)
		{
			if (lookahead_terminal_index != -1)
			{
				lr1_first_symbols->PushBack(lookahead_terminal_index);
			}
			else
			{
				lr1_first_symbols->PushBack(-1);
			}
		}
	}
	else
	{
		if (lookahead_terminal_index != -1)
		{
			lr1_first_symbols->PushBack(lookahead_terminal_index);
		}
		else
		{
			lr1_first_symbols->PushBack(-1);
		}
	}
}

void	CParse::RelationLR1Descendant()
{
	int		i;
	int		j;

	RelationInt		*inverse_of_first_of = first_of->Inverse();
	VListInt		first_symbol(2);

	for (i=0; i<symbol_count_a; i++)
	{
		first_symbol.PushBack(i);

		VListInt	*first_list  = SubsetImage(	inverse_of_first_of,
												&first_symbol,
												symbol_count_a,
												symbol_count_a);

		int		first_count = first_list->Size();

		if (first_count)
		{
			CSymbolInformation	&si = symbols[i];

			si.first_count	= first_count;
			si.first_x		= new int[first_count];

			VListInt::listptr	first_listptr =
										first_list->FirstListPtr();

			for (j=0; j<first_count; j++)
			{
				int f = first_list->NextData(first_listptr);

				si.first_x[j] = f;
			}
		}

		delete first_list;

		first_symbol.PopBack();
	}

	delete inverse_of_first_of;

	lr1_first_prefix	= new VListInt();
	lr1_first_symbols	= new VListInt();

	VListOrdPairInt		*dp = new VListOrdPairInt(lr1_item_count);

	for (i=0; i<lr1_item_count; i++)
	{
		CLR1Item	&lri = lr1_items[i];

		CItemCore	&ic = item_cores[lri.item_core_index];

		CRuleInformation	&ri = rules[ic.rule_index];

		if (ic.right_symbol_after_dot_index < ri.right_symbol_count)
		{
			CSymbolInformation	&si = symbols[ri.right_symbol_indexes[
											ic.right_symbol_after_dot_index]];

			if (si.nonterminal_flag)
			{
				lr1_first_prefix->Clear();

				for (j=ic.right_symbol_after_dot_index+1;
						j<ri.right_symbol_count; j++)
					lr1_first_prefix->PushBack(ri.right_symbol_indexes[j]);

				lookahead_terminal_index = lri.lookahead_terminal_index;

				LR1First();

				for (j=0; j<si.left_symbol_count; j++)
				{
					CRuleInformation	&rrii =
											rules[si.left_symbol_indexes[j]];

					CItemCore	&iicc = item_cores[rrii.item_core_block_index];

					VListInt::listptr	symbols_listptr =
											lr1_first_symbols->FirstListPtr();

					while (symbols_listptr)
					{
						int s = lr1_first_symbols->NextData(symbols_listptr);

						if (s != -1)
						{
							dp->PushBack(OrdPairInt(i,
								iicc.lr1_item_block_index + s));
						}
						else
						{
							dp->PushBack(OrdPairInt(i,
								iicc.lr1_item_block_index + terminal_count_e));
						}
					}
				}
			}
		}
	}

	lr1descendant = new RelationInt(dp);
}

void	CParse::RelationLR0PassesX()
{
	int		i;
	int		j;

	for (i=0; i<rule_count_a; i++)
	{
		CRuleInformation	&ri = rules[i];

		for (j=0; j<ri.right_symbol_count; j++)
			symbols[ri.right_symbol_indexes[j]].right_symbol_count++;
	}

	VListOrdPairInt	**ptr_array = new (VListOrdPairInt *[symbol_count_a]);

	for (i=0; i<symbol_count_a; i++)
		ptr_array[i] = new VListOrdPairInt(symbols[i].right_symbol_count);

	for (i=0; i<rule_count_a; i++)
	{
		CRuleInformation	&ri = rules[i];

		for (j=0; j<ri.right_symbol_count; j++)
		{
			int		item_core_index = ri.item_core_block_index + j;

			ptr_array[ri.right_symbol_indexes[j]]->PushBack(
					OrdPairInt(item_core_index, item_core_index + 1));
		}
	}

	for (i=0; i<symbol_count_a; i++)
		symbols[i].lr0_passes_x = new RelationInt(ptr_array[i]);
}

void	CParse::RelationLR1PassesX()
{
	int		i;
	int		j;
	int		k;

	for (i=0; i<rule_count_a; i++)
	{
		CRuleInformation	&ri = rules[i];

		for (j=0; j<ri.right_symbol_count; j++)
			symbols[ri.right_symbol_indexes[j]].right_symbol_count++;
	}

	VListOrdPairInt	**ptr_array = new (VListOrdPairInt *[symbol_count_a]);

	for (i=0; i<symbol_count_a; i++)
		ptr_array[i] = new VListOrdPairInt(symbols[i].right_symbol_count *
											(terminal_count_e + 1));

	for (i=0; i<rule_count_a; i++)
	{
		CRuleInformation	&ri = rules[i];

		for (j=0; j<ri.right_symbol_count; j++)
		{
			int		item_core_index = ri.item_core_block_index + j;

			CItemCore	&ic1 = item_cores[item_core_index];
			CItemCore	&ic2 = item_cores[item_core_index + 1];

			for (k=0; k<=terminal_count_e; k++)
				ptr_array[ri.right_symbol_indexes[j]]->PushBack(
					OrdPairInt(	ic1.lr1_item_block_index + k,
								ic2.lr1_item_block_index + k));
		}
	}

	for (i=0; i<symbol_count_a; i++)
		symbols[i].lr1_passes_x = new RelationInt(ptr_array[i]);
}

void	CParse::RelationLR0Machine()
{
	lr0closure = ReflexiveTransitiveClosure(lr0descendant,
											relation_domain,
											item_core_count);

	int	i;
	for (i=0; i<symbol_count_a; i++)
		symbols[i].lr0_transition = Composition(symbols[i].lr0_passes_x,
												lr0closure,
												item_core_count,
												item_core_count,
												item_core_count);
}

void	CParse::RelationLR1Machine()
{
	lr1closure = ReflexiveTransitiveClosure(lr1descendant,
											relation_domain,
											lr1_item_count);

	int	i;
	for (i=0; i<symbol_count_a; i++)
		symbols[i].lr1_transition = Composition(symbols[i].lr1_passes_x,
												lr1closure,
												lr1_item_count,
												lr1_item_count,
												lr1_item_count);
}

VListInt			*CItemIndexNode::item_list;
VListInt::listptr	CItemIndexNode::item_listptr;
CItemIndexNode		*CItemIndexNode::final_node;
bool				CItemIndexNode::existing_machine_state;
CMemoryAllocator	*CItemIndexNode::allocator;

void	CItemIndexNode::SetupAllocator(int block_size)
{
	allocator = new CMemoryAllocator(sizeof(CItemIndexNode), block_size);
}

void	CParse::ComputeLR0Machine()
{
	VListInt			item_core_list(10);

	CSymbolInformation	&si = symbols[augmented_symbol_index];

	int		i;
	int		j;

	for (i=0; i<si.left_symbol_count; i++)
		item_core_list.PushBack(rules[si.left_symbol_indexes[i]].
														item_core_block_index);

	VListInt	*start_state_item_list  = SubsetImage(	lr0closure,
														&item_core_list,
														item_core_count,
														item_core_count);
	VListInt::listptr	start_state_item_listptr =
							start_state_item_list->FirstListPtr();

	lr0_machine_states	= new ListLR0MS(item_core_count);

	ListLR0MS::listptr	lr0ms_listptr;
	VListListLR0MSptr	pending_states(item_core_count);

	CItemIndexNode::SetupAllocator(item_core_count);

	CItemIndexNode	*item_index_tree		= new CItemIndexNode(0, -1, false);
	CItemIndexNode	*item_index_node_ptr	= item_index_tree;

	CItemIndexNode::item_list		= start_state_item_list;
	CItemIndexNode::item_listptr	= start_state_item_listptr;

	while (item_index_node_ptr)
		item_index_node_ptr = item_index_node_ptr->InsertOrMatch();

	CLR0MachineState	*new_state =
				new CLR0MachineState(0, start_state_item_list);

	lr0ms_listptr = lr0_machine_states->PushBack(new_state);

	CItemIndexNode::final_node->machine_state_flag		= true;
	CItemIndexNode::final_node->machine_state_listptr	= lr0ms_listptr;

	pending_states.PushBack(lr0ms_listptr);

	while (1)
	{
		VListListLR0MSptr::listptr	pending_listptr =
										pending_states.FirstListPtr();

		if (!pending_listptr)
			break;

		lr0ms_listptr = pending_states.FirstData();
		pending_states.PopFront();

		CLR0MachineState	*lr0ms	= lr0_machine_states->Data(lr0ms_listptr);

		for (i=0; i<symbol_count_a; i++)
		{
			CSymbolInformation		&si = symbols[i];

			VListInt	*potential_state_item_list =
									SubsetImage(si.lr0_transition,
												lr0ms->item_set,
												item_core_count,
												item_core_count);

			if (potential_state_item_list->Size())
			{
				VListInt::listptr	potential_state_item_listptr =
								potential_state_item_list->FirstListPtr();

				CItemIndexNode::item_list		= potential_state_item_list;
				CItemIndexNode::item_listptr	= potential_state_item_listptr;

				item_index_node_ptr	= item_index_tree;
				while (item_index_node_ptr)
					item_index_node_ptr = item_index_node_ptr->InsertOrMatch();

				if (CItemIndexNode::existing_machine_state)
				{
					delete potential_state_item_list;

					CLR0MachineState	*existing_state =
					lr0_machine_states->Data(
						CItemIndexNode::final_node->machine_state_listptr);

					lr0ms->state_transitions->PushBack(
									STOrderedPair<int, int>
									(i, existing_state->machine_state_index));
				}
				else
				{
					CLR0MachineState	*new_state =
						new CLR0MachineState(lr0_machine_states->Size(),
												potential_state_item_list);

					lr0ms->state_transitions->PushBack(
										STOrderedPair<int, int>
										(i, new_state->machine_state_index));

					lr0ms_listptr = lr0_machine_states->PushBack(new_state);

					pending_states.PushBack(lr0ms_listptr);

					CItemIndexNode::final_node->machine_state_flag		= true;
					CItemIndexNode::final_node->machine_state_listptr	=
																lr0ms_listptr;
				}
			}
			else
				delete potential_state_item_list;
		}
	}

	delete item_index_tree;
	delete CItemIndexNode::allocator;

	machine_count = lr0_machine_states->Size();

	machine = new CMachineInformation[machine_count];

	lr0ms_listptr = lr0_machine_states->FirstListPtr();

	contains_item_count		= 0;
	transition_count		= 0;
	on_nonterminal_count	= 0;
	on_nullable_count		= 0;

	for (i=0; i<machine_count; i++)
	{
		CLR0MachineState	*ms = lr0_machine_states->NextData(lr0ms_listptr);

		int					machine_state_index	= ms->machine_state_index;
		VListInt			*item_set			= ms->item_set;
		VListOrdPairInt		*state_transitions	= ms->state_transitions;

		machine[i].Initialize(	machine_state_index,
								item_set->Size(),
								state_transitions->Size());

		transition_count += state_transitions->Size();

		VListInt::listptr	item_set_listptr = item_set->FirstListPtr();

		for (j=0; j<item_set->Size(); j++)
		{
			int		item_core_index = item_set->NextData(item_set_listptr);

			machine[i].item_core_set[j] = item_core_index;

			if (item_cores[item_core_index].reduce_item_flag)
				contains_item_count++;
		}

		VListOrdPairInt::listptr	state_transitions_listptr =
										state_transitions->FirstListPtr();

		for (j=0; j<state_transitions->Size(); j++)
		{
			STOrderedPair<int, int>		pair =
				state_transitions->NextData(state_transitions_listptr);

			machine[i].state_transitions[j] =
				CStateTransition(pair.First(), pair.Second());

			if (symbols[pair.First()].nonterminal_flag)
			{
				on_nonterminal_count++;

				if (symbol_status[pair.First()].derives_empty_flag)
					on_nullable_count++;
			}
		}
	}
}

void	CParse::ComputeLR1Machine()
{
	VListInt			lr1_item_list(10);

	CSymbolInformation	&si = symbols[augmented_symbol_index];

	int		i;
	int		j;

	for (i=0; i<si.left_symbol_count; i++)
	{
		CRuleInformation	&ri = rules[si.left_symbol_indexes[i]];

		CItemCore	&ic = item_cores[ri.item_core_block_index];

		lr1_item_list.PushBack(ic.lr1_item_block_index + terminal_count_e);
	}

	VListInt	*start_state_item_list  = SubsetImage(	lr1closure,
														&lr1_item_list,
														lr1_item_count,
														lr1_item_count);

	VListInt::listptr	start_state_item_listptr =
							start_state_item_list->FirstListPtr();

	lr1_machine_states	= new ListLR1MS(lr1_item_count);

	ListLR1MS::listptr	lr1ms_listptr;
	VListListLR1MSptr	pending_states(lr1_item_count);

	CItemIndexNode::SetupAllocator(lr1_item_count);

	CItemIndexNode	*item_index_tree		= new CItemIndexNode(0, -1, false);
	CItemIndexNode	*item_index_node_ptr	= item_index_tree;

	CItemIndexNode::item_list		= start_state_item_list;
	CItemIndexNode::item_listptr	= start_state_item_listptr;

	while (item_index_node_ptr)
		item_index_node_ptr = item_index_node_ptr->InsertOrMatch();

	CLR1MachineState	*new_state =
				new CLR1MachineState(0, start_state_item_list);

	lr1ms_listptr = lr1_machine_states->PushBack(new_state);

	CItemIndexNode::final_node->machine_state_flag		= true;
	CItemIndexNode::final_node->machine_state_listptr	= lr1ms_listptr;

	pending_states.PushBack(lr1ms_listptr);

	while (1)
	{
		VListListLR1MSptr::listptr	pending_listptr =
										pending_states.FirstListPtr();

		if (!pending_listptr)
			break;

		lr1ms_listptr = pending_states.FirstData();
		pending_states.PopFront();

		CLR1MachineState	*lr1ms	= lr1_machine_states->Data(lr1ms_listptr);

		for (i=0; i<symbol_count_a; i++)
		{
			CSymbolInformation		&si = symbols[i];

			VListInt	*potential_state_item_list =
									SubsetImage(si.lr1_transition,
												lr1ms->item_set,
												lr1_item_count,
												lr1_item_count);

			if (potential_state_item_list->Size())
			{
				VListInt::listptr	potential_state_item_listptr =
								potential_state_item_list->FirstListPtr();

				CItemIndexNode::item_list		= potential_state_item_list;
				CItemIndexNode::item_listptr	= potential_state_item_listptr;

				item_index_node_ptr	= item_index_tree;
				while (item_index_node_ptr)
					item_index_node_ptr = item_index_node_ptr->InsertOrMatch();

				if (CItemIndexNode::existing_machine_state)
				{
					delete potential_state_item_list;

					CLR1MachineState	*existing_state =
					lr1_machine_states->Data(
						CItemIndexNode::final_node->machine_state_listptr);

					lr1ms->state_transitions->PushBack(
									STOrderedPair<int, int>
									(i, existing_state->machine_state_index));
				}
				else
				{
					CLR1MachineState	*new_state =
						new CLR1MachineState(lr1_machine_states->Size(),
												potential_state_item_list);

					lr1ms->state_transitions->PushBack(
										STOrderedPair<int, int>
										(i, new_state->machine_state_index));

					lr1ms_listptr = lr1_machine_states->PushBack(new_state);

					pending_states.PushBack(lr1ms_listptr);

					CItemIndexNode::final_node->machine_state_flag		= true;
					CItemIndexNode::final_node->machine_state_listptr	=
																lr1ms_listptr;
				}
			}
			else
				delete potential_state_item_list;
		}
	}

	delete item_index_tree;
	delete CItemIndexNode::allocator;

	machine_count = lr1_machine_states->Size();

	lr1_machine = new CLR1MachineInformation[machine_count];

	lr1ms_listptr = lr1_machine_states->FirstListPtr();

	transition_count = 0;

	for (i=0; i<machine_count; i++)
	{
		CLR1MachineState	*ms = lr1_machine_states->NextData(lr1ms_listptr);

		int					machine_state_index	= ms->machine_state_index;
		VListInt			*item_set			= ms->item_set;
		VListOrdPairInt		*state_transitions	= ms->state_transitions;

		lr1_machine[i].Initialize(	machine_state_index,
									item_set->Size(),
									state_transitions->Size());

		transition_count += state_transitions->Size();

		VListInt::listptr	item_set_listptr = item_set->FirstListPtr();

		for (j=0; j<item_set->Size(); j++)
		{
			int		lr1_item_index = item_set->NextData(item_set_listptr);

			lr1_machine[i].lr1_item_set[j] = lr1_item_index;
		}

		VListOrdPairInt::listptr	state_transitions_listptr =
										state_transitions->FirstListPtr();

		for (j=0; j<state_transitions->Size(); j++)
		{
			STOrderedPair<int, int>		pair =
				state_transitions->NextData(state_transitions_listptr);

			lr1_machine[i].state_transitions[j] =
				CStateTransition(pair.First(), pair.Second());
		}
	}
}

void	CParse::ComputeLALR1Domains()
{
	on_nonterminal	= new COnNonterminal[on_nonterminal_count];
	contains_item	= new CContainsItem[contains_item_count];

	VListOrdPairInt		*tp = new VListOrdPairInt(transition_count);
	VListOrdPairInt		*gp = new VListOrdPairInt(on_nonterminal_count);
	VListOrdPairInt		*np = new VListOrdPairInt(on_nullable_count);

	int		i;
	int		j;
	int		on_index = 0;
	int		ci_index = 0;

	goto_table			= new int[machine_count * symbol_count_a];
	on_nonterminal_map	= new int[machine_count * symbol_count_a];

	for (i=0; i<machine_count*symbol_count_a; i++)
	{
		goto_table[i]			= -1;
		on_nonterminal_map[i]	= -1;
	}

	contains_table = new int[machine_count * rule_count_a];

	for (i=0; i<machine_count*rule_count_a; i++)
		contains_table[i] = -1;

	for (i=0; i<machine_count; i++)
	{
		CMachineInformation		&mi = machine[i];

		for (j=0; j<mi.state_transition_count; j++)
		{
			int	symbol_index	= mi.state_transitions[j].symbol_index;
			int	state_index		= mi.state_transitions[j].machine_state_index;

			goto_table[i * symbol_count_a + symbol_index] = state_index;

			tp->PushBack(OrdPairInt(i, symbol_index));

			if (symbols[symbol_index].nonterminal_flag)
			{
				on_nonterminal[on_index].Initialize(i, symbol_index);

				on_nonterminal_map[i * symbol_count_a + symbol_index] =
																on_index;

				gp->PushBack(OrdPairInt(on_index, state_index));

				if (symbol_status[symbol_index].derives_empty_flag)
					np->PushBack(OrdPairInt(i, on_index));

				on_index++;
			}
		}

		for (j=0; j<mi.item_core_count; j++)
		{
			int		item_core_index	= mi.item_core_set[j];

			if (item_cores[item_core_index].reduce_item_flag)
			{
				contains_item[ci_index].Initialize(i, item_core_index);

				contains_table[i * rule_count_a +
						item_cores[item_core_index].rule_index] = ci_index;

				ci_index++;
			}
		}
	}

	has_transition_on	= new RelationInt(tp);
	goes_to				= new RelationInt(gp);
	has_null_transition	= new RelationInt(np);
}

void	CParse::ComputeLALR1Relations()
{
	VListOrdPairInt		*ip = new VListOrdPairInt(on_nonterminal_count);
	VListOrdPairInt		*lp = new VListOrdPairInt(on_nonterminal_count);

	int		*goto_states		= new int[maximum_right_symbol_count + 1];
	int		*pivot_nonterminal	= new int[maximum_right_symbol_count];
	
	int		i;
	int		j;
	int		k;
	int		rightmost_goto;
	int		leftmost_pivot;

	for (i=0; i<on_nonterminal_count; i++)
	{
		COnNonterminal		&on = on_nonterminal[i];
		CSymbolInformation	&si = symbols[on.nonterminal_index];

		for (j=0; j<si.left_symbol_count; j++)
		{
			CRuleInformation	&ri = rules[si.left_symbol_indexes[j]];

			int	rightmost_index		= ri.right_symbol_count - 1;

			if (rightmost_index < 0)
				continue;

			int	rightmost_symbol	= ri.right_symbol_indexes[rightmost_index];

			if (!symbols[rightmost_symbol].nonterminal_flag)
				continue;

			pivot_nonterminal[rightmost_index] = rightmost_symbol;

			for (k=ri.right_symbol_count-2; k>=0; k--)
			{
				int		nonterminal_index	= ri.right_symbol_indexes[k];
				int		null_index			= ri.right_symbol_indexes[k + 1];

				if (!symbols[nonterminal_index].nonterminal_flag ||
					!symbol_status[null_index].derives_empty_flag)
					break;

				pivot_nonterminal[k] = nonterminal_index;
			}

			leftmost_pivot = k + 1;

			goto_states[0] = on.machine_state_index;

			for (k=1; k<ri.right_symbol_count; k++)
			{
				int	symbol_index	= ri.right_symbol_indexes[k - 1];
				int	table_index		= goto_states[k - 1] * symbol_count_a +
																symbol_index;

				if ((goto_states[k] = goto_table[table_index]) == -1)
					break;
			}

			rightmost_goto = k - 1;

			for (k=leftmost_pivot; k<=rightmost_goto; k++)
			{
				int		on_nonterminal_map_index =
					goto_states[k] * symbol_count_a + pivot_nonterminal[k];

				int		on_nonterminal_index =
					on_nonterminal_map[on_nonterminal_map_index];

				if (on_nonterminal_index != -1)
					ip->PushBack(OrdPairInt(on_nonterminal_index, i));
			}
		}

		for (j=0; j<si.left_symbol_count; j++)
		{
			int		rule_index = si.left_symbol_indexes[j];

			CRuleInformation	&ri = rules[rule_index];

			goto_states[0] = on.machine_state_index;

			for (k=1; k<=ri.right_symbol_count; k++)
			{
				int	symbol_index	= ri.right_symbol_indexes[k - 1];
				int	table_index		= goto_states[k - 1] * symbol_count_a +
																symbol_index;

				if ((goto_states[k] = goto_table[table_index]) == -1)
					break;
			}

			if (k <= ri.right_symbol_count)
				continue;

			int		contains_table_index =
				goto_states[ri.right_symbol_count] * rule_count_a + rule_index;

			int		contains_item_index = contains_table[contains_table_index];

			if (contains_item_index != -1)
				lp->PushBack(OrdPairInt(contains_item_index, i));
		}
	}

	includes	= new RelationInt(ip);
	lookback	= new RelationInt(lp);

	delete [] goto_states;
	delete [] pivot_nonterminal;
}

void	CParse::ComputeLALR1Lookaheads()
{
	if (on_nonterminal_count > relation_domain->Size())
		for (int i=relation_domain->Size(); i<on_nonterminal_count; i++)
			relation_domain->PushBack(i);

	RelationInt		*c1 = Composition(	goes_to,
										has_transition_on,
										on_nonterminal_count,
										machine_count,
										symbol_count_a);

	directly_reads	= Composition(	c1,
									terminal,
									on_nonterminal_count,
									symbol_count_a,
									symbol_count_a);

	RelationInt		*closure_of_includes =
			ReflexiveTransitiveClosure(	includes,
										relation_domain,
										on_nonterminal_count);

	if (has_null_transition->count)
	{
		reads	= Composition(	goes_to,
								has_null_transition,
								on_nonterminal_count,
								machine_count,
								on_nonterminal_count);

		RelationInt		*closure_of_reads =
				ReflexiveTransitiveClosure(	reads,
											relation_domain,
											on_nonterminal_count);

		RelationInt		*c1 = Composition(	closure_of_reads,
											directly_reads,
											on_nonterminal_count,
											on_nonterminal_count,
											symbol_count_a);

		RelationInt		*c2 = Composition(	closure_of_includes,
											c1,
											on_nonterminal_count,
											on_nonterminal_count,
											symbol_count_a);

		has_lalr_lookahead = Composition(	lookback,
											c2,
											contains_item_count,
											on_nonterminal_count,
											symbol_count_a);

		delete c1;
		delete c2;
		delete closure_of_includes;
		delete closure_of_reads;
	}
	else
	{
		reads = Empty<int, int>();

		RelationInt		*c2 = Composition(	closure_of_includes,
											directly_reads,
											on_nonterminal_count,
											on_nonterminal_count,
											symbol_count_a);

		has_lalr_lookahead = Composition(	lookback,
											c2,
											contains_item_count,
											on_nonterminal_count,
											symbol_count_a);

		delete c1;
		delete c2;
		delete closure_of_includes;
	}
}

ListConflict::listptr	FindOrdPairInListConflict(
							const VListMapToConflictPtr &m, const OrdPairInt &p)
{
	ListConflict::listptr	found = 0;

	VListMapToConflictPtr::listptr	map_listptr = m.FirstListPtr();

	while (map_listptr)
	{
		PairIntToListConflictPtr	pair_to_ptr = m.Data(map_listptr);

		if (pair_to_ptr.First() == p)
		{
			found = pair_to_ptr.Second();
			break;
		}

		m.NextData(map_listptr);
	}

	return found;
}

bool	CParse::ComputeLALR1ActionTable()
{
	action_table		= new int[machine_count * terminal_count_e];
	parsing_conflicts	= new ListConflict(10);
	error_action		= -1;
	shift_action		= rule_count_a;
	accept_action		= rule_count_a + 1;
	conflict_entry		= rule_count_a + 2;

	int		i;
	int		j;
	int		g_offset = 0;
	int		a_offset = 0;

	for (i=0; i<machine_count; i++)
	{
		for (j=0; j<terminal_count_e-1; j++)
			if (goto_table[g_offset + j] != -1)
				action_table[a_offset + j] = shift_action;
			else
				action_table[a_offset + j] = error_action;

		if (goto_table[g_offset + j] != -1)
			action_table[a_offset + j] = accept_action;
		else
			action_table[a_offset + j] = error_action;

		g_offset += symbol_count_a;
		a_offset += terminal_count_e;
	}

	rule_left_symbol_table	= new int[rule_count_a];
	rule_right_length_table	= new int[rule_count_a];

	for (i=0; i<rule_count_a; i++)
	{
		rule_left_symbol_table[i]	= rules[i].left_symbol_index;
		rule_right_length_table[i]	= rules[i].right_symbol_count;
	}

	VListMapToConflictPtr	intpair_to_ptr_list(10);

	VListOrdPairInt::listptr	pair_listptr =
								has_lalr_lookahead->pairs->FirstListPtr();

	while (pair_listptr)
	{
		OrdPairInt	pair = has_lalr_lookahead->pairs->NextData(pair_listptr);

		CContainsItem	&ci = contains_item[pair.First()];
		CItemCore		&ic = item_cores[ci.item_core_index];

		int				machine_state_index	= ci.machine_state_index;
		int				symbol_index		= pair.Second();
		int				rule_index			= ic.rule_index;

		int		action_table_index =
					machine_state_index * terminal_count_e + symbol_index;

		int		action = action_table[action_table_index];

		if (action != error_action)
		{
			if (action != conflict_entry)
			{
				CConflict	*conflict = new CConflict(	machine_state_index,
														symbol_index);

				conflict->action_set->PushBack(action);
				conflict->action_set->PushBack(rule_index);

				action_table[action_table_index] = conflict_entry;

				parsing_conflicts->PushBack(conflict);

				intpair_to_ptr_list.PushBack(
					PairIntToListConflictPtr(OrdPairInt(machine_state_index,
														symbol_index),
										parsing_conflicts->LastListPtr()));
			}
			else
			{
				ListConflict::listptr	found = FindOrdPairInListConflict(
					intpair_to_ptr_list, OrdPairInt(machine_state_index,
													symbol_index));

				CConflict	*conflict = parsing_conflicts->Data(found);

				conflict->action_set->PushBack(rule_index);
			}
		}
		else
		{
			action_table[action_table_index] = rule_index;
		}
	}

	default_error_entry_count = 0;

	for (i=0; i<machine_count * terminal_count_e; i++)
		if (action_table[i] == -1)
			default_error_entry_count++;

	delete [] default_error_state_terminals;

	default_error_state_terminals =
		new CErrorStateTerminal[default_error_entry_count + 1];

	int		est_index = 1;

	a_offset = 0;

	for (i=0; i<machine_count; i++)
	{
		for (j=0; j<terminal_count_e; j++)
		{
			if (action_table[a_offset + j] == -1)
			{
				default_error_state_terminals[est_index].state		= i;
				default_error_state_terminals[est_index].terminal	= j;
				est_index++;
			}
		}

		a_offset += terminal_count_e;
	}

	ListConflict::listptr	conflict_listptr =
									parsing_conflicts->FirstListPtr();

	while (conflict_listptr)
	{
		CConflict	*conflict = parsing_conflicts->NextData(conflict_listptr);

		conflict->action_set->PushBack(conflict_entry);
	}

	unresolved_conflict_count = parsing_conflicts->Size();

	if (unresolved_conflict_count)
		return true;
	else
		return false;
}

void	CParse::ComputeSLR1Lookaheads()
{
	int		i;
	int		j;
	int		k;

	goto_table = new int[machine_count * symbol_count_a];

	for (i=0; i<machine_count*symbol_count_a; i++)
		goto_table[i] = -1;

	for (i=0; i<machine_count; i++)
	{
		CMachineInformation		&mi = machine[i];

		for (j=0; j<mi.state_transition_count; j++)
		{
			int	symbol_index	= mi.state_transitions[j].symbol_index;
			int	state_index		= mi.state_transitions[j].machine_state_index;

			goto_table[i * symbol_count_a + symbol_index] = state_index;
		}
	}

	RelationInt		*inverse_of_follows = follows->Inverse();
	VListInt		follows_symbol(2);

	for (i=0; i<nonterminal_count_a; i++)
	{
		follows_symbol.PushBack(nonterminal_indexes[i]);

		VListInt	*follows_list  = SubsetImage(	inverse_of_follows,
													&follows_symbol,
													symbol_count_a,
													symbol_count_a);

		int		follows_count = follows_list->Size();

		if (follows_count)
		{
			CSymbolInformation	&si = symbols[nonterminal_indexes[i]];

			si.follows_count	= follows_count;
			si.follows_x		= new int[follows_count];

			VListInt::listptr	follows_listptr =
										follows_list->FirstListPtr();

			for (j=0; j<follows_count; j++)
			{
				int f = follows_list->NextData(follows_listptr);

				si.follows_x[j] = f;
			}
		}

		delete follows_list;

		follows_symbol.PopBack();
	}

	delete inverse_of_follows;

	slr1_lookahead = new ListSLR1LookAhead(item_core_count);

	for (i=0; i<machine_count; i++)
	{
		CMachineInformation		&mi = machine[i];

		for (j=0; j<mi.item_core_count; j++)
		{
			CItemCore	&ic = item_cores[mi.item_core_set[j]];

			if (ic.reduce_item_flag)
			{
				int		r_index = ic.rule_index;

				CRuleInformation	&ri = rules[r_index];

				int		lsi = ri.left_symbol_index;

				CSymbolInformation	&si = symbols[lsi];

				if (si.follows_count)
				{
					for (k=0; k<si.follows_count; k++)
					{
						slr1_lookahead->PushBack(
							CSLR1LookAhead(i, si.follows_x[k], r_index));
					}
				}
			}
		}
	}
}

bool	CParse::ComputeSLR1ActionTable()
{
	action_table		= new int[machine_count * terminal_count_e];
	parsing_conflicts	= new ListConflict(10);
	error_action		= -1;
	shift_action		= rule_count_a;
	accept_action		= rule_count_a + 1;
	conflict_entry		= rule_count_a + 2;

	int		i;
	int		j;
	int		g_offset = 0;
	int		a_offset = 0;

	for (i=0; i<machine_count; i++)
	{
		for (j=0; j<terminal_count_e-1; j++)
			if (goto_table[g_offset + j] != -1)
				action_table[a_offset + j] = shift_action;
			else
				action_table[a_offset + j] = error_action;

		if (goto_table[g_offset + j] != -1)
			action_table[a_offset + j] = accept_action;
		else
			action_table[a_offset + j] = error_action;

		g_offset += symbol_count_a;
		a_offset += terminal_count_e;
	}

	rule_left_symbol_table	= new int[rule_count_a];
	rule_right_length_table	= new int[rule_count_a];

	for (i=0; i<rule_count_a; i++)
	{
		rule_left_symbol_table[i]	= rules[i].left_symbol_index;
		rule_right_length_table[i]	= rules[i].right_symbol_count;
	}

	VListMapToConflictPtr	intpair_to_ptr_list(10);

	ListSLR1LookAhead::listptr	slr1_la_listptr =
									slr1_lookahead->FirstListPtr();

	while (slr1_la_listptr)
	{
		CSLR1LookAhead	slr1_la = slr1_lookahead->NextData(slr1_la_listptr);

		int		machine_state_index	= slr1_la.state;
		int		symbol_index		= slr1_la.terminal;
		int		rule_index			= slr1_la.rule_index;

		int		action_table_index =
					machine_state_index * terminal_count_e + symbol_index;

		int		action = action_table[action_table_index];

		if (action != error_action)
		{
			if (action != conflict_entry)
			{
				CConflict	*conflict = new CConflict(	machine_state_index,
														symbol_index);

				conflict->action_set->PushBack(action);
				conflict->action_set->PushBack(rule_index);

				action_table[action_table_index] = conflict_entry;

				parsing_conflicts->PushBack(conflict);

				intpair_to_ptr_list.PushBack(
					PairIntToListConflictPtr(OrdPairInt(machine_state_index,
														symbol_index),
										parsing_conflicts->LastListPtr()));
			}
			else
			{
				ListConflict::listptr	found = FindOrdPairInListConflict(
					intpair_to_ptr_list, OrdPairInt(machine_state_index,
													symbol_index));

				CConflict	*conflict = parsing_conflicts->Data(found);

				conflict->action_set->PushBack(rule_index);
			}
		}
		else
		{
			action_table[action_table_index] = rule_index;
		}
	}

	default_error_entry_count = 0;

	for (i=0; i<machine_count * terminal_count_e; i++)
		if (action_table[i] == -1)
			default_error_entry_count++;

	delete [] default_error_state_terminals;

	default_error_state_terminals =
		new CErrorStateTerminal[default_error_entry_count + 1];

	int		est_index = 1;

	a_offset = 0;

	for (i=0; i<machine_count; i++)
	{
		for (j=0; j<terminal_count_e; j++)
		{
			if (action_table[a_offset + j] == -1)
			{
				default_error_state_terminals[est_index].state		= i;
				default_error_state_terminals[est_index].terminal	= j;
				est_index++;
			}
		}

		a_offset += terminal_count_e;
	}

	ListConflict::listptr	conflict_listptr =
									parsing_conflicts->FirstListPtr();

	while (conflict_listptr)
	{
		CConflict	*conflict = parsing_conflicts->NextData(conflict_listptr);

		conflict->action_set->PushBack(conflict_entry);
	}

	unresolved_conflict_count = parsing_conflicts->Size();

	if (unresolved_conflict_count)
		return true;
	else
		return false;
}

void	CParse::ComputeLR1Lookaheads()
{
	int		i;
	int		j;
	int		k;

	goto_table = new int[machine_count * symbol_count_a];

	for (i=0; i<machine_count*symbol_count_a; i++)
		goto_table[i] = -1;

	for (i=0; i<machine_count; i++)
	{
		CLR1MachineInformation		&mi = lr1_machine[i];

		for (j=0; j<mi.state_transition_count; j++)
		{
			int	symbol_index	= mi.state_transitions[j].symbol_index;
			int	state_index		= mi.state_transitions[j].machine_state_index;

			goto_table[i * symbol_count_a + symbol_index] = state_index;
		}
	}

	lr1_lookahead = new ListLR1LookAhead(lr1_item_count);

	for (i=0; i<machine_count; i++)
	{
		CLR1MachineInformation		&mi = lr1_machine[i];

		for (j=0; j<mi.lr1_item_count; j++)
		{
			CLR1Item	&lri = lr1_items[mi.lr1_item_set[j]];

			CItemCore	&ic = item_cores[lri.item_core_index];

			if (ic.reduce_item_flag && lri.lookahead_terminal_index != -1)
			{
				int		r_index = ic.rule_index;

				lr1_lookahead->PushBack(
					CLR1LookAhead(i, lri.lookahead_terminal_index, r_index));
			}
		}
	}
}

bool	CParse::ComputeLR1ActionTable()
{
	action_table		= new int[machine_count * terminal_count_e];
	parsing_conflicts	= new ListConflict(10);
	error_action		= -1;
	shift_action		= rule_count_a;
	accept_action		= rule_count_a + 1;
	conflict_entry		= rule_count_a + 2;

	int		i;
	int		j;
	int		g_offset = 0;
	int		a_offset = 0;

	for (i=0; i<machine_count; i++)
	{
		for (j=0; j<terminal_count_e-1; j++)
			if (goto_table[g_offset + j] != -1)
				action_table[a_offset + j] = shift_action;
			else
				action_table[a_offset + j] = error_action;

		if (goto_table[g_offset + j] != -1)
			action_table[a_offset + j] = accept_action;
		else
			action_table[a_offset + j] = error_action;

		g_offset += symbol_count_a;
		a_offset += terminal_count_e;
	}

	rule_left_symbol_table	= new int[rule_count_a];
	rule_right_length_table	= new int[rule_count_a];

	for (i=0; i<rule_count_a; i++)
	{
		rule_left_symbol_table[i]	= rules[i].left_symbol_index;
		rule_right_length_table[i]	= rules[i].right_symbol_count;
	}

	VListMapToConflictPtr	intpair_to_ptr_list(10);

	ListLR1LookAhead::listptr	lr1_la_listptr =
									lr1_lookahead->FirstListPtr();

	while (lr1_la_listptr)
	{
		CLR1LookAhead	lr1_la = lr1_lookahead->NextData(lr1_la_listptr);

		int		machine_state_index	= lr1_la.state;
		int		symbol_index		= lr1_la.terminal;
		int		rule_index			= lr1_la.rule_index;

		int		action_table_index =
					machine_state_index * terminal_count_e + symbol_index;

		int		action = action_table[action_table_index];

		if (action != error_action)
		{
			if (action != conflict_entry)
			{
				CConflict	*conflict = new CConflict(	machine_state_index,
														symbol_index);

				conflict->action_set->PushBack(action);
				conflict->action_set->PushBack(rule_index);

				action_table[action_table_index] = conflict_entry;

				parsing_conflicts->PushBack(conflict);

				intpair_to_ptr_list.PushBack(
					PairIntToListConflictPtr(OrdPairInt(machine_state_index,
														symbol_index),
										parsing_conflicts->LastListPtr()));
			}
			else
			{
				ListConflict::listptr	found = FindOrdPairInListConflict(
					intpair_to_ptr_list, OrdPairInt(machine_state_index,
													symbol_index));

				CConflict	*conflict = parsing_conflicts->Data(found);

				conflict->action_set->PushBack(rule_index);
			}
		}
		else
		{
			action_table[action_table_index] = rule_index;
		}
	}

	default_error_entry_count = 0;

	for (i=0; i<machine_count * terminal_count_e; i++)
		if (action_table[i] == -1)
			default_error_entry_count++;

	delete [] default_error_state_terminals;

	default_error_state_terminals =
		new CErrorStateTerminal[default_error_entry_count + 1];

	int		est_index = 1;

	a_offset = 0;

	for (i=0; i<machine_count; i++)
	{
		for (j=0; j<terminal_count_e; j++)
		{
			if (action_table[a_offset + j] == -1)
			{
				default_error_state_terminals[est_index].state		= i;
				default_error_state_terminals[est_index].terminal	= j;
				est_index++;
			}
		}

		a_offset += terminal_count_e;
	}

	ListConflict::listptr	conflict_listptr =
									parsing_conflicts->FirstListPtr();

	while (conflict_listptr)
	{
		CConflict	*conflict = parsing_conflicts->NextData(conflict_listptr);

		conflict->action_set->PushBack(conflict_entry);
	}

	unresolved_conflict_count = parsing_conflicts->Size();

	if (unresolved_conflict_count)
		return true;
	else
		return false;
}

void	CParse::DefaultConflictResolution()
{
	int		i;
	int		j;
	int		shift_level[terminal_count_e];
	int		reduce_level[rule_count_a];

	for (i=0; i<terminal_count_e; i++)
		shift_level[i] = -1;

	for (i=0; i<rule_count_a; i++)
		reduce_level[i] = -1;

	for (i=0; i<precedence_count; i++)
	{
		CPrecedenceInformation	&pi = precedences[i];

		for (j=0; j<pi.entry_count; j++)
		{
			if (pi.entries[j].type ==
				CPrecedenceInformation::CPrecedenceEntry::TerminalEntry)
				shift_level[pi.entries[j].index] = i;

			if (pi.entries[j].type ==
				CPrecedenceInformation::CPrecedenceEntry::RuleEntry)
				reduce_level[pi.entries[j].index] = i;
		}
	}

	for (i=0; i<rule_count_a; i++)
	{
		if (reduce_level[i] != -1)
			continue;

		CRuleInformation	&ri = rules[i];

		for (j=ri.right_symbol_count-1; j>=0; j--)
			if (ri.right_symbol_indexes[j] < terminal_count_e)
			{
				reduce_level[i] = shift_level[ri.right_symbol_indexes[j]];
				break;
			}
	}

	VListIntPtr		a_listptr;
	int				action;
	int				conflict_index = 0;

	ListConflict::listptr	conflict_listptr =
									parsing_conflicts->FirstListPtr();

	while (conflict_listptr)
	{
		CConflict	*conflict	= parsing_conflicts->NextData(conflict_listptr);
		VListInt	*a_set		= conflict->action_set;

		a_listptr	= a_set->FirstListPtr();
		action		= a_set->FirstData();

		if (action == shift_action)
		{
			if (a_set->Size() == 3)
			{
				VListIntPtr		r_listptr	= a_set->FindIndex(1);
				VListIntPtr		c_listptr	= a_set->FindIndex(2);

				int		reduce_action = a_set->Data(r_listptr);

				int		s_level = shift_level[conflict->terminal_symbol_index];
				int		r_level = reduce_level[reduce_action];

				if (s_level != -1 && r_level != -1)
				{
					if (s_level < r_level)
					{
						a_listptr	= r_listptr;
						action		= reduce_action;
					}
					else if (s_level == r_level)
					{
						switch (precedences[s_level].associativity)
						{
							case CPrecedenceInformation::LeftAssociative:
							a_listptr	= r_listptr;
							action		= reduce_action;
							break;

							case CPrecedenceInformation::RightAssociative:
							break;

							case CPrecedenceInformation::NonAssociative:
							a_listptr	= c_listptr;
							action		= conflict_entry + conflict_index;
							break;
						}
					}
				}
			}
		}
		else
		{
			VListIntPtr		b_listptr = a_listptr;

			while (b_listptr)
			{
				int		a = a_set->Data(b_listptr);

				if (a < action)
				{
					a_listptr	= b_listptr;
					action		= a;
				}

				a_set->NextListPtr(b_listptr);
			}
		}

		conflict->resolve_listptr = a_listptr;
		conflict->default_listptr = a_listptr;

		action_table[conflict->machine_state_index * terminal_count_e +
									conflict->terminal_symbol_index] = action;

		unresolved_conflict_count--;
		conflict_index++;
	}
}

void	CParse::ComputeEEEDomains()
{
	int		i;
	int		j;
	int		k;

	VListOrdPairInt				eee_domain1_si_list(item_core_count);
	VListOrdPairInt				eee_domain2_sn_list(item_core_count);

	delete [] eee_domain2_sn_map;
	delete [] eee_domain3_st_map;

	eee_domain2_sn_map = new int[machine_count * symbol_count_a];
	eee_domain3_st_map = new int[machine_count * symbol_count_a];

	for (i=0; i<machine_count*symbol_count_a; i++)
	{
		eee_domain2_sn_map[i] = -1;
		eee_domain3_st_map[i] = -1;
	}

	for (i=0; i<machine_count; i++)
	{
		CMachineInformation		&mi = machine[i];

		for (j=0; j<mi.item_core_count; j++)
		{
			int					item_core_index	= mi.item_core_set[j];
			CItemCore			&ic				= item_cores[item_core_index];
			CRuleInformation	&ri				= rules[ic.rule_index];

			if (!ic.right_symbol_after_dot_index)
				for (k=0; k<=ri.right_symbol_count; k++)
					eee_domain1_si_list.PushBack(
										OrdPairInt(i, item_core_index + k));

			if (ic.right_symbol_after_dot_index < ri.right_symbol_count)
			{
				int		s_index = ri.right_symbol_indexes[
											ic.right_symbol_after_dot_index];

				CSymbolInformation	&si			= symbols[s_index];
				int					map_index	= i * symbol_count_a + s_index;

				if (si.nonterminal_flag && eee_domain2_sn_map[map_index] == -1)
				{
					eee_domain2_sn_list.PushBack(OrdPairInt(i, s_index));

					eee_domain2_sn_map[map_index] = 0;
				}
			}
		}
	}

	eee_domain1_si_count = eee_domain1_si_list.Size();
	eee_domain2_sn_count = eee_domain2_sn_list.Size();
	eee_domain3_st_count = machine_count * terminal_count_e;

	delete [] eee_domain1_si;
	delete [] eee_domain2_sn;
	delete [] eee_domain3_st;

	eee_domain1_si = new CEEEDomain1SI[eee_domain1_si_count];
	eee_domain2_sn = new CEEEDomain2SN[eee_domain2_sn_count];
	eee_domain3_st = new CEEEDomain3ST[eee_domain3_st_count];

	int							index;
	VListOrdPairInt::listptr	domain_listptr;

	index = 0;
	domain_listptr = eee_domain1_si_list.FirstListPtr();
	while (domain_listptr)
	{
		OrdPairInt	&p = eee_domain1_si_list.NextData(domain_listptr);

		eee_domain1_si[index].Initialize(p.First(), p.Second());
		index++;
	}

	index = 0;
	domain_listptr = eee_domain2_sn_list.FirstListPtr();
	while (domain_listptr)
	{
		OrdPairInt	&p = eee_domain2_sn_list.NextData(domain_listptr);

		eee_domain2_sn[index].Initialize(p.First(), p.Second());

		int		map_index	= p.First() * symbol_count_a + p.Second();

		eee_domain2_sn_map[map_index] = index;

		index++;
	}

	index = 0;
	for (i=0; i<machine_count; i++)
	{
		for (j=0; j<terminal_count_e; j++)
		{
			eee_domain3_st[index].Initialize(i, j);

			int		map_index	= i * symbol_count_a + j;

			eee_domain3_st_map[map_index] = index;

			index++;
		}
	}
}

void	CParse::ComputeEEERelations()
{
	int		i;
	int		j;
	int		goto_states[maximum_right_symbol_count + 1];

	VListOrdPairInt	*symbol_in_vp	= new VListOrdPairInt(item_core_count);
	VListOrdPairInt	*eee_points_vp	= new VListOrdPairInt(item_core_count);
	VListOrdPairInt	*expands_vp		= new VListOrdPairInt(item_core_count);
	VListOrdPairInt	*entered_by_vp	= new VListOrdPairInt(item_core_count);

	delete [] relations_on_a;

	relations_on_a = new CEEERelationsOnA[terminal_count_e];

	CSymbolInformation	&asi = symbols[augmented_symbol_index];

	int		augmented_rule_item_core_block_index =
					rules[asi.left_symbol_indexes[0]].item_core_block_index;

	for (i=0; i<eee_domain1_si_count; i++)
	{
		CEEEDomain1SI	&eee_si = eee_domain1_si[i];

		int					item_core_index	= eee_si.item_core_index;
		CItemCore			&ic				= item_cores[item_core_index];
		CRuleInformation	&ri				= rules[ic.rule_index];

		if (!ic.right_symbol_after_dot_index)
		{
			if (!eee_si.machine_state_index &&
				item_core_index == augmented_rule_item_core_block_index)
				entered_by_vp->PushBack(OrdPairInt(i, empty_symbol_index));
		}
		else
		{
			int		rs_before_dot_index	= ic.right_symbol_after_dot_index - 1;
			int		s_index				= ri.right_symbol_indexes[
														rs_before_dot_index];

			entered_by_vp->PushBack(OrdPairInt(i, s_index));

			CSymbolInformation	&si	= symbols[s_index];

			if (si.nonterminal_flag)
			{
				goto_states[0] = eee_si.machine_state_index;

				for (j=0; j<rs_before_dot_index; j++)
				{
					int	symbol_index	= ri.right_symbol_indexes[j];
					int	table_index		= goto_states[j] * symbol_count_a +
																symbol_index;

					if ((goto_states[j + 1] = goto_table[table_index]) == -1)
						break;
				}

				if (j < rs_before_dot_index)
					continue;

				int		map_index =
					goto_states[rs_before_dot_index] * symbol_count_a + s_index;

				int		eee_domain2_sn_index = eee_domain2_sn_map[map_index];

				if (eee_domain2_sn_index != -1)
					symbol_in_vp->PushBack(OrdPairInt(eee_domain2_sn_index, i));
			}
		}
	}

	delete entered_by;
	delete symbol_in;

	entered_by	= new RelationInt(entered_by_vp);
	symbol_in	= new RelationInt(symbol_in_vp);

	for (i=0; i<eee_domain1_si_count; i++)
	{
		CEEEDomain1SI	&eee_si = eee_domain1_si[i];

		int					item_core_index	= eee_si.item_core_index;
		CItemCore			&ic				= item_cores[item_core_index];
		CRuleInformation	&ri				= rules[ic.rule_index];

		if (ic.right_symbol_after_dot_index < ri.right_symbol_count)
		{
			int		s_index	= ri.right_symbol_indexes[
											ic.right_symbol_after_dot_index];

			CSymbolInformation	&si	= symbols[s_index];

			if (si.nonterminal_flag)
			{
				goto_states[0] = eee_si.machine_state_index;

				for (j=0; j<ic.right_symbol_after_dot_index; j++)
				{
					int	symbol_index	= ri.right_symbol_indexes[j];
					int	table_index		= goto_states[j] * symbol_count_a +
																symbol_index;

					if ((goto_states[j + 1] = goto_table[table_index]) == -1)
						break;
				}

				if (j < ic.right_symbol_after_dot_index)
					continue;

				int		map_index =
							goto_states[ic.right_symbol_after_dot_index] *
													symbol_count_a + s_index;

				int		eee_domain2_sn_index = eee_domain2_sn_map[map_index];

				if (eee_domain2_sn_index != -1)
					eee_points_vp->PushBack(OrdPairInt(i, eee_domain2_sn_index));
			}
		}
	}

	delete eee_points;

	eee_points = new RelationInt(eee_points_vp);

	for (i=0; i<eee_domain1_si_count; i++)
	{
		CEEEDomain1SI	&eee_si = eee_domain1_si[i];

		int					item_core_index	= eee_si.item_core_index;
		CItemCore			&ic				= item_cores[item_core_index];
		CRuleInformation	&ri				= rules[ic.rule_index];

		if (!ic.right_symbol_after_dot_index)
		{
			int		map_index = eee_si.machine_state_index * symbol_count_a +
														ri.left_symbol_index;

			int		eee_domain2_sn_index = eee_domain2_sn_map[map_index];

			if (eee_domain2_sn_index != -1)
				expands_vp->PushBack(OrdPairInt(eee_domain2_sn_index, i));
		}
	}

	delete expands;

	expands = new RelationInt(expands_vp);

	VListOrdPairInt	*on_a_reduces_to_vp[terminal_count_e];
	VListOrdPairInt	*directly_on_a_passes_null_vp[terminal_count_e];
	VListOrdPairInt	*error_entry_on_a_vp[terminal_count_e];

	for (i=0; i<terminal_count_e; i++)
	{
		on_a_reduces_to_vp[i]			= new VListOrdPairInt;
		directly_on_a_passes_null_vp[i]	= new VListOrdPairInt;
		error_entry_on_a_vp[i]			= new VListOrdPairInt;
	}

	for (i=0; i<eee_domain1_si_count; i++)
	{
		CEEEDomain1SI	&eee_si = eee_domain1_si[i];

		int					item_core_index	= eee_si.item_core_index;
		CItemCore			&ic				= item_cores[item_core_index];
		CRuleInformation	&ri				= rules[ic.rule_index];

		if (ic.right_symbol_after_dot_index == ri.right_symbol_count)
		{
			int		map_index = eee_si.machine_state_index * symbol_count_a +
														ri.left_symbol_index;

			int		eee_domain2_sn_index = eee_domain2_sn_map[map_index];

			if (eee_domain2_sn_index != -1)
			{
				goto_states[0] = eee_si.machine_state_index;

				for (j=0; j<ri.right_symbol_count; j++)
				{
					int	symbol_index	= ri.right_symbol_indexes[j];
					int	table_index		= goto_states[j] * symbol_count_a +
																symbol_index;

					if ((goto_states[j + 1] = goto_table[table_index]) == -1)
						break;
				}

				if (j < ri.right_symbol_count)
					continue;

				for (j=0; j<terminal_count_e; j++)
					if (action_table[goto_states[ri.right_symbol_count] *
								terminal_count_e + terminal_indexes[j]]
						== ic.rule_index)
						on_a_reduces_to_vp[j]->PushBack(
										OrdPairInt(i, eee_domain2_sn_index));
			}
		}
	}

	for (i=0; i<eee_domain1_si_count; i++)
	{
		CEEEDomain1SI	&eee_si = eee_domain1_si[i];

		int					item_core_index	= eee_si.item_core_index;
		CItemCore			&ic				= item_cores[item_core_index];
		CRuleInformation	&ri				= rules[ic.rule_index];

		if (ic.right_symbol_after_dot_index < ri.right_symbol_count)
		{
			int		s_index	= ri.right_symbol_indexes[
											ic.right_symbol_after_dot_index];

			CSymbolInformation	&si	= symbols[s_index];

			if (si.nonterminal_flag)
			{
				goto_states[0] = eee_si.machine_state_index;

				for (j=0; j<ic.right_symbol_after_dot_index; j++)
				{
					int	symbol_index	= ri.right_symbol_indexes[j];
					int	table_index		= goto_states[j] * symbol_count_a +
																symbol_index;

					if ((goto_states[j + 1] = goto_table[table_index]) == -1)
						break;
				}

				if (j < ic.right_symbol_after_dot_index)
					continue;

				for (j=0; j<terminal_count_e; j++)
				{
					int	a = action_table[
							goto_states[ic.right_symbol_after_dot_index] *
									terminal_count_e + terminal_indexes[j]];

					if (0 <= a && a < rule_count_a)
					{
						CRuleInformation	&rrii = rules[a];

						if (rrii.left_symbol_index == s_index &&
							!rrii.right_symbol_count)
							directly_on_a_passes_null_vp[j]->PushBack(
														OrdPairInt(i, i + 1));
					}
				}
			}
		}
	}

	for (i=0; i<eee_domain1_si_count; i++)
	{
		CEEEDomain1SI	&eee_si = eee_domain1_si[i];

		int					item_core_index	= eee_si.item_core_index;
		CItemCore			&ic				= item_cores[item_core_index];
		CRuleInformation	&ri				= rules[ic.rule_index];

		goto_states[0] = eee_si.machine_state_index;

		for (j=0; j<ic.right_symbol_after_dot_index; j++)
		{
			int	symbol_index	= ri.right_symbol_indexes[j];
			int	table_index		= goto_states[j] * symbol_count_a +
														symbol_index;

			if ((goto_states[j + 1] = goto_table[table_index]) == -1)
				break;
		}

		if (j < ic.right_symbol_after_dot_index)
			continue;

		for (j=0; j<terminal_count_e; j++)
			if (action_table[goto_states[ic.right_symbol_after_dot_index] *
						terminal_count_e + terminal_indexes[j]]
				== error_action)
			{
				int	map_index = goto_states[ic.right_symbol_after_dot_index] *
										symbol_count_a + terminal_indexes[j];

				int		eee_domain3_st_index = eee_domain3_st_map[map_index];

				error_entry_on_a_vp[j]->PushBack(
								OrdPairInt(i, eee_domain3_st_index));
			}
	}

	for (i=0; i<terminal_count_e; i++)
	{
		relations_on_a[i].on_a_reduces_to =
							new RelationInt(on_a_reduces_to_vp[i]);
		relations_on_a[i].directly_on_a_passes_null =
							new RelationInt(directly_on_a_passes_null_vp[i]);
		relations_on_a[i].error_entry_on_a =
							new RelationInt(error_entry_on_a_vp[i]);
	}
}

void	CParse::ComputeApproximateEssentialErrorEntries()
{
	ComputeEEEDomains();
	ComputeEEERelations();

	if (eee_domain1_si_count > relation_domain->Size())
		for (int i=relation_domain->Size(); i<eee_domain1_si_count; i++)
			relation_domain->PushBack(i);

	directly_descends	= Composition(	eee_points,
										expands,
										eee_domain1_si_count,
										eee_domain2_sn_count,
										eee_domain1_si_count);

	delete eee_points;
	eee_points = 0;
	delete expands;
	expands = 0;

	RelationInt		*closure_of_directly_descends =
			ReflexiveTransitiveClosure(	directly_descends,
										relation_domain,
										eee_domain1_si_count);

	delete directly_descends;
	directly_descends = 0;

	int	i;
	for (i=0; i<terminal_count_e; i++)
	{
		relations_on_a[i].on_a_reduces_to_symbol_in =
					Composition(relations_on_a[i].on_a_reduces_to,
								symbol_in,
								eee_domain1_si_count,
								eee_domain2_sn_count,
								eee_domain1_si_count);

		delete relations_on_a[i].on_a_reduces_to;
		relations_on_a[i].on_a_reduces_to = 0;

		RelationInt		*c1 = Composition(
								closure_of_directly_descends,
								relations_on_a[i].directly_on_a_passes_null,
								eee_domain1_si_count,
								eee_domain1_si_count,
								eee_domain1_si_count);

		delete relations_on_a[i].directly_on_a_passes_null;
		relations_on_a[i].directly_on_a_passes_null = 0;

		RelationInt		*u1 = RelationUnion(
								relations_on_a[i].on_a_reduces_to_symbol_in,
								c1,
								eee_domain1_si_count,
								eee_domain1_si_count);

		delete relations_on_a[i].on_a_reduces_to_symbol_in;
		relations_on_a[i].on_a_reduces_to_symbol_in = 0;

		delete c1;

		relations_on_a[i].may_on_a_access =
			ReflexiveTransitiveClosure(	u1,
										relation_domain,
										eee_domain1_si_count);
		delete u1;
	}

	delete symbol_in;
	symbol_in = 0;

	delete closure_of_directly_descends;

	RelationInt		*inverse_of_entered_by = entered_by->Inverse();

	delete entered_by;
	entered_by = 0;

	RelationInt		*terminal_inverse_of_entered_by  = Composition(
								terminal,
								inverse_of_entered_by,
								symbol_count_a,
								symbol_count_a,
								eee_domain1_si_count);

	delete inverse_of_entered_by;

	for (i=0; i<terminal_count_e; i++)
	{
		RelationInt		*c1 = Composition(
								relations_on_a[i].may_on_a_access,
								relations_on_a[i].error_entry_on_a,
								eee_domain1_si_count,
								eee_domain1_si_count,
								eee_domain3_st_count);

		delete relations_on_a[i].may_on_a_access;
		relations_on_a[i].may_on_a_access = 0;
		delete relations_on_a[i].error_entry_on_a;
		relations_on_a[i].error_entry_on_a = 0;

		relations_on_a[i].may_imply_a_essential =
					Composition(terminal_inverse_of_entered_by,
								c1,
								symbol_count_a,
								eee_domain1_si_count,
								eee_domain3_st_count);

		delete c1;

		VListOrdPairInt				*p = relations_on_a[i].
												may_imply_a_essential->pairs;
		VListOrdPairInt::listptr	p_listptr;

		p_listptr = p->FirstListPtr();

		while (p_listptr)
		{
			OrdPairInt	&pair = p->NextData(p_listptr);

			CEEEDomain3ST	&d = eee_domain3_st[pair.second];

			d.essential_error_entry_flag = true;
		}

		delete relations_on_a[i].may_imply_a_essential;
		relations_on_a[i].may_imply_a_essential = 0;
	}

	delete terminal_inverse_of_entered_by;

	delete [] essential_error_entries;

	essential_error_entries = new bool[machine_count * terminal_count_e];

	essential_error_entry_count = 0;

	for (i=0; i<machine_count*terminal_count_e; i++)
		essential_error_entries[i] = false;

	for (i=0; i<machine_count*terminal_count_e; i++)
	{
		CEEEDomain3ST	&d = eee_domain3_st[i];

		if (d.essential_error_entry_flag)
		{
			essential_error_entries[d.machine_state_index * terminal_count_e +
												d.terminal_index] = true;

			essential_error_entry_count++;
		}
	}

	delete [] essential_error_state_terminals;

	essential_error_state_terminals =
		new CErrorStateTerminal[essential_error_entry_count + 2];

	int		est_index	= 2;
	int		a_offset	= 0;
	int		j;

	for (i=0; i<machine_count; i++)
	{
		for (j=0; j<terminal_count_e; j++)
		{
			if (essential_error_entries[a_offset + j] == true)
			{
				essential_error_state_terminals[est_index].state	= i;
				essential_error_state_terminals[est_index].terminal	= j;
				est_index++;
			}
		}

		a_offset += terminal_count_e;
	}
}

void	CParse::ComputeExactEssentialErrorEntries()
{
	ComputeEEEDomains();
	ComputeEEERelations();

	int	i;

	VListOrdPairInt	*left_corner_in_vp
									= new VListOrdPairInt(item_core_count);

	for (i=0; i<eee_domain1_si_count; i++)
	{
		CEEEDomain1SI	&eee_si = eee_domain1_si[i];

		int					item_core_index	= eee_si.item_core_index;
		CItemCore			&ic				= item_cores[item_core_index];
		CRuleInformation	&ri				= rules[ic.rule_index];

		if (ic.right_symbol_after_dot_index == 1)
		{
			int		s_index	= ri.right_symbol_indexes[0];

			CSymbolInformation	&si	= symbols[s_index];

			if (si.nonterminal_flag)
			{
				int		map_index =
						eee_si.machine_state_index * symbol_count_a + s_index;

				int		eee_domain2_sn_index = eee_domain2_sn_map[map_index];

				if (eee_domain2_sn_index != -1)
					left_corner_in_vp->PushBack(
										OrdPairInt(eee_domain2_sn_index, i));
			}
		}
	}

	delete left_corner_in;

	left_corner_in = new RelationInt(left_corner_in_vp);

	if (eee_domain1_si_count > relation_domain->Size())
		for (int i=relation_domain->Size(); i<eee_domain1_si_count; i++)
			relation_domain->PushBack(i);

	directly_descends	= Composition(	eee_points,
										expands,
										eee_domain1_si_count,
										eee_domain2_sn_count,
										eee_domain1_si_count);

	delete eee_points;
	eee_points = 0;
	delete expands;
	expands = 0;

	RelationInt		*closure_of_directly_descends =
			ReflexiveTransitiveClosure(	directly_descends,
										relation_domain,
										eee_domain1_si_count);

	for (i=0; i<terminal_count_e; i++)
	{
		relations_on_a[i].on_a_reduces_to_symbol_in =
					Composition(relations_on_a[i].on_a_reduces_to,
								symbol_in,
								eee_domain1_si_count,
								eee_domain2_sn_count,
								eee_domain1_si_count);

		RelationInt		*c1 = Composition(
								closure_of_directly_descends,
								relations_on_a[i].directly_on_a_passes_null,
								eee_domain1_si_count,
								eee_domain1_si_count,
								eee_domain1_si_count);

		delete relations_on_a[i].directly_on_a_passes_null;
		relations_on_a[i].directly_on_a_passes_null = 0;

		RelationInt		*u1 = RelationUnion(
								relations_on_a[i].on_a_reduces_to_symbol_in,
								c1,
								eee_domain1_si_count,
								eee_domain1_si_count);

		delete c1;

		relations_on_a[i].may_on_a_access =
			ReflexiveTransitiveClosure(	u1,
										relation_domain,
										eee_domain1_si_count);
		delete u1;
	}

	delete symbol_in;
	symbol_in = 0;

	delete closure_of_directly_descends;

	VListOrdPairInt	*on_a_passes_null_vp[terminal_count_e];

	for (i=0; i<terminal_count_e; i++)
		on_a_passes_null_vp[i] = new VListOrdPairInt;

	for (i=0; i<terminal_count_e; i++)
	{
		VListOrdPairInt				*p = relations_on_a[i].
													may_on_a_access->pairs;
		VListOrdPairInt::listptr	p_listptr;

		p_listptr = p->FirstListPtr();

		while (p_listptr)
		{
			OrdPairInt	&pair = p->NextData(p_listptr);

			CEEEDomain1SI	&d1 = eee_domain1_si[pair.first];
			CEEEDomain1SI	&d2 = eee_domain1_si[pair.second];

			int					item_core_index	= d1.item_core_index;
			CItemCore			&ic				= item_cores[item_core_index];
			CRuleInformation	&ri				= rules[ic.rule_index];

			if (ic.right_symbol_after_dot_index < ri.right_symbol_count)
			{
				int		s_index	= ri.right_symbol_indexes[
											ic.right_symbol_after_dot_index];

				CSymbolInformation	&si	= symbols[s_index];

				if (si.nonterminal_flag && pair.second == pair.first + 1)
					on_a_passes_null_vp[i]->PushBack(pair);
			}
		}

		delete relations_on_a[i].may_on_a_access;
		relations_on_a[i].may_on_a_access = 0;
	}

	for (i=0; i<terminal_count_e; i++)
		relations_on_a[i].on_a_passes_null =
							new RelationInt(on_a_passes_null_vp[i]);

	RelationInt		*inverse_of_entered_by = entered_by->Inverse();

	delete entered_by;
	entered_by = 0;

	RelationInt		*terminal_inverse_of_entered_by  = Composition(
								terminal,
								inverse_of_entered_by,
								symbol_count_a,
								symbol_count_a,
								eee_domain1_si_count);

	delete inverse_of_entered_by;

	for (i=0; i<terminal_count_e; i++)
	{
		RelationInt		*u1 = RelationUnion(
								relations_on_a[i].on_a_reduces_to_symbol_in,
								relations_on_a[i].on_a_passes_null,
								eee_domain1_si_count,
								eee_domain1_si_count);

		delete relations_on_a[i].on_a_reduces_to_symbol_in;
		relations_on_a[i].on_a_reduces_to_symbol_in = 0;

		RelationInt		*closure_of_u1 =
			ReflexiveTransitiveClosure(	u1,
										relation_domain,
										eee_domain1_si_count);

		delete u1;

		RelationInt		*c1 = Composition(
								relations_on_a[i].on_a_reduces_to,
								left_corner_in,
								eee_domain1_si_count,
								eee_domain2_sn_count,
								eee_domain1_si_count);

		delete relations_on_a[i].on_a_reduces_to;
		relations_on_a[i].on_a_reduces_to = 0;

		RelationInt		*u2 = RelationUnion(
								c1,
								directly_descends,
								eee_domain1_si_count,
								eee_domain1_si_count);

		delete c1;

		RelationInt		*u3 = RelationUnion(
								u2,
								relations_on_a[i].on_a_passes_null,
								eee_domain1_si_count,
								eee_domain1_si_count);

		delete u2;
		delete relations_on_a[i].on_a_passes_null;
		relations_on_a[i].on_a_passes_null = 0;

		RelationInt		*closure_of_u3 =
			ReflexiveTransitiveClosure(	u3,
										relation_domain,
										eee_domain1_si_count);

		delete u3;

		relations_on_a[i].on_a_accesses =
					Composition(closure_of_u1,
								closure_of_u3,
								eee_domain1_si_count,
								eee_domain1_si_count,
								eee_domain1_si_count);

		delete closure_of_u3;
		delete closure_of_u1;

		RelationInt		*c2 = Composition(
								relations_on_a[i].on_a_accesses,
								relations_on_a[i].error_entry_on_a,
								eee_domain1_si_count,
								eee_domain1_si_count,
								eee_domain3_st_count);

		delete relations_on_a[i].on_a_accesses;
		relations_on_a[i].on_a_accesses = 0;
		delete relations_on_a[i].error_entry_on_a;
		relations_on_a[i].error_entry_on_a = 0;

		relations_on_a[i].implies_a_essential =
					Composition(terminal_inverse_of_entered_by,
								c2,
								symbol_count_a,
								eee_domain1_si_count,
								eee_domain3_st_count);

		delete c2;

		VListOrdPairInt				*p = relations_on_a[i].
												implies_a_essential->pairs;
		VListOrdPairInt::listptr	p_listptr;

		p_listptr = p->FirstListPtr();

		while (p_listptr)
		{
			OrdPairInt	&pair = p->NextData(p_listptr);

			CEEEDomain3ST	&d = eee_domain3_st[pair.second];

			d.essential_error_entry_flag = true;
		}

		delete relations_on_a[i].implies_a_essential;
		relations_on_a[i].implies_a_essential = 0;
	}

	delete left_corner_in;
	left_corner_in = 0;
	delete directly_descends;
	directly_descends = 0;

	delete terminal_inverse_of_entered_by;

	delete [] essential_error_entries;

	essential_error_entries = new bool[machine_count * terminal_count_e];

	essential_error_entry_count = 0;

	for (i=0; i<machine_count*terminal_count_e; i++)
		essential_error_entries[i] = false;

	for (i=0; i<machine_count*terminal_count_e; i++)
	{
		CEEEDomain3ST	&d = eee_domain3_st[i];

		if (d.essential_error_entry_flag)
		{
			essential_error_entries[d.machine_state_index * terminal_count_e +
												d.terminal_index] = true;

			essential_error_entry_count++;
		}
	}

	delete [] essential_error_state_terminals;

	essential_error_state_terminals =
		new CErrorStateTerminal[essential_error_entry_count + 2];

	int		est_index	= 2;
	int		a_offset	= 0;
	int		j;

	for (i=0; i<machine_count; i++)
	{
		for (j=0; j<terminal_count_e; j++)
		{
			if (essential_error_entries[a_offset + j] == true)
			{
				essential_error_state_terminals[est_index].state	= i;
				essential_error_state_terminals[est_index].terminal	= j;
				est_index++;
			}
		}

		a_offset += terminal_count_e;
	}
}

void	CParse::ComputeLR1ErrorEntries()
{
	int		i;
	int		j;
	int		a_offset = 0;
	int		g_offset = 0;
	bool	goto_on_shift[machine_count];

	goto_on_shift[0] = true;

	for (i=1; i<machine_count; i++)
		goto_on_shift[i] = false;

	for (i=0; i<machine_count; i++)
	{
		for (j=0; j<terminal_count_e; j++)
			if (action_table[a_offset + j] == shift_action)
				goto_on_shift[goto_table[g_offset + j]] = true;

		a_offset += terminal_count_e;
		g_offset += symbol_count_a;
	}

	delete [] essential_error_entries;

	essential_error_entries = new bool[machine_count * terminal_count_e];

	essential_error_entry_count = 0;

	for (i=0; i<machine_count*terminal_count_e; i++)
		essential_error_entries[i] = false;

	a_offset = 0;

	for (i=0; i<machine_count; i++)
	{
		if (goto_on_shift[i])
		{
			for (j=0; j<terminal_count_e; j++)
			{
				if (action_table[a_offset + j] == error_action)
				{
					essential_error_entries[a_offset + j] = true;

					essential_error_entry_count++;
				}
			}
		}

		a_offset += terminal_count_e;
	}

	delete [] essential_error_state_terminals;

	essential_error_state_terminals =
		new CErrorStateTerminal[essential_error_entry_count + 2];

	int		est_index = 2;

	a_offset = 0;

	for (i=0; i<machine_count; i++)
	{
		for (j=0; j<terminal_count_e; j++)
		{
			if (essential_error_entries[a_offset + j] == true)
			{
				essential_error_state_terminals[est_index].state	= i;
				essential_error_state_terminals[est_index].terminal	= j;
				est_index++;
			}
		}

		a_offset += terminal_count_e;
	}
}
