/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef APPLICATIONMAINWINDOW_H
#define APPLICATIONMAINWINDOW_H

#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <string>
#include <vector>
#include <map>
#include <algorithm>
#include <fstream>
#include <strstream>
#include <iomanip>

#include <qnamespace.h>
#include <qregexp.h>
#include <qsize.h>
#include <qstring.h>
#include <qfont.h>
#include <qfontmetrics.h>
#include <qcolor.h>
#include <qpalette.h>
#include <qobject.h>
#include <qapplication.h>
#include <qwidget.h>
#include <qevent.h>
#include <q3mainwindow.h>
#include <qstatusbar.h>
#include <qworkspace.h>
#include <qstackedwidget.h>
#include <qtabwidget.h>
#include <q3scrollview.h>
#include <q3popupmenu.h>

struct SInterfaceConfiguration;
class CApplication;
class CViewWidgetStack;
class CMainWindow;

#include "functorTemplates.h"
#include "filePath.h"
#include "optionData.h"
#include "applicationTypes.h"
#include "menuControl.h"
#include "menuNodeData.h"
#include "interfaceControl.h"
#include "optionEditView.h"
#include "mainViewMenu.h"
#include "idGenerator.h"
#include "idMap.h"
#include "optionDialog.h"
#include "helpViewer.h"

extern bool		qt_library_warning_message_flag;
void			QtLibraryMessageHandler(QtMsgType type, const char *msg);

struct SInterfaceConfiguration
{
	SInterfaceConfiguration(
		const string &dfe,
		const string &ofe,
		const string &dofn,
		const char * const ddod[],
		const vector< pair<string, int> > *st,
		const map< string, set<string> > *scm,
		const vector< pair<int, SSubmenuNodeData *> > &snd,
		void (*sstd)(),
		CInterfaceControl *(*cic)(
					int c_id, int i_id, CMainViewMenu *mvm, CMainWindow *mw),
		void (*cnd)(),
		bool (*ld)(ifstream &f),
		void (*lde)())
		:	data_file_extension(dfe),
			option_file_extension(ofe),
			default_option_file_name(dofn),
			default_default_option_data(ddod),
			default_option_data(0),
			options_modified_flag(false),
			subview_types(st),
			subview_connection_map(scm),
			submenu_node_data(snd),
			setup_subview_type_data(sstd),
			create_interface_control(cic),
			create_new_data(cnd),
			load_data(ld),
			load_data_error(lde) { }
	~SInterfaceConfiguration() { }

	string					data_file_extension;
	vector<string>			data_file_aliases;
	string					option_file_extension;
	vector<string>			option_file_aliases;
	string					default_option_file_name;
	string					default_option_file_directory;
	const char * const		*default_default_option_data;
	COptionData				*default_option_data;
	bool					options_modified_flag;
	const vector< pair<string, int> >
							*subview_types;
	const map< string, set<string> >
							*subview_connection_map;
	vector< pair<int, SSubmenuNodeData *> >
							submenu_node_data;
	void					(*setup_subview_type_data)();
	CInterfaceControl		*(*create_interface_control)(
				int c_id, int i_id, CMainViewMenu *mvm, CMainWindow *mw);
	void					(*create_new_data)();
	bool					(*load_data)(ifstream &f);
	void					(*load_data_error)();

	bool	LoadDefaultOptionFile();
	bool	SaveDefaultOptionFile();
	bool	CreateDefaultOptions(COptionData **ptr_ptr_od);

	const vector< pair<int, SSubmenuNodeData *> >	&GetSubmenuNodeData() const
	{ return submenu_node_data; }
	const string			&GetDataFileExtension() const
	{ return data_file_extension; }
	const vector<string>	&GetDataFileAliases() const
	{ return data_file_aliases; }
	const string			&GetOptionFileExtension() const
	{ return option_file_extension; }
	const vector<string>	&GetOptionFileAliases() const
	{ return option_file_aliases; }
	const string			&GetDefaultOptionFileName() const
	{ return default_option_file_name; }
	bool					GetOptionsModifiedFlag()
	{ return options_modified_flag; }
	void					SetOptionsModifiedFlag(bool f)
	{ options_modified_flag = f; }
	COptionData				*GetDefaultOptions() const
	{ return default_option_data; }
	void					SetDefaultOptions(COptionData *d)
	{ delete default_option_data; default_option_data = d; }
};

struct SExtensionAlias
{
	SExtensionAlias(const string &a, const string &e)
		: alias(a), extension(e) { }

	string		alias;
	string		extension;
};

struct SInitialFile
{
	SInitialFile(	const string &dfn,
					const string &ofn = "",
					const string &it = "")
		: data_file_name(dfn), option_file_name(ofn), interface_type(it) { }

	string		data_file_name;
	string		option_file_name;
	string		interface_type;
};

struct SMainSubmenuNodeData
{
	enum Operations
	{
		main_submenu_no_open_documents		= 0,
		main_submenu_open_documents			= 1,
		main_submenu_edit_options			= 2,
		main_submenu_operation_count		= 3
	};

	const int		node_type;
	const char		*tree_index;
	const int		node_identifier;
	const char		*text;
	const int		accelerator;
	const char		*slot;
	const int		operation_list[main_submenu_operation_count];
};

struct SFileViewHelpData
{
	int					file_submenu_id;
	int					view_submenu_id;
	int					help_submenu_id;
	SSubmenuNodeData	*file_snd;
	SSubmenuNodeData	*view_snd;
	SSubmenuNodeData	*help_snd;
};

class CApplication: public QApplication
{
	Q_OBJECT
	public:
	CApplication(int &argc, char **argv);
	virtual ~CApplication();

	static int		GetSubmenuNodeCount(const SMainSubmenuNodeData *d);

	void	CreateInterfaceDialogs(QWidget *parent);
	void	DestroyInterfaceDialogs();
	void	SetInterfaceDialogsPaletteAndFont(QWidget *w);
	void	LoadInterfaceConfigurations();
	void	SetupInterfaceConfigurations();
	bool	GetEnvOptionValueString(const char *e, string &option);

	virtual void	GetApplicationOptions();
	virtual void	SetupApplicationOptions(const char *dfea_cl,
											const char *ofea_cl,
											const char *dofn_cl,
											const char *dofd,
											const char *dofd_env,
											const char *dofd_cl,
											const char *ifp_cl,
											const char *ifppt_cl,
											const char *rofn_env,
											const char *rofn_cl);
	virtual void	CreateMainWindow();

	void	LoadDefaultOptionFiles();
	void	SaveDefaultOptionFiles();

	void								SetApplicationCaption(const string &s)
	{ application_caption = s; }
	const string						&GetApplicationCaption() const
	{ return application_caption; }
	void								SetRequestOptionFileNameFlag(bool f)
	{ request_option_file_name_flag = f; }
	bool								GetRequestOptionFileNameFlag() const
	{ return request_option_file_name_flag; }
	CIdGenerator						&GetSubmenuIdGenerator()
	{ return submenu_id_generator; }
	vector<SInterfaceConfiguration>		&GetInterfaceConfigurations()
	{ return interface_configurations; }
	SFileViewHelpData					&GetFileViewHelpData()
	{ return file_view_help_data; }

	private slots:
	void	ApplicationClose();

	protected:
	CIdGenerator						submenu_id_generator;
	static const SMainSubmenuNodeData	file_submenu_node_data[];
	static const SMainSubmenuNodeData	view_submenu_node_data[];
	static const SMainSubmenuNodeData	help_submenu_node_data[];
	static int							file_submenu_id;
	static int							view_submenu_id;
	static int							help_submenu_id;
	SSubmenuNodeData					*file_snd;
	SSubmenuNodeData					*view_snd;
	SSubmenuNodeData					*help_snd;
	vector<SInterfaceConfiguration>		interface_configurations;
	SFileViewHelpData					file_view_help_data;
	map<string, int>					data_file_extension_to_index_map;
	map<string, int>					option_file_extension_to_index_map;
	CMainWindow							*main_window;
	
	string						application_caption;
	vector<SExtensionAlias>		data_file_extension_aliases;
	vector<SExtensionAlias>		option_file_extension_aliases;
	vector<string>				default_option_file_names;
	string						default_option_file_directory;
	vector<SInitialFile>		initial_files;
	bool						request_option_file_name_flag;

	enum OptionCodes
	{
		DataFileExtensionAlias,
		OptionFileExtensionAlias,
		DefaultOptionFileName,
		DefaultOptionFileDirectory,
		InitialFilePair,
		InitialFilePairPlusType,
		RequestOptionFileName
	};

	map<string, OptionCodes>	option_code_map;
};

class CViewWidgetStack: public QStackedWidget
{
	Q_OBJECT
	public:
	CViewWidgetStack(QWorkspace *ws, CInterfaceControl *ic)
		: QStackedWidget(ws), interface_control(ic) { }

	CInterfaceControl	*GetInterfaceControl() const
	{ return interface_control; }

	protected:
	virtual void	closeEvent(QCloseEvent *ev);

	private:
	CInterfaceControl	*interface_control;
};

class CMainWindow: public Q3MainWindow
{
	Q_OBJECT
	public:
	CMainWindow(CApplication *a);
	virtual ~CMainWindow();

	void	SetMainWindowOptions(COptionData *d);
	void	SetOptionEditViewOptions(COptionData *d);
	void	SetApplicationMenuOptions(COptionData *d);
	void	SetHelpViewerOptions(COptionData *d);

	void	CreateNewData(int type);
	bool	LoadData(int type, ifstream &f);
	void	LoadDataError(int type);

	CInterfaceControl
		*CreateApplicationInterfaceControl(	int c_id, int i_id,
											CMainViewMenu *mvm);

	void	SetApplicationData(CInterfaceControl *ic);
	bool	SaveData(ofstream &f, CInterfaceControl *ic);

	enum EventCodes
	{
		InterfaceRestore	= QEvent::User,
		UpdateGeometry		= QEvent::User + 1,
		EventBlockFlag		= QEvent::User + 2
	};

	public slots:
	void	NewFile();
	void	OpenFile();
	void	SaveAsFile();
	void	SaveFile();
	void	CloseFile();
	void	SetInterfaceType(int type);
	void	EditOptions();
	void	CaptureSizeAndPosition();
	void	RestoreViews();
	void	CascadeViews();
	void	TileViews1();
	void	TileViews2();
	void	TileViews3();
	void	TileViews4();
	void	RaiseMainView(int id);
	void	MainViewActivated(QWidget *w);
	void	HelpContents();
	void	AboutCPG();
	void	ApplicationDebug();

	public:
	bool	SaveOptions(ofstream &f, CInterfaceControl *ic);
	bool	ModifyMenu(int id, int op, QObject *obj)
	{ return menu_configuration->ModifyMenu(id, op, obj); }
	void	ModifyFileViewHelpMenu(int op, QObject *obj)
	{
		ModifyMenu(file_submenu_id, op, obj);
		ModifyMenu(view_submenu_id, op, obj);
		ModifyMenu(help_submenu_id, op, obj);
	}
	void		UpdateCurrentFileMessage(	const string &data_file_name,
											const string &option_file_name,
											bool d_modified_flag = false,
											bool o_modified_flag = false);

	protected:
	void	NewFileType(int type);
	void	NewFileMultipleType();
	void	OpenFileSingleType();
	void	OpenFileMultipleType();
	void	SaveAsFileType();
	bool	LoadOptions(ifstream &f, COptionData **option_data);
	void	LoadOptionsError(const string &option_file_name);
	void	LoadInitialFiles();
	void	CreateInterface(int	configuration_id,
							const string &data_file_name,
							const string &option_file_name,
							COptionData *option_data);
	void	DestroyInterface();
	void	ConnectMainViewActivated();
	void	DisconnectMainViewActivated();
	void	ProcessRaiseMainView(int id);

	virtual bool	event(QEvent *ev);
	virtual void	closeEvent(QCloseEvent *event);

	void	AddMainViewId(int mv_id, int ic_id)
	{ main_view_id_to_interface_id_map[mv_id] = ic_id; }
	void	DeleteMainViewId(int mv_id)
	{ main_view_id_to_interface_id_map.erase(mv_id); }

	struct TileData
	{
		TileData(int xo, int yo, int xs, int ys)
		: x_offset(xo), y_offset(yo), x_size(xs), y_size(ys) { }

		int     x_offset;
		int     y_offset;
		int     x_size;
		int     y_size;
	};

	int		GetVisibleChildWidgets(vector<QWidget *> &child_widgets);
	int		CalculateTileCounts(int count, vector<int> &sections);
	int		CalculateTileParameters(int x, int y, vector<int> &sections, vector<TileData> &tiles);

	CApplication			*application;
	QStatusBar				*status_bar;
	InterfaceType			interface_type;
	InterfaceType			interface_restore_type;
	QWidget					*central_widget;
	QWorkspace				*workspace;
	QStackedWidget			*widget_stack;
	Q3ScrollView			*option_edit_scrollview;
	COptionEditFrame		*option_edit_frame;
	CHelpViewer				*help_viewer;

	void					SetupMainMenu();
	QMenuBar				*menu_bar;
	SMainMenuConfiguration	*menu_configuration;
	int						file_submenu_id;
	int						view_submenu_id;
	int						help_submenu_id;
	Q3PopupMenu				*main_view_menu;
	Q3PopupMenu				*interface_type_menu;

	CIdGenerator	interface_id_generator;
	CMainViewMenu	*main_view_menu_manager;

	static int	new_file_id;
	void		GetNewFileNames(int type, string &dfn, string &ofn);

	int								current_main_view_id;
	int								current_interface_id;
	map<int, int>					main_view_id_to_interface_id_map;
	map<int, CInterfaceControl *>	interface_id_to_interface_map;
	map<int, CViewWidgetStack *>	interface_id_to_widget_stack_map;

	bool  file_open_flag;
	bool  event_block_flag;

	public:
	CApplication	*GetApplication() const { return application; }
	int		GetCurrentMainViewId()	const { return current_main_view_id; }
	int		GetCurrentInterfaceId()	const { return current_interface_id; }
	const CIdGenerator					&GetInterfaceIdGenerator() const
	{ return interface_id_generator; }
	const CMainViewMenu					*GetMainViewMenuManager() const
	{ return main_view_menu_manager; }
	const map<int, int>					&GetMainViewIdToInterfaceIdMap() const
	{ return main_view_id_to_interface_id_map; }
	const map<int, CInterfaceControl *>	&GetInterfaceIdToInterfaceMap() const
	{ return interface_id_to_interface_map; }
	const map<int, CViewWidgetStack *>	&GetInterfaceIdToWidgetStackMap() const
	{ return interface_id_to_widget_stack_map; }

	bool	GetFileOpenFlag() const { return file_open_flag; }
	void	SetFileOpenFlag(bool f) { file_open_flag = f; }
	bool	GetEventBlockFlag() const { return event_block_flag; }
	void	SetEventBlockFlag(bool f) { event_block_flag = f; }

	void	PostEventBlockFlag()
	{
		QApplication::postEvent(this, new QEvent((QEvent::Type)EventBlockFlag));
	}

	void	SetupEventBlock()
	{
		SetEventBlockFlag(true);
		PostEventBlockFlag();
	}

	protected:
	void	CreateSDSViews();
	void	CreateMDSViews();
	void	CreateMDMViews();
	void	CreateEOViews();
	void	DestroySDSViews();
	void	DestroyMDSViews();
	void	DestroyMDMViews();
	void	DestroyEOViews();
	bool	CheckSDSViewCount();

	struct check_matching_new_file_names
		: public unary_function<pair<int, CInterfaceControl *>, bool>
	{
		explicit check_matching_new_file_names(	const string &cdn,
												const string &con)
			: check_data_name(cdn), check_option_name(con) { }

		bool	operator()(pair<int, CInterfaceControl *> x);

		private:
		const string		&check_data_name;
		const string		&check_option_name;
	};

	struct check_matching_data_file_name
		: public unary_function<pair<int, CInterfaceControl *>, bool>
	{
		explicit check_matching_data_file_name(const string &cn)
			: check_name(cn) { }

		bool	operator()(pair<int, CInterfaceControl *> x);

		private:
		const string		&check_name;
	};

	struct check_matching_option_file_name
		: public unary_function<pair<int, CInterfaceControl *>, bool>
	{
		explicit check_matching_option_file_name(const string &cn)
			: check_name(cn) { }

		bool	operator()(pair<int, CInterfaceControl *> x);

		private:
		const string		&check_name;
	};

	struct create_workspace_views
		: public unary_function<pair<int, CInterfaceControl *>, void>
	{
		explicit create_workspace_views(QWorkspace *w)
			: workspace(w) { }

		void	operator()(pair<int, CInterfaceControl *> x);

		private:
		QWorkspace		*workspace;
	};

	struct create_widget_stack_views
		: public unary_function<pair<int, CInterfaceControl *>, void>
	{
		explicit create_widget_stack_views(	QWorkspace *w,
											map<int, CViewWidgetStack *> &m)
			: workspace(w), interface_id_to_widget_stack_map(m) { }

		void	operator()(pair<int, CInterfaceControl *> x);

		private:
		QWorkspace						*workspace;
		map<int, CViewWidgetStack *>	&interface_id_to_widget_stack_map;
	};

	struct create_main_view_id_to_interface_id_map
		: public unary_function<pair<int, CInterfaceControl *>, void>
	{
		explicit create_main_view_id_to_interface_id_map(map<int, int> &m)
			: main_view_id_to_interface_id_map(m) { }

		void	operator()(pair<int, CInterfaceControl *> x);

		private:
		map<int, int>	&main_view_id_to_interface_id_map;
	};

	struct destroy_interface_views
		: public unary_function<pair<int, CInterfaceControl *>, void>
	{
		void	operator()(pair<int, CInterfaceControl *> x);
	};

	struct create_interface_id_and_name_vector
		: public unary_function<pair<int, CInterfaceControl *>, void>
	{
		explicit create_interface_id_and_name_vector(
											vector< pair<int, string> > &v)
			: interface_id_and_name_vector(v) { }

		void	operator()(pair<int, CInterfaceControl *> x);

		private:
		vector< pair<int, string> >		&interface_id_and_name_vector;
	};
};

ostream		&operator<<(ostream &s, const CMainWindow &mw);

typedef map<int, int>								IdToIdMap;
typedef map<int, int>::iterator						IdToIdMapIterator;
typedef map<int, CInterfaceControl *>				IdToControlMap;
typedef map<int, CInterfaceControl *>::iterator		IdToControlMapIterator;
typedef map<int, CViewWidgetStack *>				IdToWidgetStackMap;
typedef map<int, CViewWidgetStack *>::iterator		IdToWidgetStackMapIterator;

#endif
