/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef CONFLICTCODEVIEW_H
#define	CONFLICTCODEVIEW_H

class CConflictCodeMultiLineEdit;
class CConflictCodeVBoxWidget;
class CConflictCodeView;

#include <string>
#include <list>

#include <qobject.h>
#include <qwidget.h>
#include <qevent.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "conflictEntryView.h"

class CConflictCodeMultiLineEdit: public CMultiLineEditFc
{
	Q_OBJECT
	public:
	CConflictCodeMultiLineEdit(CConflictCodeVBoxWidget *v)
		: CMultiLineEditFc((QWidget *)v, "", 4), conflict_code_vbox(v) { }
	~CConflictCodeMultiLineEdit() { }

	protected:
	virtual bool	event(QEvent *e);

	private:
	CConflictCodeVBoxWidget		*conflict_code_vbox;
};

class CConflictCodeVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CConflictCodeVBoxWidget(QWidget *parent,
							CCompilerInterface *ci,
							SMainViewControl *mvc,
							COptionData::SSubViewData *d,
							CConflictCodeView *ccv);

	virtual ~CConflictCodeVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializeModulePointers();

	void	ClearMultiLineEditText();
	void	SetTabStopWidth(int count);
	void	SetMultiLineEditText(const list<string> &code);
	void	GetMultiLineEditText(list<string> &code);
	bool	GetCodeEditedFlag();
	void	SetCodeEditedFlag(bool f);
	bool	GetTabIndicator();
	void	ToggleTabIndicator();
	void	ToggleConflictIndicator();
	void	UndoEdit();
	void	RedoEdit();
	void	FindString();
	void	RestoreUndoData();

	public slots:
	void	CodeTextChanged();

	private:
	bool							tab_indicator;
	bool							conflict_indicator;
	CLabelFc						*label;
	CConflictCodeMultiLineEdit		*multi_line_edit;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CConflictCodeView			*conflict_code_view;
	ModulePtrMap				&module_ptr_map;

	CConflictEntryView			*cev;
};

class CConflictCodeView: public CSubView
{
	public:
	CConflictCodeView(	QWidget *p,
						CViewNode *n,
						CInterfaceControl *ic,
						SMainViewControl *mvc,
						const string &dfs,
						CPaletteData *dpd,
						COptionData::SSubViewData *d);

	virtual ~CConflictCodeView();

	virtual CConflictCodeVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	ClearMultiLineEditText();
	void	SetTabStopWidth(int count);
	void	SetMultiLineEditText(const list<string> &code);
	void	GetMultiLineEditText(list<string> &code);
	bool	GetCodeEditedFlag();
	void	SetCodeEditedFlag(bool f);
	void	UndoEdit();
	void	RedoEdit();
	void	FindString();
	void	RestoreUndoData();

	private:
	CConflictCodeVBoxWidget		*frame;
};

#endif
