/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "conflictStatusView.h"

CConflictStatusControl::CConflictStatusControl(CConflictStatusVBoxWidget *v)
	: CFrameFc((QWidget *)v, 5, 2), conflict_status_vbox(v)
{
	QFontInfo		fi(font());

	int		pixel_size = fi.pixelSize();

	int		s = grid_layout_spacing_data[pixel_size];

	subgrid_layout = new QGridLayout(this, 3, 3, 0, s, "subgrid");

	grid_layout->setRowStretch(0, 0);
	grid_layout->setRowStretch(1, 0);
	grid_layout->setRowStretch(2, 0);
	grid_layout->setRowStretch(3, 0);
	grid_layout->setRowStretch(4, 1);

	grid_layout->setColStretch(0, 0);
	grid_layout->setColStretch(1, 1);

	subgrid_layout->setRowStretch(0, 0);
	subgrid_layout->setRowStretch(1, 0);
	subgrid_layout->setRowStretch(2, 1);

	subgrid_layout->setColStretch(0, 0);
	subgrid_layout->setColStretch(1, 0);
	subgrid_layout->setColStretch(2, 1);

	QString     size_string("##############");

	entry_label		= new CLabelFc("Entry", this);
	entry_value		= new CLabelFc("", this);
	state_label		= new CLabelFc("State", this);
	state_value		= new CLabelFc("", this);
	symbol_label	= new CLabelFc("Symbol", this);
	symbol_value	= new CLabelFc("", this);
	action_label	= new CLabelFc("Action", this);
	action_value	= new CLabelFc("", this);

	clear_code_button		= new CPushButtonFc("Clear Code",
									this, size_string);
	default_reset_button	= new CPushButtonFc("Default Action",
									this, size_string);
	clear_all_button		= new CPushButtonFc("Clear All",
									this, size_string);
	default_all_button		= new CPushButtonFc("Default All",
									this, size_string);

	entry_value->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	state_value->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	symbol_value->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	action_value->setFrameStyle(QFrame::Panel | QFrame::Sunken);

	entry_label->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
	entry_value->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
	state_label->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
	state_value->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
	symbol_label->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
	symbol_value->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
	action_label->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
	action_value->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);

	subgrid_layout->addWidget(default_reset_button,		0, 0);
	subgrid_layout->addWidget(default_all_button,		0, 1);
	subgrid_layout->addWidget(clear_code_button,		1, 0);
	subgrid_layout->addWidget(clear_all_button,			1, 1);

	grid_layout->addWidget(entry_label,					0, 0);
	grid_layout->addWidget(entry_value,					0, 1);
	grid_layout->addWidget(state_label,					1, 0);
	grid_layout->addWidget(state_value,					1, 1);
	grid_layout->addWidget(symbol_label,				2, 0);
	grid_layout->addWidget(symbol_value,				2, 1);
	grid_layout->addWidget(action_label,				3, 0);
	grid_layout->addWidget(action_value,				3, 1);
	grid_layout->addMultiCellLayout(subgrid_layout,		4, 4, 0, 1);

	connect(clear_code_button,
			SIGNAL(clicked()),
			SLOT(ClearCodeCurrentEntry()));

	connect(default_reset_button,
			SIGNAL(clicked()),
			SLOT(DefaultResetCurrentEntry()));

	connect(clear_all_button,
			SIGNAL(clicked()),
			SLOT(ClearCodeAll()));

	connect(default_all_button,
			SIGNAL(clicked()),
			SLOT(DefaultResetAll()));
}

void	CConflictStatusControl::setFont(const QFont &f)
{
	QFontInfo       fi(f);

	int     pixel_size = fi.pixelSize();

	int     s = grid_layout_spacing_data[pixel_size];

	subgrid_layout->setMargin(0);
	subgrid_layout->setSpacing(s);
	subgrid_layout->invalidate();

	CFrameFc::setFont(f);
}

void	CConflictStatusControl::ClearStatusControl()
{
	entry_value->clear();
	state_value->clear();
	symbol_value->clear();
	action_value->clear();
}

void	CConflictStatusControl::UpdateStatusControl(const string &entry,
													const string &state,
													const string &symbol,
													const string &action)
{
	entry_value->setText(entry.c_str());
	state_value->setText(state.c_str());
	symbol_value->setText(symbol.c_str());
	action_value->setText(action.c_str());
}

void	CConflictStatusControl::ClearCodeCurrentEntry()
{
	conflict_status_vbox->ClearCodeCurrentEntry();
}

void	CConflictStatusControl::DefaultResetCurrentEntry()
{
	conflict_status_vbox->DefaultResetCurrentEntry();
}

void	CConflictStatusControl::ClearCodeAll()
{
	conflict_status_vbox->ClearCodeAll();
}

void	CConflictStatusControl::DefaultResetAll()
{
	conflict_status_vbox->DefaultResetAll();
}

CConflictStatusVBoxWidget::CConflictStatusVBoxWidget(
								QWidget *parent,
								CCompilerInterface *ci,
								SMainViewControl *mvc,
								COptionData::SSubViewData *d,
								CConflictStatusView *csv)
	: CVBoxWidget(parent, ci, mvc), compiler_interface(ci),
		subview_data(d), conflict_status_view(csv),
		module_ptr_map(csv->GetModulePtrMap())
{
	label = new CLabelFc("status", this, true);

	label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);

	conflict_status_control = new CConflictStatusControl(this);

	conflict_status_control->setFrameStyle(QFrame::Panel | QFrame::Sunken);

	setSpacing(0);
	setStretchFactor(label, 0);
	setStretchFactor(conflict_status_control, 1);

	compiler_data = compiler_interface->GetCompilerData();
}

CConflictStatusVBoxWidget::~CConflictStatusVBoxWidget()
{
}

void	CConflictStatusVBoxWidget::ClearStatusControl()
{
	conflict_status_control->ClearStatusControl();
}

void	CConflictStatusVBoxWidget::UpdateStatusControl(	const string &entry,
														const string &state,
														const string &symbol,
														const string &action)
{
	conflict_status_control->UpdateStatusControl(entry, state, symbol, action);
}

void	CConflictStatusVBoxWidget::ClearCodeCurrentEntry()
{
	vector<CSubView *>		&v1 = module_ptr_map["CONFLICT_ENTRY_VIEW"];

	if (v1.size())
	{
		CConflictEntryView	*cev = dynamic_cast<CConflictEntryView *>(v1[0]);

		cev->ClearCodeCurrentEntry();
	}
}

void	CConflictStatusVBoxWidget::DefaultResetCurrentEntry()
{
	vector<CSubView *>		&v1 = module_ptr_map["CONFLICT_ENTRY_VIEW"];

	if (v1.size())
	{
		CConflictEntryView	*cev = dynamic_cast<CConflictEntryView *>(v1[0]);

		cev->DefaultResetCurrentEntry();
	}
}

void	CConflictStatusVBoxWidget::ClearCodeAll()
{
	vector<CSubView *>		&v1 = module_ptr_map["CONFLICT_ENTRY_VIEW"];

	if (v1.size())
	{
		CConflictEntryView	*cev = dynamic_cast<CConflictEntryView *>(v1[0]);

		cev->ClearCodeAll();
	}
}

void	CConflictStatusVBoxWidget::DefaultResetAll()
{
	vector<CSubView *>		&v1 = module_ptr_map["CONFLICT_ENTRY_VIEW"];

	if (v1.size())
	{
		CConflictEntryView	*cev = dynamic_cast<CConflictEntryView *>(v1[0]);

		cev->DefaultResetAll();
	}
}

void	CConflictStatusVBoxWidget::InitializeModulePointers()
{
}

void	CConflictStatusVBoxWidget::RestoreUndoData()
{
	compiler_data = compiler_interface->GetCompilerData();
}

CConflictStatusView::CConflictStatusView(	QWidget *p,
											CViewNode *n,
											CInterfaceControl *ic,
											SMainViewControl *mvc,
											const string &dfs,
											CPaletteData *dpd,
											COptionData::SSubViewData *d)
	: CSubView(p, n, ic, mvc, dfs, dpd, d)
{
	frame = new CConflictStatusVBoxWidget(
		p, dynamic_cast<CCompilerInterface *>(ic), mvc, d, this);

	QFont		view_node_font;
	QPalette	view_node_palette;

	if (SetupViewNodeFont(view_node_font))
		frame->setFont(view_node_font);
	else
		frame->setFont(frame->font());

	if (SetupViewNodePalette(view_node_palette))
		frame->setPalette(view_node_palette);
	else
		frame->setPalette(frame->palette());
}

CConflictStatusView::~CConflictStatusView()
{
	delete frame;
}

void	CConflictStatusView::SetHighlightPalette(CPaletteData *pd)
{
	restore_palette = frame->palette();

	QPalette	highlight_palette;

	pd->SetupPalette(highlight_palette);

	frame->setPalette(highlight_palette);
}

void	CConflictStatusView::RestorePalette()
{
	frame->setPalette(restore_palette);
}

void	CConflictStatusView::InitializeModulePointers()
{
	frame->InitializeModulePointers();
}

void	CConflictStatusView::ClearStatusControl()
{
	frame->ClearStatusControl();
}

void	CConflictStatusView::UpdateStatusControl(	const string &entry,
													const string &state,
													const string &symbol,
													const string &action)
{
	frame->UpdateStatusControl(entry, state, symbol, action);
}

void	CConflictStatusView::RestoreUndoData()
{
	frame->RestoreUndoData();
}
