/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef CONNECTIONINTERFACE_H
#define	CONNECTIONINTERFACE_H

#include <string>
#include <vector>
#include <map>
#include <set>

#include "optionData.h"

class CInterfaceControl;
class CSubView;

namespace ConnectionInterface
{
	typedef map<string, vector<CSubView *> >	ModulePtrMap;

	typedef map<vector<int>, bool>				ConnectionIndexMap;
	typedef map<string, ConnectionIndexMap>		ConnectionSubtypeMap;
	typedef map<string, ConnectionSubtypeMap>	ConnectionMainViewMap;

	typedef map<vector<int>,
		pair<COptionData::SSubViewData *, ConnectionMainViewMap *> >	
												OptionDataIndexMap;
	typedef map<string, OptionDataIndexMap>		OptionDataSubtypeMap;
	typedef map<string, OptionDataSubtypeMap>	OptionDataMainViewMap;

	typedef map<vector<int>,
				pair<CSubView *, bool> >		RuntimeIndexMap;
	typedef map<string, RuntimeIndexMap>		RuntimeSubtypeMap;
	typedef map<string, RuntimeSubtypeMap>		RuntimeMainViewMap;

	typedef map<vector<int>, bool>::iterator
												ConnectionIndexMapIterator;
	typedef map<string, ConnectionIndexMap>::iterator
												ConnectionSubtypeMapIterator;
	typedef map<string, ConnectionSubtypeMap>::iterator
												ConnectionMainViewMapIterator;

	typedef map<vector<int>, bool>::reverse_iterator
										ReverseConnectionIndexMapIterator;
	typedef map<string, ConnectionIndexMap>::reverse_iterator
										ReverseConnectionSubtypeMapIterator;
	typedef map<string, ConnectionSubtypeMap>::reverse_iterator
										ReverseConnectionMainViewMapIterator;

	typedef map<vector<int>,
		pair<COptionData::SSubViewData *, ConnectionMainViewMap *> >::iterator	
												OptionDataIndexMapIterator;
	typedef map<string, OptionDataIndexMap>::iterator
												OptionDataSubtypeMapIterator;
	typedef map<string, OptionDataSubtypeMap>::iterator
												OptionDataMainViewMapIterator;

	typedef map<vector<int>,
		pair<COptionData::SSubViewData *,
			ConnectionMainViewMap *> >::reverse_iterator	
										ReverseOptionDataIndexMapIterator;
	typedef map<string, OptionDataIndexMap>::reverse_iterator
										ReverseOptionDataSubtypeMapIterator;
	typedef map<string, OptionDataSubtypeMap>::reverse_iterator
										ReverseOptionDataMainViewMapIterator;

	typedef map<vector<int>,
				pair<CSubView *, bool> >::iterator
												RuntimeIndexMapIterator;
	typedef map<string, RuntimeIndexMap>::iterator
												RuntimeSubtypeMapIterator;
	typedef map<string, RuntimeSubtypeMap>::iterator
												RuntimeMainViewMapIterator;

	OptionDataMainViewMap	*CreateOptionDataMainViewMap(
							COptionData *d,
							const map< string, set<string> >
								*subview_connection_map);

	ConnectionMainViewMap	*CreateConnectionMainViewMap(
							COptionData *d,
							COptionData::SSubViewData *svd,
							const map< string, set<string> >
								*subview_connection_map);

	void					InitializeConnectionMainViewMap(
								COptionData::SSubViewData *svd,
								ConnectionMainViewMap *cmvm);

	void	StoreOptionDataMainViewMap(OptionDataMainViewMap *odmvm);

	void	StoreConnectionMainViewMap(	COptionData::SSubViewData *svd,
										ConnectionMainViewMap *cmvm);

	void	DestroyOptionDataMainViewMap(OptionDataMainViewMap *odmvm);

	RuntimeMainViewMap		*CreateRuntimeMainViewMap(CInterfaceControl *ic);

	void	StoreRuntimeMainViewMap(CInterfaceControl *ic,
									RuntimeMainViewMap *rmvm);

	void	ClearRuntimeMainViewMap(RuntimeMainViewMap *rmvm);

	void	InitializeModulePtrMap(	RuntimeMainViewMap *rmvm,
									COptionData::SSubViewData *svd,
									ModulePtrMap &mpm);
};

#include "interfaceControl.h"
#include "viewControl.h"

#endif
