/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef DEFAULTINTERFACE_H
#define DEFAULTINTERFACE_H

#include <qdesktopwidget.h>

class CDefaultData;
class CDefaultInterface;

#include "interfaceControl.h"
#include "undefinedView.h"
#include "defaultView.h"
#include "connectionView.h"

class CDefaultData
{
	public:
	void	SetData(const string &name,
					const string &index,
					const string &data);
	void	SetData(const string &name,
					const vector<int> &index,
					const string &data)
	{ data_map[pair<string , vector<int> >(name, index)] = data; }
	string	&GetData(const string &name, const string &index);
	string	&GetData(const string &name, const vector<int> &index)
	{ return data_map[pair<string , vector<int> >(name, index)]; }

	static void		CreateIndexText(ostrstream &s,
									const vector<int> &index,
									bool f = true);

	const map<pair<string, vector<int> >, string>	&GetDataMap() const
	{ return data_map; }

	private:
	map<pair<string, vector<int> >, string>		data_map;
};

struct output_default_data_map
	: public unary_function<pair<pair<string, vector<int> >, string >, void>
{
	explicit output_default_data_map(ostream &os)
		: output_stream(os) { }

	void	operator()(pair<pair<string, vector<int> >, string > x)
	{
		string			&name	= x.first.first;
		vector<int>		&index	= x.first.second;
		string			&data	= x.second;

		output_stream << name << endl;

		if (index.size())
		{
			vector<int>::size_type	i;

			for (i=0; i<index.size()-1; i++)
				output_stream << index[i] << ", ";

			output_stream << index[index.size()-1];
		}

		output_stream << endl;
		output_stream << data << endl;
	}

	private:
	ostream		&output_stream;
};

istream		&operator>>(istream &s, CDefaultData &dd);
ostream		&operator<<(ostream &s, const CDefaultData &dd);

class CDefaultInterface: public CInterfaceControl
{
	Q_OBJECT
	public:
	CDefaultInterface(int c_id, int i_id, CMainViewMenu *mvm, CMainWindow *mw);
	virtual ~CDefaultInterface();

	CDefaultData	*GetDefaultData() const		{ return default_data; }
	void			SetDefaultData(CDefaultData *d)
	{ delete default_data; default_data = d; }

	virtual void	InitializeModulePointers();
	virtual void	SetModulePointer(CSubView *sv, const string &type);
	virtual void	EnableInterfaceMenu();
	virtual void	DisableInterfaceMenu();

	static CInterfaceControl	*CreateInterfaceControl(
					int c_id, int i_id, CMainViewMenu *mvm, CMainWindow *mw);

	static void		CreateNewData();
	static bool		LoadData(ifstream &f);
	static void		LoadDataError();
	virtual void	PostApplicationData();
	virtual void    SetApplicationData();
	virtual bool    SaveData(ofstream &f);

	virtual CSubView	*CreateSubView(	QWidget *p,
										CViewNode *n,
										CInterfaceControl *ic,
										SMainViewControl *mvc,
										const string &dfs,
										CPaletteData *dpd,
										COptionData::SSubViewData *d);

	public slots:
	void	SendAll();
	void	SendSelected();

	public:
	static CDefaultData						*default_data_load;
	static vector< pair<string, int> >		subview_types;
	static map< string, set<string> >		subview_connection_map;
	static void								SetupSubviewTypeData();

	static void		SetupConfiguration(	vector<SInterfaceConfiguration> &c,
										CIdGenerator &submenu_id_generator);
	static void		SetupSubmenuNodeData(
							vector< pair<int, SSubmenuNodeData *> > &d,
							CIdGenerator &submenu_id_generator);

	CDefaultView		*default_view;
	CConnectionView		*connection_view;

	CDefaultData		*default_data;

	struct SDefaultSubmenuNodeData
	{
		enum Operations
		{
			default_submenu_interface_enable	= 0,
			default_submenu_interface_disable	= 1,
			default_submenu_operation_count		= 2
		};

		const int		node_type;
		const char		*tree_index;
		const int		node_identifier;
		const char		*text;
		const int		accelerator;
		const char		*slot;
		const int		operation_list[default_submenu_operation_count];
	};

	static int		GetSubmenuNodeCount(const SDefaultSubmenuNodeData *d);

	static int									default_submenu_id;
	static const	SDefaultSubmenuNodeData		default_submenu_node_data[];

	static const char * const	default_default_option_data[];
};

#endif
