/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef DEFAULTVIEW_H
#define	DEFAULTVIEW_H

class CDefaultFrameWidget;
class CDefaultView;

#include "viewControl.h"
#include "connectionView.h"
#include "defaultInterface.h"

class CDefaultFrameWidget: public CFrameWidget
{
	Q_OBJECT
	public:
	CDefaultFrameWidget(QWidget *parent,
						CDefaultInterface *di,
						SMainViewControl *mvc,
						COptionData::SSubViewData *d,
						CDefaultView *dv);

	virtual ~CDefaultFrameWidget();

	void	SetLabelText(const QString &s);

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	private:
	QGridLayout		*grid_layout;
	CLabelFc		*label;

	CDefaultInterface			*default_interface;
	COptionData::SSubViewData	*subview_data;
	CDefaultView				*default_view;
	string						index_text;
	string						default_text;
};

class CDefaultView: public CSubView
{
	public:
	CDefaultView(	QWidget *p,
					CViewNode *n,
					CInterfaceControl *ic,
					SMainViewControl *mvc,
					const string &dfs,
					CPaletteData *dpd,
					COptionData::SSubViewData *d);

	virtual ~CDefaultView();

	void	SetLabelText(const QString &s);

	virtual CDefaultFrameWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	protected:
	CDefaultFrameWidget		*frame;
};

#endif
