/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef ESCAPEPARSERDRIVER_H
#define ESCAPEPARSERDRIVER_H

#include "escapeParserData.h"
#include "parserDriver.h"


class CEscapeParserDriver: public CParserDriver
{
    public:
    CEscapeParserDriver();
    virtual ~CEscapeParserDriver();

    virtual void    SetupFunctionTables();
    virtual int     CallReduceFunction(int action, void *data);
    virtual void    CallConflictFunction(int index);
    virtual void    CallErrorFunction(int index);
    virtual void    DeleteGeneratedCode(CStackElement *s, int c);


//  rule reduce function declarations for CEscapeParserDriver

    int     (CEscapeParserDriver::* *reduce_functions)(void *data);

    int     Reduce_00(void *data);
    int     Reduce_01(void *data);
    int     Reduce_02(void *data);
    int     Reduce_03(void *data);
    int     Reduce_04(void *data);
    int     Reduce_05(void *data);
    int     Reduce_06(void *data);
    int     Reduce_07(void *data);
    int     Reduce_08(void *data);
    int     Reduce_09(void *data);
    int     Reduce_10(void *data);

//  conflict function declarations for CEscapeParserDriver

    void    (CEscapeParserDriver::* *conflict_functions)();


//  parser error function declarations for CEscapeParserDriver

    void    (CEscapeParserDriver::* *error_functions)();

    void    Error_1();
    void    Error_2();
};

#endif
