/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "idGenerator.h"

const int	CIdGenerator::default_initial_size = 20;

CIdGenerator::CIdGenerator(int s)
{
	initial_size	= s;
	current_size	= s;

	int		i;

	for (i=0; i<initial_size; i++)
		id_list.push_back(i);
}

CIdGenerator::~CIdGenerator()
{
}

int		CIdGenerator::GetId()
{
	int		i;

	if (id_list.empty())
	{
		for (i=current_size; i<current_size + initial_size; i++)
			id_list.push_back(i);

		current_size += initial_size;
	}

	list<int>::iterator		id_list_iterator = id_list.begin();
	
	int		id = id_list.front();

	id_list.erase(id_list_iterator);

	return id;
}

CIdGenerator::rvalue	CIdGenerator::ReturnId(int id)
{
	if (id < 0 || id >= current_size)
		return OutOfRange;

	list<int>::iterator		id_list_iterator;

	for (	id_list_iterator = id_list.begin();
			id_list_iterator != id_list.end();
			++id_list_iterator)
	{
		if (id == *id_list_iterator)
			return DuplicateId;

		if (id < *id_list_iterator)
		{
			id_list.insert(id_list_iterator, id);
			return NoError;
		}
	}

	id_list.push_back(id);
	return NoError;
}

const list<int>&	CIdGenerator::GetIdList() const
{
	return id_list;
}

ostream		&operator<<(ostream &s, const CIdGenerator &idg)
{
	const list<int>	&id_list = idg.GetIdList();

	list<int>::const_iterator		id_list_iterator = id_list.begin();

	if (id_list.size() > 1)
	{
		unsigned int	i;
		for (i=0; i<id_list.size()-1; i++)
		{
			s << *id_list_iterator << ", ";
			++id_list_iterator;
		}
	}

	if (!id_list.empty())
		s << *id_list_iterator;

	return s;
}
