/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "applicationMainWindow.h"
#include "defaultInterface.h"
#include "compilerInterface.h"
#include "grammarDialog.h"
#include "parserDialog.h"

int		main(int argc, char *argv[])
{
	qInstallMsgHandler(QtLibraryMessageHandler);

	CApplication::setDesktopSettingsAware(false);
	CApplication	a(argc, argv);

	a.GetApplicationOptions();
	a.SetupInterfaceConfigurations();
	a.LoadDefaultOptionFiles();
	a.CreateMainWindow();
	a.connect(&a, SIGNAL(lastWindowClosed()), &a, SLOT(ApplicationClose()));

	int		status = a.exec();

	return status;
}

void	CApplication::LoadInterfaceConfigurations()
{
//	CDefaultInterface::SetupConfiguration(	GetInterfaceConfigurations(),
//											GetSubmenuIdGenerator());

	CCompilerInterface::SetupConfiguration(	GetInterfaceConfigurations(),
											GetSubmenuIdGenerator());

	SetApplicationCaption("compiler");
}

void	CApplication::CreateInterfaceDialogs(QWidget *parent)
{
	GrammarDialog::CreateGrammarDialogs(parent);
	ParserDialog::CreateParserDialogs(parent);
}

void	CApplication::DestroyInterfaceDialogs()
{
	GrammarDialog::DestroyGrammarDialogs();
	ParserDialog::DestroyParserDialogs();
}

void	CApplication::SetInterfaceDialogsPaletteAndFont(QWidget *w)
{
}
