/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "optionLexicalDriver.h"

bool	COptionLexicalDriver::integer_out_of_range_flag;

COptionLexicalDriver::COptionLexicalDriver()
    : CLexicalRegexpDriver(
        Option_Token_Count,
        Option_Filter_Count,
        Option_Terminal_Count,
        Option_Empty_Symbol_Token,
        Option_Input_Range,
        Option_FSM_Count,
        Option_FSM_Table,
        Option_Regexp_Match,
        Option_Prefix_Match,
        Option_Terminal_Match,
        Option_Start_Assignment,
        Option_Trailing_Context,
        Option_Token_Map,
        Option_Filter_Map,
        Option_Literal_Terminal,
        Option_Single_Column_Match)
{
    token_functions =
        new (void (COptionLexicalDriver::*[token_count])(CStackElement *));

    filter_functions =
        new (void (COptionLexicalDriver::*[filter_count])());

    SetupFunctionTables();

}

COptionLexicalDriver::~COptionLexicalDriver()
{
    delete [] token_functions;
    delete [] filter_functions;

}

void    COptionLexicalDriver::LoadStackElement(CStackElement *se)
{
    if (0 <= current_token && current_token < token_count)
    {
        se->token = current_token;

        if (!process_terminal_flag || GetCurrentLiteralTerminalFlag())
            se->type = StackLiteralToken;
        else
            (this->*token_functions[current_token])(se);
    }
}

void    COptionLexicalDriver::ProcessFilter()
{
    if (process_terminal_flag && !GetCurrentLiteralTerminalFlag())
        (this->*filter_functions[current_filter])();
}

//  terminal function definitions for COptionLexicalDriver

//  00  FILTER  LITERAL  FILTER1              [\n\r\t\ ,]+
//
void    COptionLexicalDriver::Filter_0()
{
}

//  01  FILTER  LITERAL  FILTER2              \#.*\n
//
void    COptionLexicalDriver::Filter_1()
{
}

//  02  TOKEN   LITERAL  APPLICATION          APPLICATION
//
void    COptionLexicalDriver::Token_00(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  03  TOKEN   LITERAL  HELP                 HELP
//
void    COptionLexicalDriver::Token_01(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  04  TOKEN   LITERAL  AUXILIARY_PALETTE    AUXILIARY_PALETTE
//
void    COptionLexicalDriver::Token_02(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  05  TOKEN   LITERAL  AUXILIARY_COLOR      AUXILIARY_COLOR
//
void    COptionLexicalDriver::Token_03(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  06  TOKEN   LITERAL  AUXILIARY_BRUSH      AUXILIARY_BRUSH
//
void    COptionLexicalDriver::Token_04(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  07  TOKEN   LITERAL  AUXILIARY_XPM_IMAGE  AUXILIARY_XPM_IMAGE
//
void    COptionLexicalDriver::Token_05(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  08  TOKEN   LITERAL  AUXILIARY_FONT       AUXILIARY_FONT
//
void    COptionLexicalDriver::Token_06(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  09  TOKEN   LITERAL  AUXILIARY_STRING     AUXILIARY_STRING
//
void    COptionLexicalDriver::Token_07(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  10  TOKEN   LITERAL  MAIN_VIEW            MAIN_VIEW
//
void    COptionLexicalDriver::Token_08(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  11  TOKEN   LITERAL  DEFAULT_DISPLAY      DEFAULT_DISPLAY
//
void    COptionLexicalDriver::Token_09(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  12  TOKEN   LITERAL  SPLITTER             SPLITTER
//
void    COptionLexicalDriver::Token_10(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  13  TOKEN   LITERAL  ORIENTATION          ORIENTATION
//
void    COptionLexicalDriver::Token_11(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  14  TOKEN   LITERAL  PANE_SIZE            PANE_SIZE
//
void    COptionLexicalDriver::Token_12(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  15  TOKEN   LITERAL  SUBVIEW              SUBVIEW
//
void    COptionLexicalDriver::Token_13(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  16  TOKEN   LITERAL  INTERFACE            INTERFACE
//
void    COptionLexicalDriver::Token_14(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  17  TOKEN   LITERAL  INDEX                INDEX
//
void    COptionLexicalDriver::Token_15(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  18  TOKEN   LITERAL  POSITION             POSITION
//
void    COptionLexicalDriver::Token_16(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  19  TOKEN   LITERAL  SIZE                 SIZE
//
void    COptionLexicalDriver::Token_17(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  20  TOKEN   LITERAL  FONT                 FONT
//
void    COptionLexicalDriver::Token_18(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  21  TOKEN   LITERAL  PALETTE              PALETTE
//
void    COptionLexicalDriver::Token_19(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  22  TOKEN   LITERAL  GROUP_ROLE           GROUP_ROLE
//
void    COptionLexicalDriver::Token_20(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  23  TOKEN   LITERAL  BUTTON_COLOR         BUTTON_COLOR
//
void    COptionLexicalDriver::Token_21(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  24  TOKEN   LITERAL  BACKGROUND_COLOR     BACKGROUND_COLOR
//
void    COptionLexicalDriver::Token_22(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  25  TOKEN   LITERAL  BRUSH                BRUSH
//
void    COptionLexicalDriver::Token_23(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  26  TOKEN   LITERAL  RGB                  RGB
//
void    COptionLexicalDriver::Token_24(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  27  TOKEN   LITERAL  HSV                  HSV
//
void    COptionLexicalDriver::Token_25(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  28  TOKEN   LITERAL  COLOR_NAME           COLOR_NAME
//
void    COptionLexicalDriver::Token_26(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  29  TOKEN   LITERAL  XPM_IMAGE            XPM_IMAGE
//
void    COptionLexicalDriver::Token_27(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  30  TOKEN   LITERAL  SCOPE                ::
//
void    COptionLexicalDriver::Token_28(CStackElement *se)
{
    se->type = StackLiteralToken;
}

//  31  TOKEN   REGEXP   INTEGER              (\+|\-)?[0-9]+
//
void    COptionLexicalDriver::Token_29(CStackElement *se)
{
	se->type				= StackScalar;

	errno = 0;

	se->scalar.scalar_int	= strtol((const char *)GetTerminalString(), 0, 0);

	if (errno == ERANGE)
		integer_out_of_range_flag = true;
}

//  32  TOKEN   REGEXP   STRING               [^\n\r\t\ \\\",:]+
//
void    COptionLexicalDriver::Token_30(CStackElement *se)
{
	se->type		= StackCharArray;
	se->char_array	= new unsigned char[GetTerminalLength() + 1];

	strcpy((char *)se->char_array, (const char *)GetTerminalString());
}

//  33  TOKEN   REGEXP   QUOTED_STRING        \"([^\n\r\t\\\":]|(\\[^\n\r\t]))*\"
//
void    COptionLexicalDriver::Token_31(CStackElement *se)
{
	se->type		= StackCharArray;

	int		length = GetTerminalLength() - 2;

	se->char_array	= new unsigned char[length + 1];

	int				index_dest		= 0;
	int				index_src		= 1;
	unsigned char	*token_string	= GetTerminalString();

	while (index_src < length + 1)
	{
		if (token_string[index_src] == '\\')
			index_src++;

		se->char_array[index_dest] = token_string[index_src];

		index_dest++;
		index_src++;
	}

	se->char_array[index_dest] = '\0';
}

void    COptionLexicalDriver::SetupFunctionTables()
{
    token_functions[ 0] = &COptionLexicalDriver::Token_00;
    token_functions[ 1] = &COptionLexicalDriver::Token_01;
    token_functions[ 2] = &COptionLexicalDriver::Token_02;
    token_functions[ 3] = &COptionLexicalDriver::Token_03;
    token_functions[ 4] = &COptionLexicalDriver::Token_04;
    token_functions[ 5] = &COptionLexicalDriver::Token_05;
    token_functions[ 6] = &COptionLexicalDriver::Token_06;
    token_functions[ 7] = &COptionLexicalDriver::Token_07;
    token_functions[ 8] = &COptionLexicalDriver::Token_08;
    token_functions[ 9] = &COptionLexicalDriver::Token_09;
    token_functions[10] = &COptionLexicalDriver::Token_10;
    token_functions[11] = &COptionLexicalDriver::Token_11;
    token_functions[12] = &COptionLexicalDriver::Token_12;
    token_functions[13] = &COptionLexicalDriver::Token_13;
    token_functions[14] = &COptionLexicalDriver::Token_14;
    token_functions[15] = &COptionLexicalDriver::Token_15;
    token_functions[16] = &COptionLexicalDriver::Token_16;
    token_functions[17] = &COptionLexicalDriver::Token_17;
    token_functions[18] = &COptionLexicalDriver::Token_18;
    token_functions[19] = &COptionLexicalDriver::Token_19;
    token_functions[20] = &COptionLexicalDriver::Token_20;
    token_functions[21] = &COptionLexicalDriver::Token_21;
    token_functions[22] = &COptionLexicalDriver::Token_22;
    token_functions[23] = &COptionLexicalDriver::Token_23;
    token_functions[24] = &COptionLexicalDriver::Token_24;
    token_functions[25] = &COptionLexicalDriver::Token_25;
    token_functions[26] = &COptionLexicalDriver::Token_26;
    token_functions[27] = &COptionLexicalDriver::Token_27;
    token_functions[28] = &COptionLexicalDriver::Token_28;
    token_functions[29] = &COptionLexicalDriver::Token_29;
    token_functions[30] = &COptionLexicalDriver::Token_30;
    token_functions[31] = &COptionLexicalDriver::Token_31;

    filter_functions[0] = &COptionLexicalDriver::Filter_0;
    filter_functions[1] = &COptionLexicalDriver::Filter_1;
}
