/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef RULESELECTVIEW_H
#define	RULESELECTVIEW_H

class CRuleSelectListView;
class CRuleSelectVBoxWidget;
class CRuleSelectView;

#include <qobject.h>
#include <qwidget.h>
#include <q3listview.h>
#include <q3header.h>
#include <qevent.h>
#include <qcolor.h>
#include <qpalette.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "ruleCodeView.h"

class CRuleSelectListView: public Q3ListView
{
	Q_OBJECT
	public:
	CRuleSelectListView(CRuleSelectVBoxWidget *v)
		: Q3ListView((QWidget *)v, 0, 0), rule_select_vbox(v) { }
	~CRuleSelectListView() { }

	void	InitializePalette(const QPalette &p);

	protected:
	virtual void	focusInEvent(QFocusEvent *e);
	virtual void	focusOutEvent(QFocusEvent *e);

	private:
	CRuleSelectVBoxWidget	*rule_select_vbox;
	QColor					active_highlight;
	QColor					active_highlighted_text;
	QColor					inactive_highlight;
	QColor					inactive_highlighted_text;
};

class CRuleSelectVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CRuleSelectVBoxWidget(	QWidget *parent,
							CCompilerInterface *ci,
							SMainViewControl *mvc,
							COptionData::SSubViewData *d,
							CRuleSelectView *rsv);

	virtual ~CRuleSelectVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializePalette(const QPalette &p)
	{ list_view->InitializePalette(p); }
	void	InitializeModulePointers();

	void	UpdateListView();
	void	GetCurrentFunctionString(string &s);
	void	PostCurrentFunctionChanges();
	void	RestoreUndoData();
	void	CodeTextChanged();

	public slots:
	void	SelectRuleFunction(Q3ListViewItem *item);

	private:
	CLabelFc					*label;
	CRuleSelectListView			*list_view;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CRuleSelectView				*rule_select_view;
	ModulePtrMap				&module_ptr_map;

	CRuleCodeView				*rcv;

	int		current_function;
	void	IndexString(int index, string &s);
	void	FunctionString(const CRule *r, string &s, bool f = false);
	void	UpdateRuleViews();
};

class CRuleSelectView: public CSubView
{
	public:
	CRuleSelectView(QWidget *p,
					CViewNode *n,
					CInterfaceControl *ic,
					SMainViewControl *mvc,
					const string &dfs,
					CPaletteData *dpd,
					COptionData::SSubViewData *d);

	virtual ~CRuleSelectView();

	virtual CRuleSelectVBoxWidget	*GetWidget() { return frame; }
	virtual void					SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	UpdateListView();
	void	GetCurrentFunctionString(string &s);
	void	PostCurrentFunctionChanges();
	void	RestoreUndoData();
	void	CodeTextChanged();

	private:
	CRuleSelectVBoxWidget		*frame;
};

#endif
