/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef TERMINALCODEVIEW_H
#define	TERMINALCODEVIEW_H

class CTerminalCodeMultiLineEdit;
class CTerminalCodeVBoxWidget;
class CTerminalCodeView;

#include <string>
#include <list>

#include <qobject.h>
#include <qwidget.h>
#include <qevent.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "terminalSelectView.h"

class CTerminalCodeMultiLineEdit: public CMultiLineEditFc
{
	Q_OBJECT
	public:
	CTerminalCodeMultiLineEdit(CTerminalCodeVBoxWidget *v)
		: CMultiLineEditFc((QWidget *)v, "", 4), terminal_code_vbox(v) { }
	~CTerminalCodeMultiLineEdit() { }

	protected:
	virtual bool	event(QEvent *e);

	private:
	CTerminalCodeVBoxWidget		*terminal_code_vbox;
};

class CTerminalCodeVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CTerminalCodeVBoxWidget(QWidget *parent,
							CCompilerInterface *ci,
							SMainViewControl *mvc,
							COptionData::SSubViewData *d,
							CTerminalCodeView *tcv);

	virtual ~CTerminalCodeVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializeModulePointers();

	void	ClearMultiLineEditText();
	void	SetTabStopWidth(int count);
	void	SetMultiLineEditText(const list<string> &code);
	void	GetMultiLineEditText(list<string> &code);
	bool	GetCodeEditedFlag();
	void	SetCodeEditedFlag(bool f);
	bool	GetTabIndicator();
	void	ToggleTabIndicator();
	void	ToggleTerminalIndicator();
	void	UndoEdit();
	void	RedoEdit();
	void	FindString();
	void	RestoreUndoData();

	public slots:
	void	CodeTextChanged();

	private:
	bool						tab_indicator;
	bool						terminal_indicator;
	CLabelFc					*label;
	CTerminalCodeMultiLineEdit	*multi_line_edit;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CTerminalCodeView			*terminal_code_view;
	ModulePtrMap				&module_ptr_map;

	CTerminalSelectView			*tsv;
};

class CTerminalCodeView: public CSubView
{
	public:
	CTerminalCodeView(	QWidget *p,
						CViewNode *n,
						CInterfaceControl *ic,
						SMainViewControl *mvc,
						const string &dfs,
						CPaletteData *dpd,
						COptionData::SSubViewData *d);

	virtual ~CTerminalCodeView();

	virtual CTerminalCodeVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	ClearMultiLineEditText();
	void	SetTabStopWidth(int count);
	void	SetMultiLineEditText(const list<string> &code);
	void	GetMultiLineEditText(list<string> &code);
	bool	GetCodeEditedFlag();
	void	SetCodeEditedFlag(bool f);
	void	UndoEdit();
	void	RedoEdit();
	void	FindString();
	void	RestoreUndoData();

	private:
	CTerminalCodeVBoxWidget		*frame;
};

#endif
