/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "ttyTree.h"

int			SttyTreeNode::token_count					= 0;
int			SttyTreeNode::reduction_count				= 0;
int			SttyTreeNode::tree_level					= 0;
int			SttyTreeNode::horizontal_spacing			= 3;
int			SttyTreeNode::vertical_spacing				= 1;
bool		SttyTreeNode::global_print_value_only_flag	= true;
list<int>	SttyTreeNode::bar_position_list;

SttyTreeNode	*parse_tree;

SttyTreeNode::SttyTreeNode(	SttyTreeNode *p,
							SymbolType t,
							const char *n,
							const char *v,
							bool f)
{
	parent					= p;
	symbol_type				= t;
	print_value_only_flag	= f;

	if (n)
		name_text = n;

	if (v)
		value_text = v;
}

SttyTreeNode::SttyTreeNode(const char *n)
{
	if (n)
		name_text = n;
}

SttyTreeNode::~SttyTreeNode()
{
	for_each(children.begin(), children.end(), destroy_T<SttyTreeNode *>());
}

bool	SttyTreeNode::operator==(const SttyTreeNode &node) const
{
	return (name_text == node.name_text);
}

void	SttyTreeNode::shift(const char *token_name,
							const char *token_value,
							bool p_flag)
{
	SttyTreeNode	*token_symbol =
		new SttyTreeNode(this, Token, token_name, token_value, p_flag);

	children.push_back(token_symbol);

	token_count++;
}

void	SttyTreeNode::reduce(	const char *left_symbol_name,
								list<SttyTreeNode *> &rule_right)
{
	list<SttyTreeNode *>::iterator		stack_top_ptr;
	list<SttyTreeNode *>::iterator		reduce_ptr;
	list<SttyTreeNode *>::iterator		symbol_ptr;
	list<SttyTreeNode *>::iterator		reduction_symbol_ptr;
	list<SttyTreeNode *>::iterator		reduction_symbol_list_ptr;
	list<SttyTreeNode *>::iterator		rule_ptr;

	int		i;
	int		length;

	stack_top_ptr	= children.end();
	reduce_ptr		= stack_top_ptr;
	length			= rule_right.size();

	for (i=0; i<length; i++)
		reduce_ptr--;

	bool	internal_check = false;

	if (internal_check)
	{
		symbol_ptr	= reduce_ptr;
		rule_ptr	= rule_right.begin();

		for (i=0; i<length; i++)
			if (!(**symbol_ptr++ == **rule_ptr++))
				break;

		if (i < length)
		{
			reduce_ptr--;
			stack_top_ptr--;
		}
	}

	SttyTreeNode	*reduction_symbol =
						new SttyTreeNode(this, NonTerminal, left_symbol_name);

	reduction_symbol_ptr = children.insert(reduce_ptr, reduction_symbol);

	reduction_symbol_list_ptr = (*reduction_symbol_ptr)->children.begin();

	(*reduction_symbol_ptr)->children.splice(	reduction_symbol_list_ptr,
												children,
												reduce_ptr,
												stack_top_ptr);

	reduction_count++;
}

int		SttyTreeNode::reduce_rule(const char *left_symbol_name ...)
{
	int						count;
	list<SttyTreeNode *>	rule_right;

	va_list		char_ptr_arg_list;

	va_start(char_ptr_arg_list, left_symbol_name);

	while (true)
	{
		char	*char_ptr = va_arg(char_ptr_arg_list, char*);

		if (!char_ptr)
			break;
		else
			rule_right.push_back(new SttyTreeNode(char_ptr));
	}

	va_end(char_ptr_arg_list);

	reduce(left_symbol_name, rule_right);

	for_each(rule_right.begin(), rule_right.end(), destroy_T<SttyTreeNode *>());

	return 0;
}

void	SttyTreeNode::print()
{
	for_each(children.begin(), children.end(), print_node());
}

void	print_node::operator()(SttyTreeNode *node)
{
	int						i;
	int						j;
	int						k;
	list<int>::iterator		find_iterator;

	for (i=0; i<SttyTreeNode::tree_level-1; i++)
	{
		find_iterator = find(	SttyTreeNode::bar_position_list.begin(),
								SttyTreeNode::bar_position_list.end(),
								i);

		if (find_iterator != SttyTreeNode::bar_position_list.end())
			cout << "|";
		else
			cout << " ";

		for (j=0; j<SttyTreeNode::horizontal_spacing-1; j++)
			cout << " ";
	}

	if (SttyTreeNode::tree_level)
	{
		cout << "+";

		for (j=0; j<SttyTreeNode::horizontal_spacing-1; j++)
			cout << "-";
	}

	if (node->symbol_type == SttyTreeNode::Token)
	{
		if (node->print_value_only_flag)
			cout << node->value_text << endl;
		else
			cout << node->name_text << " = " << node->value_text << endl;
	}
	else
	{
		cout << node->name_text << endl;
	}

	for (k=0; k<SttyTreeNode::vertical_spacing; k++)
	{
		for (i=0; i<SttyTreeNode::tree_level; i++)
		{
			find_iterator = find(	SttyTreeNode::bar_position_list.begin(),
									SttyTreeNode::bar_position_list.end(),
									i);

			if (find_iterator != SttyTreeNode::bar_position_list.end())
				cout << "|";
			else
				cout << " ";

			for (j=0; j<SttyTreeNode::horizontal_spacing-1; j++)
				cout << " ";
		}

		if (node->children.begin() != node->children.end())
			cout << "|";

		cout << endl;
	}

	SttyTreeNode::bar_position_list.push_back(SttyTreeNode::tree_level);

	SttyTreeNode::tree_level++;

	for_each(node->children.begin(), --(node->children.end()), print_node());

	SttyTreeNode::bar_position_list.pop_back();

	for_each(--(node->children.end()), node->children.end(), print_node());

	SttyTreeNode::tree_level--;
}
