#include "calculate.h"

map<string, CExpressionValue>	CExpressionValue::symbol_value_map;
ostream							*CExpressionValue::output_stream;

CExpressionValue	CExpressionValue::Add(CExpressionValue a, CExpressionValue b)
{
	switch (a.type)
	{
		case CExpressionValue::integer:
		switch (b.type)
		{
			case CExpressionValue::integer:
			return CExpressionValue(
				static_cast<long>(a.value.i_value + b.value.i_value));

			case CExpressionValue::floating:
			return CExpressionValue(
				static_cast<double>(a.value.i_value + b.value.f_value));
		}

		case CExpressionValue::floating:
		switch (b.type)
		{
			case CExpressionValue::integer:
			return CExpressionValue(
				static_cast<double>(a.value.f_value + b.value.i_value));

			case CExpressionValue::floating:
			return CExpressionValue(
				static_cast<double>(a.value.f_value + b.value.f_value));
		}
	}
}

CExpressionValue	CExpressionValue::Subtract(CExpressionValue a, CExpressionValue b)
{
	switch (a.type)
	{
		case CExpressionValue::integer:
		switch (b.type)
		{
			case CExpressionValue::integer:
			return CExpressionValue(
				static_cast<long>(a.value.i_value - b.value.i_value));

			case CExpressionValue::floating:
			return CExpressionValue(
				static_cast<double>(a.value.i_value - b.value.f_value));
		}

		case CExpressionValue::floating:
		switch (b.type)
		{
			case CExpressionValue::integer:
			return CExpressionValue(
				static_cast<double>(a.value.f_value - b.value.i_value));

			case CExpressionValue::floating:
			return CExpressionValue(
				static_cast<double>(a.value.f_value - b.value.f_value));
		}
	}
}

CExpressionValue	CExpressionValue::Multiply(CExpressionValue a, CExpressionValue b)
{
	switch (a.type)
	{
		case CExpressionValue::integer:
		switch (b.type)
		{
			case CExpressionValue::integer:
			return CExpressionValue(
				static_cast<long>(a.value.i_value * b.value.i_value));

			case CExpressionValue::floating:
			return CExpressionValue(
				static_cast<double>(a.value.i_value * b.value.f_value));
		}

		case CExpressionValue::floating:
		switch (b.type)
		{
			case CExpressionValue::integer:
			return CExpressionValue(
				static_cast<double>(a.value.f_value * b.value.i_value));

			case CExpressionValue::floating:
			return CExpressionValue(
				static_cast<double>(a.value.f_value * b.value.f_value));
		}
	}
}

CExpressionValue	CExpressionValue::Divide(CExpressionValue a, CExpressionValue b)
{
	switch (a.type)
	{
		case CExpressionValue::integer:
		switch (b.type)
		{
			case CExpressionValue::integer:
			return CExpressionValue(
				static_cast<long>(a.value.i_value / b.value.i_value));

			case CExpressionValue::floating:
			return CExpressionValue(
				static_cast<double>(a.value.i_value / b.value.f_value));
		}

		case CExpressionValue::floating:
		switch (b.type)
		{
			case CExpressionValue::integer:
			return CExpressionValue(
				static_cast<double>(a.value.f_value / b.value.i_value));

			case CExpressionValue::floating:
			return CExpressionValue(
				static_cast<double>(a.value.f_value / b.value.f_value));
		}
	}
}

bool	CExpressionValue::AddSymbolValue(const string &s, const CExpressionValue &ev)
{
	map<string, CExpressionValue>::const_iterator	i = symbol_value_map.find(s);

	if (i == symbol_value_map.end())
	{
		symbol_value_map.insert(pair<string, CExpressionValue>(s, ev));
		return true;
	}
	else
		return false;
}

bool	CExpressionValue::SetSymbolValue(const string &s, const CExpressionValue &ev)
{
	map<string, CExpressionValue>::iterator		i = symbol_value_map.find(s);

	if (i != symbol_value_map.end())
	{
		CExpressionValue	&symbol = (*i).second;

		switch (symbol.type)
		{
			case CExpressionValue::integer:
			switch (ev.type)
			{
				case CExpressionValue::integer:
				symbol.value.i_value = ev.value.i_value;

				case CExpressionValue::floating:
				symbol.value.i_value = ev.value.f_value;
			}

			case CExpressionValue::floating:
			switch (ev.type)
			{
				case CExpressionValue::integer:
				symbol.value.f_value = ev.value.i_value;

				case CExpressionValue::floating:
				symbol.value.f_value = ev.value.f_value;
			}
		}

		return true;
	}
	else
		return false;
}

bool	CExpressionValue::GetSymbolValue(const string &s, CExpressionValue &ev)
{
	map<string, CExpressionValue>::const_iterator	i = symbol_value_map.find(s);

	if (i != symbol_value_map.end())
	{
		ev = (*i).second;
		return true;
	}
	else
		return false;
}

bool	CExpressionValue::FindSymbol(const string &s)
{
	map<string, CExpressionValue>::const_iterator	i = symbol_value_map.find(s);

	if (i != symbol_value_map.end())
		return true;
	else
		return false;
}

ostream &operator<<(ostream &os, const CExpressionValue &ev)
{
	switch (ev.type)
	{
		case CExpressionValue::integer:
		os << ev.value.i_value; break;

		case CExpressionValue::floating:
		os << ev.value.f_value; break;
	}

	return os;
}

CExpressionValue	CUnaryExpression::EvaluateExpression()
{
	if (HasIdentifier())
		CExpressionValue::GetSymbolValue(identifier, value);

	ostream		&os = *CExpressionValue::output_stream;

	if (identifier.size())
		os << "(" << identifier << " = " << value << ")";
	else
		os << value;

	return value;
}

CExpressionValue	CBinaryExpression::EvaluateExpression()
{
	ostream		&os = *CExpressionValue::output_stream;

	os << "(";

	CExpressionValue	a = sub_expression_a->EvaluateExpression();

	switch (operation_type)
	{
		case CExpressionValue::add:
		os << " + "; break;

		case CExpressionValue::subtract:
		os << " - "; break;

		case CExpressionValue::multiply:
		os << " * "; break;

		case CExpressionValue::divide:
		os << " / "; break;
	}

	CExpressionValue	b = sub_expression_b->EvaluateExpression();

	os << ")";

	switch (operation_type)
	{
		case CExpressionValue::add:
		value = CExpressionValue::Add(a, b); break;

		case CExpressionValue::subtract:
		value = CExpressionValue::Subtract(a, b); break;

		case CExpressionValue::multiply:
		value = CExpressionValue::Multiply(a, b); break;

		case CExpressionValue::divide:
		value = CExpressionValue::Divide(a, b); break;
	}

	return value;
}

list<CAssignmentExpression *>	CAssignmentExpression::assignment_list;

void	CAssignmentExpression::EvaluateAssignment()
{
	ostream		&os = *CExpressionValue::output_stream;

	os << identifier << " = ";
	
	CExpressionValue	a = expression->EvaluateExpression();
	
	os << endl << string(identifier.size(), ' ') << " = " << a << endl;

	CExpressionValue::SetSymbolValue(identifier, a);
}

void	CAssignmentExpression::evaluate_assignments::operator()(CAssignmentExpression *a)
{
	a->EvaluateAssignment();
}

void	CAssignmentExpression::destroy_assignments::operator()(CAssignmentExpression *a)
{
	delete a;
}

void	CAssignmentExpression::EvaluateAssignments()
{
	for_each(	assignment_list.begin(),
				assignment_list.end(),
				evaluate_assignments());
}

void	CAssignmentExpression::DestroyAssignments()
{
	for_each(	assignment_list.begin(),
				assignment_list.end(),
				destroy_assignments());
}
