/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "escapeParserDriver.h"


CEscapeParserDriver::CEscapeParserDriver()
    : CParserDriver(
        Escape_Terminal_Count_E,
        Escape_Symbol_Count_A,
        Escape_Rule_Count_A,
        Escape_Parser_Empty_Symbol_Token,
        Escape_Shift_Action,
        Escape_Accept_Action,
        Escape_Conflict_Entry,
        Escape_State_Count,
        Escape_Number_Of_Conflict_Entries,
        Escape_Number_Of_Error_Indexes,
        Escape_Action_Table,
        Escape_Goto_Table,
        Escape_Rule_Left_Symbol_Table,
        Escape_Rule_Right_Length_Table)
{
    reduce_functions =
    new (int (CEscapeParserDriver::*[Escape_Rule_Count_A - 1])(void *));

    error_functions =
    new (void (CEscapeParserDriver::*[Escape_Number_Of_Error_Indexes + 1])());

    SetupFunctionTables();

}

CEscapeParserDriver::~CEscapeParserDriver()
{
    delete [] reduce_functions;
    delete [] error_functions;

}

int     CEscapeParserDriver::CallReduceFunction(int action, void *data)
{
    return (this->*reduce_functions[action])(data);
}

void    CEscapeParserDriver::CallConflictFunction(int index)
{
    (this->*conflict_functions[index])();
}

void    CEscapeParserDriver::CallErrorFunction(int index)
{
    (this->*error_functions[index])();
}

void    CEscapeParserDriver::DeleteGeneratedCode(CStackElement *s, int c)
{
    for (int i=c-1; i>=0; i--)
    {
        CStackElement   &se = s[i];

        if (se.type == StackCharArray)
            delete [] se.char_array;
        else if (se.type == StackData)
            (this->*reduce_functions[se.reduce_action])(se.data);
    }
}

//  rule reduce function definitions for CEscapeParserDriver

//  00    start      ->  esc_seq
//
int     CEscapeParserDriver::Reduce_00(void *data)
{
	int		escape_int = STACK_INT(0);

	STACK_TYPE(0)					= STACK_TYPE_SCALAR;
	STACK_RANGE_INT_LOWER_BOUND(0)	= escape_int;
	STACK_RANGE_INT_UPPER_BOUND(0)	= escape_int;

	return 0;
}

//  01    start      ->  esc_seq  ;  esc_seq
//
int     CEscapeParserDriver::Reduce_01(void *data)
{
	int		escape0_int = STACK_INT(0);
	int		escape2_int = STACK_INT(2);

	STACK_TYPE(0) = STACK_TYPE_SCALAR;

	if (escape0_int < escape2_int)
	{
		STACK_RANGE_INT_LOWER_BOUND(0)	= escape0_int;
		STACK_RANGE_INT_UPPER_BOUND(0)	= escape2_int;
	}
	else
	{
		STACK_RANGE_INT_LOWER_BOUND(0)	= escape2_int;
		STACK_RANGE_INT_UPPER_BOUND(0)	= escape0_int;
	}

	return 0;
}

//  02    esc_seq    ->  \  digit_seq
//
int     CEscapeParserDriver::Reduce_02(void *data)
{
	VListUChar	*digit_list = (VListUChar *)STACK_DATA(1);

	int		length = digit_list->Size();

	unsigned char	digit_char[length + 1];

	int				index	= 0;
	VListUCharPtr	listptr	= digit_list->FirstListPtr();

	while (listptr)
		digit_char[index++] = digit_list->NextData(listptr);

	digit_char[index] = '\0';

	delete digit_list;

	STACK_TYPE(0)	= STACK_TYPE_SCALAR;
	if (digit_char[0] == '0')
		STACK_INT(0)	= strtol((const char *)digit_char, 0, 8);
	else
		STACK_INT(0)	= strtol((const char *)digit_char, 0, 10);

	return 0;
}

//  03    esc_seq    ->  \  x  hex_seq
//
int     CEscapeParserDriver::Reduce_03(void *data)
{
	VListUChar	*digit_list = (VListUChar *)STACK_DATA(2);

	int		length = digit_list->Size();

	unsigned char	hexdigit_char[length + 1];

	int				index	= 0;
	VListUCharPtr	listptr	= digit_list->FirstListPtr();

	while (listptr)
		hexdigit_char[index++] = digit_list->NextData(listptr);

	hexdigit_char[index] = '\0';

	delete digit_list;

	STACK_TYPE(0)	= STACK_TYPE_SCALAR;
	STACK_INT(0)	= strtol((const char *)hexdigit_char, 0, 16);

	return 0;
}

//  04    esc_seq    ->  \  X  hex_seq
//
int     CEscapeParserDriver::Reduce_04(void *data)
{
	VListUChar	*digit_list = (VListUChar *)STACK_DATA(2);

	int		length = digit_list->Size();

	unsigned char	hexdigit_char[length + 1];

	int				index	= 0;
	VListUCharPtr	listptr	= digit_list->FirstListPtr();

	while (listptr)
		hexdigit_char[index++] = digit_list->NextData(listptr);

	hexdigit_char[index] = '\0';

	delete digit_list;

	STACK_TYPE(0)	= STACK_TYPE_SCALAR;
	STACK_INT(0)	= strtol((const char *)hexdigit_char, 0, 16);

	return 0;
}

//  05    digit_seq  ->  digit
//
int     CEscapeParserDriver::Reduce_05(void *data)
{
	if (!data)
	{
		VListUChar	*digit_list = new VListUChar(10);

		digit_list->PushBack(STACK_UNSIGNED_CHAR(0));

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = digit_list;
	}
	else
		delete (VListUChar *)data;

	return 0;
}

//  06    digit_seq  ->  digit_seq  digit
//
int     CEscapeParserDriver::Reduce_06(void *data)
{
	if (!data)
	{
		((VListUChar *)STACK_DATA(0))->PushBack(STACK_UNSIGNED_CHAR(1));
	}
	else
		delete (VListUChar *)data;

	return 0;
}

//  07    hex_seq    ->  digit
//
int     CEscapeParserDriver::Reduce_07(void *data)
{
	if (!data)
	{
		VListUChar	*digit_list = new VListUChar(10);

		digit_list->PushBack(STACK_UNSIGNED_CHAR(0));

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = digit_list;
	}
	else
		delete (VListUChar *)data;

	return 0;
}

//  08    hex_seq    ->  hexdigit
//
int     CEscapeParserDriver::Reduce_08(void *data)
{
	if (!data)
	{
		VListUChar	*digit_list = new VListUChar(10);

		digit_list->PushBack(STACK_UNSIGNED_CHAR(0));

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = digit_list;
	}
	else
		delete (VListUChar *)data;

	return 0;
}

//  09    hex_seq    ->  hex_seq  digit
//
int     CEscapeParserDriver::Reduce_09(void *data)
{
	if (!data)
	{
		((VListUChar *)STACK_DATA(0))->PushBack(STACK_UNSIGNED_CHAR(1));
	}
	else
		delete (VListUChar *)data;

	return 0;
}

//  10    hex_seq    ->  hex_seq  hexdigit
//
int     CEscapeParserDriver::Reduce_10(void *data)
{
	if (!data)
	{
		((VListUChar *)STACK_DATA(0))->PushBack(STACK_UNSIGNED_CHAR(1));
	}
	else
		delete (VListUChar *)data;

	return 0;
}

//  conflict function definitions for CEscapeParserDriver

//  error function definitions for CEscapeParserDriver

// inaccessible error
//
void    CEscapeParserDriver::Error_1()
{
}

// accessible error
//
void    CEscapeParserDriver::Error_2()
{
}

void    CEscapeParserDriver::SetupFunctionTables()
{
    reduce_functions[ 0] = &CEscapeParserDriver::Reduce_00;
    reduce_functions[ 1] = &CEscapeParserDriver::Reduce_01;
    reduce_functions[ 2] = &CEscapeParserDriver::Reduce_02;
    reduce_functions[ 3] = &CEscapeParserDriver::Reduce_03;
    reduce_functions[ 4] = &CEscapeParserDriver::Reduce_04;
    reduce_functions[ 5] = &CEscapeParserDriver::Reduce_05;
    reduce_functions[ 6] = &CEscapeParserDriver::Reduce_06;
    reduce_functions[ 7] = &CEscapeParserDriver::Reduce_07;
    reduce_functions[ 8] = &CEscapeParserDriver::Reduce_08;
    reduce_functions[ 9] = &CEscapeParserDriver::Reduce_09;
    reduce_functions[10] = &CEscapeParserDriver::Reduce_10;


    error_functions[1] = &CEscapeParserDriver::Error_1;
    error_functions[2] = &CEscapeParserDriver::Error_2;
}
