/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "filePath.h"

bool	FilePath::FileExists(const string &f)
{
	ifstream	in_file(f.c_str());

	return in_file.good();
}

bool	FilePath::GetCurrentWorkingDirectory(string &cwd)
{
	int		count			= 0;
	size_t	buffer_size		= 200;
	char	*path_buffer	= new char[buffer_size];

	while (true)
	{
		errno		= 0;
		char	*r	= getcwd(path_buffer, buffer_size);

		if (!r)
		{
			if (++count > 5 || errno != ERANGE)
			{
				cwd = "";
				delete [] path_buffer;
				return false;
			}
			else
			{
				delete [] path_buffer;
				buffer_size *= 2;
				path_buffer = new char[buffer_size];
			}
		}
		else
			break;
	}

	cwd = path_buffer;
	delete [] path_buffer;
	return true;
}

void	FilePath::GetPathAndFileName(	const string &path_and_file_name,
										string &path,
										string &file_name)
{
	string::size_type	index;

	if ((index = path_and_file_name.find_last_of('/')) != string::npos)
		if (index + 1 < path_and_file_name.length())
		{
			if (index)
				path = string(path_and_file_name, 0, index);
			else
				path = "";

			file_name = string(path_and_file_name, index + 1);
		}
		else
		{
			path		= string(path_and_file_name, 0, index);
			file_name	= "";
		}
	else
	{
		path		= ".";
		file_name	= path_and_file_name;
	}
}

bool	FilePath::CheckFileExtension(	const string &path_and_file_name,
										const string &extension)
{
	string	path;
	string	file_name;

	GetPathAndFileName(path_and_file_name, path, file_name);

	int		f_length = file_name.length();
	int		e_length = extension.length();

	if (e_length < f_length &&
		file_name.rfind(extension) == f_length - e_length)
		return true;
	else
		return false;
}

void	FilePath::GetFileBaseName(	const string &path_and_file_name,
									const string &extension,
									string &base_name)
{
	string	path;
	string	file_name;

	GetPathAndFileName(path_and_file_name, path, file_name);

	int		f_length = file_name.length();
	int		e_length = extension.length();

	if (e_length < f_length &&
		file_name.rfind(extension) == f_length - e_length)
		base_name = string(file_name, 0, f_length - e_length);
	else
		base_name = file_name;
}

void	FilePath::CreateAssociatedFileName(
										const string &path_and_file_name,
										const string &extension1,
										const string &extension2,
										string &associated_file_name)
{
	string	base_name;

	GetFileBaseName(path_and_file_name, extension1, base_name);

	associated_file_name = base_name + extension2;
}
