/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef UNIONSCALAR_H
#define UNIONSCALAR_H

#include <string.h>

union UScalar
{
	bool			scalar_bool;
	char			scalar_char;
	unsigned char	scalar_unsigned_char;
	short			scalar_short;
	unsigned short	scalar_unsigned_short;
	int				scalar_int;
	unsigned int	scalar_unsigned_int;
	long			scalar_long;
	unsigned long	scalar_unsigned_long;
	float			scalar_float;
	double			scalar_double;
	long double		scalar_long_double;

	struct
	{
		char			lower_bound;
		char			upper_bound;
	} range_char;

	struct
	{
		unsigned char	lower_bound;
		unsigned char	upper_bound;
	} range_unsigned_char;

	struct
	{
		short			lower_bound;
		short			upper_bound;
	} range_short;

	struct
	{
		unsigned short	lower_bound;
		unsigned short	upper_bound;
	} range_unsigned_short;

	struct
	{
		int				lower_bound;
		int				upper_bound;
	} range_int;

	struct
	{
		unsigned int	lower_bound;
		unsigned int	upper_bound;
	} range_unsigned_int;

	struct
	{
		long			lower_bound;
		long			upper_bound;
	} range_long;

	struct
	{
		unsigned long	lower_bound;
		unsigned long	upper_bound;
	} range_unsigned_long;

	struct
	{
		float			lower_bound;
		float			upper_bound;
	} range_float;

	struct
	{
		double			lower_bound;
		double			upper_bound;
	} range_double;

	struct
	{
		long double		lower_bound;
		long double		upper_bound;
	} range_long_double;

	UScalar		&operator=(const UScalar &s)
	{
		if (this != &s)
			memcpy((void *)this, (const void *)&s, sizeof(UScalar));

		return *this;
	}
};

#endif
