/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef CLASSCODEVIEW_H
#define	CLASSCODEVIEW_H

class CClassCodeControl;
class CClassCodeVBoxWidget;
class CClassCodeView;

#include <string>
#include <list>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerData.h"
#include "compilerInterface.h"

class CClassCodeControl: public CFrameFc
{
	Q_OBJECT
	public:
	CClassCodeControl(CClassCodeVBoxWidget *v);
	~CClassCodeControl() { }

	void	ResetControl(const list<string> &s, int section);

	public slots:
	void	SelectCodeSection(int section);

	private:
	CClassCodeVBoxWidget	*class_code_vbox;
	CLabelFc				*view_label;
	CLabelFc				*code_section_label;
	CComboBoxFc				*code_section_combo_box;
	CSpacerFc				*spacer;
};

class CClassCodeVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CClassCodeVBoxWidget(	QWidget *parent,
							CCompilerInterface *ci,
							SMainViewControl *mvc,
							COptionData::SSubViewData *d,
							CClassCodeView *ccv);

	virtual ~CClassCodeVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializeModulePointers();

	void	UpdateView();
	void	UpdateMultiLineEdit();
	void	SetMultiLineEditText(const list<string> &code);
	void	GetMultiLineEditText(list<string> &code);
	void	SetTabStopWidth(int count);
	void	SelectCodeSection(int section);
	void	FindString();
	void	UndoEdit();
	void	RedoEdit();
	void	ClearCodeSection();
	void	PostCurrentCodeChanges();
	void	RestoreUndoData();

	public slots:
	void	CodeTextChanged();

	private:
	int							class_code_section;
	CClassCodeControl			*class_code_control;
	CMultiLineEditFc			*multi_line_edit;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CClassCodeView				*class_code_view;
	ModulePtrMap				&module_ptr_map;
};

class CClassCodeView: public CSubView
{
	public:
	CClassCodeView(	QWidget *p,
					CViewNode *n,
					CInterfaceControl *ic,
					SMainViewControl *mvc,
					const string &dfs,
					CPaletteData *dpd,
					COptionData::SSubViewData *d);

	virtual ~CClassCodeView();

	virtual CClassCodeVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	UpdateView();
	void	SetTabStopWidth(int count);
	void	FindString();
	void	UndoEdit();
	void	RedoEdit();
	void	ClearCodeSection();
	void	PostCurrentCodeChanges();
	void	RestoreUndoData();

	private:
	CClassCodeVBoxWidget		*frame;
};

#endif
