/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "connectionView.h"

CConnectionFrameWidget::CConnectionFrameWidget(	QWidget *parent,
												CDefaultInterface *di,
												SMainViewControl *mvc,
												COptionData::SSubViewData *d,
												CConnectionView *cv)
	: CFrameWidget(parent, di, mvc), default_interface(di),
		subview_data(d), connection_view(cv),
		module_ptr_map(cv->GetModulePtrMap())
{
	QFontInfo		fi(font());

	int		pixel_size = fi.pixelSize();

	int		m = grid_layout_margin_data[pixel_size];
	int		s = grid_layout_spacing_data[pixel_size];

	grid_layout = new QGridLayout(this, 4, 2, m, s);

	grid_layout->setRowStretch(0, 0);
	grid_layout->setRowStretch(1, 0);
	grid_layout->setRowStretch(2, 0);
	grid_layout->setRowStretch(3, 1);

	ostrstream		text_stream;
	vector<int>		*v = d->GetIndex();

	CDefaultData::CreateIndexText(text_stream, *v);

	text_stream << '\0';

	index_text = text_stream.str();

	label = new CLabelFc(index_text.c_str(), this, true);

	label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	label->setFrameStyle(QFrame::Panel | QFrame::Raised);

	line_edit = new CLineEditFc(this, "data entry");

	CDefaultData	*dd = default_interface->GetDefaultData();

	default_text = dd->GetData(	mvc->view_data->GetMainViewName(),
								*d->GetIndex());

	if (!default_text.length())
		default_text = "CONNECTION_VIEW";

	line_edit->setText(default_text.c_str());

	send_all		= new CPushButtonFc("Send All", this);
	send_selected	= new CPushButtonFc("Send Selected", this);
	connection_list	= new Q3ListView(this);

	connection_list->addColumn("Main View");
	connection_list->addColumn("Subview Type");
	connection_list->addColumn("Index");
	connection_list->setSorting(-1);
	connection_list->setRootIsDecorated(false);
	connection_list->setSelectionMode(Q3ListView::Extended);

	grid_layout->addMultiCellWidget(label, 0, 0, 0, 1);
	grid_layout->addMultiCellWidget(line_edit, 1, 1, 0, 1);
	grid_layout->addWidget(send_all, 2, 0);
	grid_layout->addWidget(send_selected, 2, 1);
	grid_layout->addMultiCellWidget(connection_list, 3, 3, 0, 1);

	connect(connection_list,
			SIGNAL(selectionChanged()),
			SLOT(SelectionChanged()));

	connect(send_all,
			SIGNAL(clicked()),
			SLOT(SendAll()));

	connect(send_selected,
			SIGNAL(clicked()),
			SLOT(SendSelected()));
}

CConnectionFrameWidget::~CConnectionFrameWidget()
{
}

void	CConnectionFrameWidget::SetLineEditText(const QString &s)
{
	default_text = (const char *)(s.local8Bit());

	CDefaultData	*dd = default_interface->GetDefaultData();

	dd->SetData(GetMainViewControl()->GetViewData()->GetMainViewName(),
				*subview_data->GetIndex(),
				default_text);

	default_interface->SetDataModifiedFlag(true);

	line_edit->setText(default_text.c_str());
}

void	CConnectionFrameWidget::InitializeModulePointers()
{
	vector<CSubView *>		&v1 = module_ptr_map["DEFAULT_VIEW"];
	vector<CSubView *>		&v2 = module_ptr_map["CONNECTION_VIEW"];

	vector<CSubView *>::size_type	i;

	for (i=0; i<v1.size(); i++)
	{
		CDefaultView	*dv =
			dynamic_cast<CDefaultView *>(v1[v1.size() - 1 - i]);

		if (dv)
		{
			default_views.push_back(dv);

			ostrstream		text_stream;
			vector<int>		*v = dv->GetWidget()->GetSubviewData()->GetIndex();

			CDefaultData::CreateIndexText(text_stream, *v, false);

			text_stream << '\0';

			new SDefaultViewItem(	connection_list,
									dv->GetWidget()->GetMainViewControl()
									->GetViewData()->GetMainViewName().c_str(),
									"DEFAULT_VIEW",
									text_stream.str(),
									dv);
		}
	}

	for (i=0; i<v2.size(); i++)
	{
		CConnectionView		*cv =
			dynamic_cast<CConnectionView *>(v2[v2.size() - 1 - i]);

		if (cv)
		{
			connection_views.push_back(cv);

			ostrstream		text_stream;
			vector<int>		*v = cv->GetWidget()->GetSubviewData()->GetIndex();

			CDefaultData::CreateIndexText(text_stream, *v, false);

			text_stream << '\0';

			new SConnectionViewItem(connection_list,
									cv->GetWidget()->GetMainViewControl()
									->GetViewData()->GetMainViewName().c_str(),
									"CONNECTION_VIEW",
									text_stream.str(),
									cv);
		}
	}
}

void	CConnectionFrameWidget::SelectionChanged()
{
	default_interface->SetModulePointer(connection_view,
										"CONNECTION_VIEW");
}

void	CConnectionFrameWidget::SendAll()
{
	default_interface->SetModulePointer(connection_view,
										"CONNECTION_VIEW");

	QString		s(line_edit->text());

	vector<CDefaultView *>::size_type		i;
	vector<CConnectionView *>::size_type	j;

	for (i=0; i<default_views.size(); i++)
		default_views[i]->SetLabelText(s);

	for (j=0; j<connection_views.size(); j++)
		connection_views[j]->SetLineEditText(s);
}

void	CConnectionFrameWidget::SendSelected()
{
	default_interface->SetModulePointer(connection_view,
										"CONNECTION_VIEW");

	QString			s(line_edit->text());
	Q3ListViewItem	*list_view_item = connection_list->firstChild();

	while (list_view_item)
	{
		if (list_view_item->isSelected())
		{
			SSubViewItem	*svi =
				dynamic_cast<SSubViewItem *>(list_view_item);

			if (svi)
				svi->SendText(s);
		}

		list_view_item = list_view_item->itemBelow();
	}
}

CConnectionView::CConnectionView(	QWidget *p,
									CViewNode *n,
									CInterfaceControl *ic,
									SMainViewControl *mvc,
									const string &dfs,
									CPaletteData *dpd,
									COptionData::SSubViewData *d)
	: CSubView(p, n, ic, mvc, dfs, dpd, d)
{
	frame = new CConnectionFrameWidget(
		p, dynamic_cast<CDefaultInterface *>(ic), mvc, d, this);

	QFont		view_node_font;
	QPalette	view_node_palette;

	if (SetupViewNodeFont(view_node_font))
		frame->setFont(view_node_font);
	else
		frame->setFont(frame->font());

	if (SetupViewNodePalette(view_node_palette))
		frame->setPalette(view_node_palette);
	else
		frame->setPalette(frame->palette());
}

CConnectionView::~CConnectionView()
{
	delete frame;
}

void	CConnectionView::SetHighlightPalette(CPaletteData *pd)
{
	restore_palette = frame->palette();

	QPalette	highlight_palette;

	pd->SetupPalette(highlight_palette);

	frame->setPalette(highlight_palette);
}

void	CConnectionView::RestorePalette()
{
	frame->setPalette(restore_palette);
}

void	CConnectionView::SetLineEditText(const QString &s)
{
	frame->SetLineEditText(s);
}

void	CConnectionView::InitializeModulePointers()
{
	frame->InitializeModulePointers();
}

void	CConnectionView::SendAll()
{
	frame->SendAll();
}

void	CConnectionView::SendSelected()
{
	frame->SendSelected();
}

void	SDefaultViewItem::SendText(const QString &s)
{
	default_view->SetLabelText(s);
}

void	SConnectionViewItem::SendText(const QString &s)
{
	connection_view->SetLineEditText(s);
}
