/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "defaultInterface.h"

int		CDefaultInterface::default_submenu_id;

const	CDefaultInterface::SDefaultSubmenuNodeData
		CDefaultInterface::default_submenu_node_data[] =
{
	{	MN::mn_popup, ""		, 0		, "&Default",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0"		, 0		, "Send All",
		0								, SLOT(SendAll()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1"		, 1		, "Send Selected",
		0								, SLOT(SendSelected()),
		MN::mn_enable			, MN::mn_disable	},

	{   MN::menu_node_type_end, 0, 0, 0, 0, 0, 0, 0 }
};

const char * const	CDefaultInterface::default_default_option_data[] =
{
	"APPLICATION",
	"POSITION 0, 0",
	"SIZE 1016, 693",
	"HELP",
	"MAIN_VIEW Main1",
	"SUBVIEW DEFAULT_VIEW",
	"INDEX",
	0
};

CDefaultData					*CDefaultInterface::default_data_load;
vector< pair<string, int> >		CDefaultInterface::subview_types;
map< string, set<string> >		CDefaultInterface::subview_connection_map;

void	CDefaultInterface::SetupSubviewTypeData()
{
	subview_types.clear();

	subview_types.push_back(pair<string, int>("UNDEFINED_VIEW"		,-1));
	subview_types.push_back(pair<string, int>("DEFAULT_VIEW"		,-1));
	subview_types.push_back(pair<string, int>("CONNECTION_VIEW"		,-1));

	set<string>		connection_types;

	connection_types.insert("DEFAULT_VIEW");
	connection_types.insert("CONNECTION_VIEW");

	subview_connection_map.clear();

	subview_connection_map["CONNECTION_VIEW"] = connection_types;
}

void	CDefaultInterface::SetupConfiguration(
								vector<SInterfaceConfiguration> &c,
								CIdGenerator &submenu_id_generator)
{
	vector< pair<int, SSubmenuNodeData *> >		submenu_node_data;

	SetupSubmenuNodeData(submenu_node_data, submenu_id_generator);

	QDesktopWidget	*dw = QApplication::desktop();

	int		w = dw->width();
	int		h = dw->height();

	const char * const	*default_option_data;

	if (w == 1024 && h == 768)
		default_option_data = default_default_option_data;
	else if (w == 1152 && h == 864)
		default_option_data = default_default_option_data;
	else if (w == 1280 && h == 1024)
		default_option_data = default_default_option_data;
	else if (w == 1400 && h == 1050)
		default_option_data = default_default_option_data;
	else if (w == 1600 && h == 1200)
		default_option_data = default_default_option_data;
	else if (w == 1800 && h == 1440)
		default_option_data = default_default_option_data;
	else if (w == 1920 && h == 1440)
		default_option_data = default_default_option_data;
	else
		default_option_data = default_default_option_data;

	c.push_back(SInterfaceConfiguration(".default",
										".option",
										"default.option",
										default_option_data,
										&subview_types,
										&subview_connection_map,
										submenu_node_data,
										SetupSubviewTypeData,
										CreateInterfaceControl,
										CreateNewData,
										LoadData,
										LoadDataError));
}

int		CDefaultInterface::GetSubmenuNodeCount(const SDefaultSubmenuNodeData *d)
{
	int		index = 0;
	while (d[index].node_type != MN::menu_node_type_end)
		index++;

	return index;
}

void	CDefaultInterface::SetupSubmenuNodeData(
								vector< pair<int, SSubmenuNodeData *> > &d,
								CIdGenerator &submenu_id_generator)
{
	default_submenu_id = submenu_id_generator.GetId();

	int		node_count = GetSubmenuNodeCount(default_submenu_node_data) + 1;
	int		i;

	SSubmenuNodeData	*snd = new SSubmenuNodeData[node_count];

	for (i=0; i<node_count; i++)
	{
		snd[i] = SSubmenuNodeData(
					default_submenu_node_data[i].node_type,
					default_submenu_node_data[i].tree_index,
					default_submenu_node_data[i].node_identifier,
					default_submenu_node_data[i].text,
					default_submenu_node_data[i].accelerator,
					default_submenu_node_data[i].slot,
					default_submenu_node_data[i].operation_list,
					SDefaultSubmenuNodeData::default_submenu_operation_count);
	}

	d.push_back(pair<int, SSubmenuNodeData *>(default_submenu_id, snd));
}

void    CDefaultInterface::SendAll()
{
	if (connection_view)
		connection_view->SendAll();
}

void    CDefaultInterface::SendSelected()
{
	if (connection_view)
		connection_view->SendSelected();
}

CDefaultInterface::CDefaultInterface(	int c_id,
										int i_id,
										CMainViewMenu *mvm,
										CMainWindow *mw)
	: CInterfaceControl(c_id, i_id, mvm, mw), default_data(0)
{
}

CDefaultInterface::~CDefaultInterface()
{
	delete default_data;
}

CInterfaceControl		*CDefaultInterface::CreateInterfaceControl(
					int c_id, int i_id, CMainViewMenu *mvm, CMainWindow *mw)
{
	return new CDefaultInterface(c_id, i_id, mvm, mw);
}

void	CDefaultInterface::CreateNewData()
{
	default_data_load = new CDefaultData();
}

bool	CDefaultInterface::LoadData(ifstream &f)
{
	CreateNewData();

	f >> *default_data_load;

	return true;
}

void	CDefaultInterface::LoadDataError()
{
}

void	CDefaultInterface::PostApplicationData()
{
}

void	CDefaultInterface::SetApplicationData()
{
	SetDefaultData(default_data_load);
}

bool	CDefaultInterface::SaveData(ofstream &f)
{
	f << *GetDefaultData();

	SetDataModifiedFlag(false);

	return true;
}

void	CDefaultInterface::EnableInterfaceMenu()
{
	main_window->ModifyMenu(
					default_submenu_id,
					SDefaultSubmenuNodeData::default_submenu_interface_enable,
					this);
}

void	CDefaultInterface::DisableInterfaceMenu()
{
	main_window->ModifyMenu(
					default_submenu_id,
					SDefaultSubmenuNodeData::default_submenu_interface_disable,
					this);
}

void	CDefaultInterface::InitializeModulePointers()
{
	CSubView	*sv;

	sv = FindSubviewTypePointer("DEFAULT_VIEW");

	if (sv)
		default_view = dynamic_cast<CDefaultView *>(sv);
	else
		default_view = 0;

	sv = FindSubviewTypePointer("CONNECTION_VIEW");

	if (sv)
		connection_view = dynamic_cast<CConnectionView *>(sv);
	else
		connection_view = 0;
}

void	CDefaultInterface::SetModulePointer(CSubView *sv, const string &type)
{
	if (type == "DEFAULT_VIEW")
		default_view = dynamic_cast<CDefaultView *>(sv);
	else if (type == "CONNECTION_VIEW")
		connection_view = dynamic_cast<CConnectionView *>(sv);
}

CSubView	*CDefaultInterface::CreateSubView(
				QWidget *p,
				CViewNode *n,
				CInterfaceControl *ic,
				SMainViewControl *mvc,
				const string &dfs,
				CPaletteData *dpd,
				COptionData::SSubViewData *d)
{
	if (d->GetSubViewName() == "DEFAULT_VIEW")
		return new CDefaultView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "CONNECTION_VIEW")
		return new CConnectionView(p, n, ic, mvc, dfs, dpd, d);
	else
		return new CUndefinedView(p, n, ic, mvc, dfs, dpd, d);
}

void		CDefaultData::SetData(	const string &name,
									const string &index,
									const string &data)
{
	StringToken::TokenStatus						token_status;
	vector<StringToken::CTokenValue *>				token_vector;
	vector<StringToken::CTokenValue *>::size_type	i;

	token_status = StringToken::GetIntegerTokenSequence(
						index, string(", "), token_vector);

	vector<int>		index_vector;

	for (i=0; i<token_vector.size(); i++)
		index_vector.push_back(token_vector[i]->GetIntegerValue());

	StringToken::DeleteTokenVectorElements(token_vector);

	data_map[pair<string, vector<int> >(name, index_vector)] = data;
}

string		&CDefaultData::GetData(const string &name, const string &index)
{
	StringToken::TokenStatus						token_status;
	vector<StringToken::CTokenValue *>				token_vector;
	vector<StringToken::CTokenValue *>::size_type	i;

	token_status = StringToken::GetIntegerTokenSequence(
						index, string(", "), token_vector);

	vector<int>		index_vector;

	for (i=0; i<token_vector.size(); i++)
		index_vector.push_back(token_vector[i]->GetIntegerValue());

	StringToken::DeleteTokenVectorElements(token_vector);

	return data_map[pair<string, vector<int> >(name, index_vector)];
}

void	CDefaultData::CreateIndexText(	ostrstream &s,
										const vector<int> &index,
										bool f)
{
	if (f)
		s << "Index = (";

	if (index.size())
	{
		vector<int>::size_type	i;

		for(i=0; i<index.size()-1; i++)
			s << index[i] << ", ";

		s << index[index.size()-1];
	}

	if (f)
		s << ")";
}

istream		&operator>>(istream &s, CDefaultData &dd)
{
	string	name;
	string	index;
	string	data;

	while (getline(s, name))
	{
		if (!getline(s, index))
			break;

		if (!getline(s, data))
			break;

		dd.SetData(name, index, data);
	}

	return s;
}

ostream		&operator<<(ostream &s, const CDefaultData &dd)
{
	for_each(	dd.GetDataMap().begin(),
				dd.GetDataMap().end(),
				output_default_data_map(s));

	return s;
}
