/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "fontchangeControl.h"

CPushButtonFc::CPushButtonFc(	const QString &text,
								QWidget *parent,
								const QString &s)
	: QPushButton(text, parent), size_string(s)
{
}

void	CPushButtonFc::setFont(const QFont &f)
{
	QPushButton::setFont(f);

	CalculateGeometry();
}

void	CPushButtonFc::CalculateGeometry()
{
	QFontInfo		fi(font());
	QFontMetrics	fm(font());

	int		pixel_size	= fi.pixelSize();
	int		text_height	= fm.height();
	int		text_width;

	if (size_string.length())
		text_width	= fm.width(size_string);
	else
		text_width	= fm.width(text());

	int		w = text_width + push_button_width_data[pixel_size] * 2;
	int		h = text_height + push_button_height_data[pixel_size] * 2;

	setMinimumSize(w, h);

	updateGeometry();
}

CCheckBoxFc::CCheckBoxFc(const QString &text, QWidget *parent)
	: QCheckBox(text, parent)
{
}

void	CCheckBoxFc::setFont(const QFont &f)
{
	QCheckBox::setFont(f);

	CalculateGeometry();
}

void	CCheckBoxFc::CalculateGeometry()
{
	QFontInfo		fi(font());
	QFontMetrics	fm(font());

	int		pixel_size	= fi.pixelSize();
	int		text_width	= fm.width(text());
	int		text_height	= fm.height();

	int		w = text_width + radio_button_width_data[pixel_size] * 4;
	int		h = text_height + radio_button_height_data[pixel_size] * 2;

	setMinimumSize(w, h);

	updateGeometry();
}

CRadioButtonFc::CRadioButtonFc(const QString &text, QWidget *parent)
	: QRadioButton(text, parent)
{
}

void	CRadioButtonFc::setFont(const QFont &f)
{
	QRadioButton::setFont(f);

	CalculateGeometry();
}

void	CRadioButtonFc::CalculateGeometry()
{
	QFontInfo		fi(font());
	QFontMetrics	fm(font());

	int		pixel_size	= fi.pixelSize();
	int		text_width	= fm.width(text());
	int		text_height	= fm.height();

	int		w = text_width + radio_button_width_data[pixel_size] * 4;
	int		h = text_height + radio_button_height_data[pixel_size] * 2;

	setMinimumSize(w, h);

	updateGeometry();
}

CLabelFc::CLabelFc(const QString &text, QWidget *parent,
					bool hh_flag, bool m_flag, bool e_flag)
	: QLabel(text, parent),
		half_height_flag(hh_flag), maximum_size_flag(m_flag),
		extra_spacing_flag(e_flag)
{
}

void	CLabelFc::setFont(const QFont &f)
{
	QLabel::setFont(f);

	CalculateGeometry();
}

QSize	CLabelFc::sizeHint() const
{
	return minimumSize();
}

void	CLabelFc::CalculateGeometry()
{
	string	label_text((const char *)(text().local8Bit()));

	StringToken::TokenStatus						token_status;
	vector<StringToken::CTokenValue *>				token_vector;
	vector<StringToken::CTokenValue *>::size_type	i;

	token_status = StringToken::GetCharTokenSequence(
						label_text, string("\n"), token_vector);

	vector<string>				text_lines;
	vector<string>::size_type	line_index;

	for (i=0; i<token_vector.size(); i++)
		text_lines.push_back(token_vector[i]->GetTokenString());

	StringToken::DeleteTokenVectorElements(token_vector);

	QFontInfo		fi(font());
	QFontMetrics	fm(font());

	int		pixel_size	= fi.pixelSize();

	int		m = grid_layout_margin_data[pixel_size];
	int		s = grid_layout_spacing_data[pixel_size];

	int		text_height;

	if (extra_spacing_flag)
		text_height	= (fm.height() + s) * text_lines.size() - s + 2 * m;
	else
		text_height	= fm.height() * text_lines.size();

	int		text_width	= 0;

	for (line_index=0; line_index<text_lines.size(); line_index++)
	{
		int		tw = fm.width(text_lines[line_index].c_str());

		if (text_width < tw)
			text_width = tw;
	}

	if (extra_spacing_flag)
		text_width += 2 * m;

	int		w;
	int		h;

	if (half_height_flag)
	{
		w = text_width + label_width_data[pixel_size] / 2;
		h = text_height + label_height_data[pixel_size] / 2;

	}
	else
	{
		w = text_width + label_width_data[pixel_size] * 2;
		h = text_height + label_height_data[pixel_size] * 2;
	}

	if (half_height_flag)
		setMaximumHeight(h);
	else if (maximum_size_flag)
		setMaximumSize(w, h);

	setMinimumSize(w, h);

	updateGeometry();
}

CLineEditFc::CLineEditFc(QWidget *parent, const QString &s)
	: QLineEdit(parent), size_string(s)
{
}

void	CLineEditFc::setFont(const QFont &f)
{
	QLineEdit::setFont(f);

	CalculateGeometry();
}

QSize	CLineEditFc::sizeHint() const
{
	QFontInfo		fi(font());
	QFontMetrics	fm(font());

	int		pixel_size	= fi.pixelSize();
	int		text_width	= fm.width(size_string);
	int		text_height	= fm.height();

	int		w = text_width + line_edit_width_data[pixel_size] * 2;
	int		h = text_height + line_edit_height_data[pixel_size] * 2;

	return QSize(w, h);
}

void	CLineEditFc::CalculateGeometry()
{
	QFontInfo		fi(font());
	QFontMetrics	fm(font());

	int		pixel_size	= fi.pixelSize();
	int		text_width	= fm.width(size_string);
	int		text_height	= fm.height();

	int		w = text_width + line_edit_width_data[pixel_size] * 2;
	int		h = text_height + line_edit_height_data[pixel_size] * 2;

	setMinimumSize(w, h);

	updateGeometry();
}

CComboBoxFc::CComboBoxFc(bool rw, QWidget *parent, const QString &s)
	: Q3ComboBox(rw, parent), size_string(s)
{
}

void	CComboBoxFc::setFont(const QFont &f)
{
	Q3ComboBox::setFont(f);

	CalculateGeometry();
}

void	CComboBoxFc::CalculateGeometry()
{
	QFontInfo		fi(font());
	QFontMetrics	fm(font());

	int		pixel_size	= fi.pixelSize();
	int		text_width	= fm.width(size_string);
	int		text_height	= fm.height();

	int		w = text_width + combo_box_width_data[pixel_size] * 2;
	int		h = text_height + combo_box_height_data[pixel_size] * 2;

	setMinimumSize(w, h);

	updateGeometry();
}

CListBoxFc::CListBoxFc(QWidget *parent, const QString &s, int c, bool m_flag)
	: Q3ListBox(parent), size_string(s),
		line_count(c), maximum_size_flag(m_flag)
{
}

void	CListBoxFc::setFont(const QFont &f)
{
	Q3ListBox::setFont(f);

	CalculateGeometry();
}

void	CListBoxFc::CalculateGeometry()
{
	QFontInfo		fi(font());
	QFontMetrics	fm(font());

	int		pixel_size	= fi.pixelSize();
	int		text_width	= fm.width(size_string);
	int		text_height	= fm.height();

	int		w = text_width + line_edit_width_data[pixel_size] * 2;
	int		h = text_height * line_count +
				grid_layout_margin_data[pixel_size] * 4 +
				grid_layout_spacing_data[pixel_size] * line_count;

	setMinimumSize(w, h);

	if (maximum_size_flag)
		setMaximumWidth(w);

	updateGeometry();
}

CMultiLineEditFc::CMultiLineEditFc(QWidget *parent, const QString &s,
									int c, bool m_flag)
	: Q3MultiLineEdit(parent), size_string(s),
		line_count(c), maximum_size_flag(m_flag)
{
}

void	CMultiLineEditFc::setFont(const QFont &f)
{
	Q3MultiLineEdit::setFont(f);

	CalculateGeometry();
}

void	CMultiLineEditFc::CalculateGeometry()
{
	QFontInfo		fi(font());
	QFontMetrics	fm(font());

	int		pixel_size	= fi.pixelSize();
	int		text_width	= fm.width(size_string);
	int		text_height	= fm.height();

	int		w = text_width + line_edit_width_data[pixel_size] * 2;
	int		h = text_height * line_count +
				grid_layout_margin_data[pixel_size] * 4 +
				grid_layout_spacing_data[pixel_size] * line_count;

	setMinimumSize(w, h);

	if (maximum_size_flag)
		setMaximumWidth(w);

	updateGeometry();
}

CFrameFc::CFrameFc(QWidget *parent, int nRows, int nCols,
					const char *name, Qt::WFlags f)
	: Q3Frame(parent, name, f)
{
	QFontInfo		fi(font());

	int		pixel_size = fi.pixelSize();

	int		m = grid_layout_margin_data[pixel_size];
	int		s = grid_layout_spacing_data[pixel_size];

	grid_layout = new QGridLayout(this, nRows, nCols, m, s);
}

void	CFrameFc::setFont(const QFont &f)
{
	Q3Frame::setFont(f);

	QFontInfo		fi(font());

	int		pixel_size = fi.pixelSize();

	int		m = grid_layout_margin_data[pixel_size];
	int		s = grid_layout_spacing_data[pixel_size];

	grid_layout->setMargin(m);
	grid_layout->setSpacing(s);
	grid_layout->invalidate();

	setMinimumSize(grid_layout->minimumSize());
	resize(grid_layout->minimumSize());
}

CHBoxFc::CHBoxFc(QWidget *parent, bool s_flag)
	: Q3HBox(parent), spacing_flag(s_flag)
{
}

void	CHBoxFc::setFont(const QFont &f)
{
	Q3HBox::setFont(f);

	CalculateGeometry();
}

void	CHBoxFc::CalculateGeometry()
{
	if (spacing_flag)
	{
		QFontInfo		fi(font());

		int		pixel_size = fi.pixelSize();

		int		m = h_box_margin_data[pixel_size];
		int		s = h_box_spacing_data[pixel_size];

		setMargin(m);
		setSpacing(s);
	}
	else
	{
		setMargin(0);
		setSpacing(0);
	}

	updateGeometry();
}

CVBoxFc::CVBoxFc(QWidget *parent, bool s_flag)
	: Q3VBox(parent), spacing_flag(s_flag)
{
}

void	CVBoxFc::setFont(const QFont &f)
{
	Q3VBox::setFont(f);

	CalculateGeometry();
}

void	CVBoxFc::CalculateGeometry()
{
	if (spacing_flag)
	{
		QFontInfo		fi(font());

		int		pixel_size = fi.pixelSize();

		int		m = v_box_margin_data[pixel_size];
		int		s = v_box_spacing_data[pixel_size];

		setMargin(m);
		setSpacing(s);
	}
	else
	{
		setMargin(0);
		setSpacing(0);
	}

	updateGeometry();
}

CGroupBoxFc::CGroupBoxFc(	int strips,
							Qt::Orientation orientation,
							const QString &title,
							QWidget *parent,
							const char *name)
	: Q3GroupBox(strips, orientation, title, parent, name)
{
}

void	CGroupBoxFc::setFont(const QFont &f)
{
	Q3GroupBox::setFont(f);

	CalculateGeometry();
}

void	CGroupBoxFc::CalculateGeometry()
{
	QFontInfo		fi(font());

	int		pixel_size = fi.pixelSize();

	int		m = group_box_margin_data[pixel_size];
	int		s = group_box_spacing_data[pixel_size];

	setInsideMargin(m);
	setInsideSpacing(s);

	updateGeometry();
}

CHGroupBoxFc::CHGroupBoxFc(	const QString &title,
							QWidget *parent,
							const char *name)
	: Q3GroupBox(1, Qt::Horizontal, title, parent, name)
{
}

void	CHGroupBoxFc::setFont(const QFont &f)
{
	Q3GroupBox::setFont(f);

	CalculateGeometry();
}

void	CHGroupBoxFc::CalculateGeometry()
{
	QFontInfo		fi(font());

	int		pixel_size = fi.pixelSize();

	int		m = group_box_margin_data[pixel_size];
	int		s = group_box_spacing_data[pixel_size];

	setInsideMargin(m);
	setInsideSpacing(s);

	updateGeometry();
}

CVGroupBoxFc::CVGroupBoxFc(	const QString &title,
							QWidget *parent,
							const char *name)
	: Q3GroupBox(1, Qt::Vertical, title, parent, name)
{
}

void	CVGroupBoxFc::setFont(const QFont &f)
{
	Q3GroupBox::setFont(f);

	CalculateGeometry();
}

void	CVGroupBoxFc::CalculateGeometry()
{
	QFontInfo		fi(font());

	int		pixel_size = fi.pixelSize();

	int		m = group_box_margin_data[pixel_size];
	int		s = group_box_spacing_data[pixel_size];

	setInsideMargin(m);
	setInsideSpacing(s);

	updateGeometry();
}

CButtonGroupFc::CButtonGroupFc(	int strips,
								Qt::Orientation orientation,
								const QString &title,
								QWidget *parent)
	: Q3ButtonGroup(strips, orientation, title, parent)
{
}

void	CButtonGroupFc::setFont(const QFont &f)
{
	Q3ButtonGroup::setFont(f);

	CalculateGeometry();
}

void	CButtonGroupFc::CalculateGeometry()
{
	QFontInfo		fi(font());

	int		pixel_size = fi.pixelSize();

	int		m = group_box_margin_data[pixel_size];
	int		s = group_box_spacing_data[pixel_size];

	setInsideMargin(m);
	setInsideSpacing(s);

	updateGeometry();
}

CHButtonGroupFc::CHButtonGroupFc(const QString &title, QWidget *parent)
	: Q3HButtonGroup(title, parent)
{
}

CHButtonGroupFc::CHButtonGroupFc(QWidget *parent)
	: Q3HButtonGroup(parent)
{
}

void	CHButtonGroupFc::setFont(const QFont &f)
{
	Q3HButtonGroup::setFont(f);

	CalculateGeometry();
}

void	CHButtonGroupFc::CalculateGeometry()
{
	QFontInfo		fi(font());

	int		pixel_size = fi.pixelSize();

	int		m = group_box_margin_data[pixel_size];
	int		s = group_box_spacing_data[pixel_size];

	setInsideMargin(m);
	setInsideSpacing(s);

	updateGeometry();
}

CVButtonGroupFc::CVButtonGroupFc(const QString &title, QWidget *parent)
	: Q3VButtonGroup(title, parent)
{
}

void	CVButtonGroupFc::setFont(const QFont &f)
{
	Q3VButtonGroup::setFont(f);

	CalculateGeometry();
}

void	CVButtonGroupFc::CalculateGeometry()
{
	QFontInfo		fi(font());

	int		pixel_size = fi.pixelSize();

	int		m = group_box_margin_data[pixel_size];
	int		s = group_box_spacing_data[pixel_size];

	setInsideMargin(m);
	setInsideSpacing(s);

	updateGeometry();
}

CSpacerFc::CSpacerFc(QWidget *parent, bool fs)
	: QWidget(parent), fixed_size_flag(fs)
{
}

void	CSpacerFc::setFont(const QFont &f)
{
	QWidget::setFont(f);

	CalculateGeometry();
}

void	CSpacerFc::CalculateGeometry()
{
	QFontInfo		fi(font());

	int		pixel_size	= fi.pixelSize();

	int		w = grid_layout_margin_data[pixel_size];
	int		h = grid_layout_margin_data[pixel_size];

	if (fixed_size_flag)
		setFixedSize(w, h);
	else
		setMinimumSize(w, h);

	updateGeometry();
}

CDialogFc::CDialogFc(QWidget *parent, int nRows, int nCols,
					bool modal, const char *name, Qt::WFlags f)
	: QDialog(parent, name, modal, f)
{
	QFontInfo		fi(font());

	int		pixel_size = fi.pixelSize();

	int		m = grid_layout_margin_data[pixel_size];
	int		s = grid_layout_spacing_data[pixel_size];

	grid_layout = new QGridLayout(this, nRows, nCols, m, s);

	setSizeGripEnabled(true);
}

void	CDialogFc::setFont(const QFont &f)
{
	QDialog::setFont(f);

	QFontInfo		fi(font());

	int		pixel_size = fi.pixelSize();

	int		m = grid_layout_margin_data[pixel_size];
	int		s = grid_layout_spacing_data[pixel_size];

	grid_layout->setMargin(m);
	grid_layout->setSpacing(s);
	grid_layout->invalidate();

	setMinimumSize(grid_layout->minimumSize());
	resize(grid_layout->minimumSize());
}

int		CResizeDialogFc::ExecuteDialog()
{
	if (parentWidget())
		QApplication::postEvent(this, new QEvent((QEvent::Type)ResizeDialogFc));

	return exec();
}

bool    CResizeDialogFc::event(QEvent *ev)
{
	switch ((int)ev->type())
	{
		case ResizeDialogFc:

		show();
		updateGeometry();

		CalculateSizeAndPosition();

		if (dialog_size != QSize(-1, -1))
		{
			setMinimumSize(dialog_size);
			setMaximumSize(dialog_size);
		}
		else
			setMinimumSize(10, 10);

		if (dialog_position != QPoint(-1, -1))
			move(dialog_position);

		return true;
	}

	return QWidget::event(ev);
}
