/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef HELPVIEWER_H
#define HELPVIEWER_H

#include <stdlib.h>

#include <q3vbox.h>
#include <q3textbrowser.h>
#include <qstring.h>
#include <qstringlist.h>

#include "fontchangeControl.h"

class CHelpViewer;

class CHelpNavigateWidget: public CFrameFc
{
	Q_OBJECT
	public:
	CHelpNavigateWidget(CHelpViewer *v);
	~CHelpNavigateWidget() { }

	void	SetBackwardEnabled(bool f);
	void	SetForwardEnabled(bool f);

	public slots:
	void	NavigateBackward();
	void	NavigateForward();
	void	NavigateHome();

	private:
	CHelpViewer			*help_viewer;
	CPushButtonFc		*backward_button;
	CPushButtonFc		*forward_button;
	CPushButtonFc		*home_button;
	CLabelFc			*help_label;
};

class CHelpViewer : public Q3VBox
{
	Q_OBJECT
	public:
	CHelpViewer(QWidget *parent);
	~CHelpViewer() { }

	void	NavigateBackward();
	void	NavigateForward();
	void	NavigateHome();
	void	SetHTMLSource(const QString &s);

	public slots:
	void	BackwardAvailable(bool available);
	void	ForwardAvailable(bool available);

	private:
	CHelpNavigateWidget		*help_navigate_widget;
	Q3TextBrowser			*text_browser;
};

#endif
