/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef IDMAP_H
#define IDMAP_H

using namespace std;

#include <list>
#include <map>
#include <iostream>
#include <iomanip>

class CIdMap
{
	public:
	CIdMap();
	~CIdMap();

	enum rvalue
	{
		NoError			= 0,
		IdNotFound		= 1,
		DuplicateId		= 2,
		IndexOutOfRange	= 3
	};

	rvalue		GetIndex(int existing_id, int &index);
	rvalue		InsertBeforeId(int existing_id, int new_id);
	rvalue		InsertAfterId(int existing_id, int new_id);
	rvalue		RemoveId(int existing_id);
	rvalue		InsertBeforeIndex(int index, int new_id);
	rvalue		InsertAfterIndex(int index, int new_id);
	rvalue		RemoveIndex(int index);
	rvalue		Append(int new_id);

	typedef map<int, int>			TMap1;
	typedef TMap1::iterator			TIterator1;
	typedef TMap1::const_iterator	TConstIterator1;
	typedef list<TIterator1>		TList2;
	typedef TList2::iterator		TIterator2;
	typedef TList2::const_iterator	TConstIterator2;

	const TMap1		&GetIdToIndexMap() const;
	const TList2	&GetMapIteratorList() const;

	private:
	TMap1		id_to_index_map;
	TList2		map_iterator_list;
	rvalue		GetMapIterator(int id, TIterator1 &iterator);
	rvalue		GetListIterator(int index, TIterator2 &iterator);
};

ostream		&operator<<(ostream &s, const CIdMap &idm);

#endif
