/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef IMPLICITVIEW_H
#define	IMPLICITVIEW_H

class CImplicitVBoxWidget;
class CImplicitView;

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"

class CImplicitVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CImplicitVBoxWidget(QWidget *parent,
						CCompilerInterface *ci,
						SMainViewControl *mvc,
						COptionData::SSubViewData *d,
						CImplicitView *iv);

	virtual ~CImplicitVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializeModulePointers();

	void	UpdateListView();
	void	RestoreUndoData();

	private:
	CLabelFc		*label;
	CLabelFc		*implicit;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CImplicitView				*implicit_view;
	ModulePtrMap				&module_ptr_map;
};

class CImplicitView: public CSubView
{
	public:
	CImplicitView(	QWidget *p,
					CViewNode *n,
					CInterfaceControl *ic,
					SMainViewControl *mvc,
					const string &dfs,
					CPaletteData *dpd,
					COptionData::SSubViewData *d);

	virtual ~CImplicitView();

	virtual CImplicitVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	UpdateListView();
	void	RestoreUndoData();

	private:
	CImplicitVBoxWidget		*frame;
};

#endif
