/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef MACHINEVIEW_H
#define	MACHINEVIEW_H

class CMachineControl;
class CMachineVBoxWidget;
class CMachineView;

#include <string>
#include <list>

#include <qspinbox.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"

class CMachineControl: public CFrameFc
{
	Q_OBJECT
	public:
	CMachineControl(CMachineVBoxWidget *v);
	~CMachineControl() { }

	void	ResetControl(const list<string> &s, int type, int c);

	public slots:
	void	SelectParserData(int type);
	void	SelectState(int state);

	private:
	CMachineVBoxWidget		*machine_vbox;
	CLabelFc				*view_label;
	CLabelFc				*parser_data_label;
	CComboBoxFc				*parser_data_combo_box;
	CLabelFc				*state_label;
	QSpinBox				*state_spinbox;
	CSpacerFc				*spacer;
};

class CMachineVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CMachineVBoxWidget(	QWidget *parent,
						CCompilerInterface *ci,
						SMainViewControl *mvc,
						COptionData::SSubViewData *d,
						CMachineView *mv);

	virtual ~CMachineVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializeModulePointers();

	void	UpdateView(int type);
	void	SetTabStopWidth(int count);
	void	SelectParserData(int type);
	void	SelectState(int state);
	void	DisplayData();
	void	RestoreUndoData();

	private:
	int							data_type;
	int							machine_state;
	CMachineControl				*machine_control;
	CMultiLineEditFc			*multi_line_edit;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	CCompilerCalculate			*compiler_calculate;
	COptionData::SSubViewData	*subview_data;
	CMachineView				*machine_view;
	ModulePtrMap				&module_ptr_map;
};

class CMachineView: public CSubView
{
	public:
	CMachineView(	QWidget *p,
					CViewNode *n,
					CInterfaceControl *ic,
					SMainViewControl *mvc,
					const string &dfs,
					CPaletteData *dpd,
					COptionData::SSubViewData *d);

	virtual ~CMachineView();

	virtual CMachineVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	UpdateView(int type);
	void	SetTabStopWidth(int count);
	void	RestoreUndoData();

	private:
	CMachineVBoxWidget		*frame;
};

#endif
