/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "menuNodeData.h"

SMainMenuConfiguration::SMainMenuConfiguration(
	vector< pair<int, SSubmenuNodeData *> > &submenus) : menu_tree(0)
{
	int		submenu_node_count;
	int		submenu_operation_count;
	int		submenu_operation_offset;

	vector< pair<int, SSubmenuNodeData *> >::size_type	i;

	operation_count	= 0;
	menu_node_count	= 0;

	for (i=0; i<submenus.size(); i++)
	{
		submenus[i].second[0].node_identifier = i;

		submenu_node_count			= GetSubmenuNodeCount(submenus[i].second);
		submenu_operation_count		= submenus[i].second[0].operation_count;
		submenu_operation_offset	= operation_count;

		submenu_configurations.push_back(
			SSubmenuConfiguration(	submenus[i].first,
									submenu_node_count,
									submenu_operation_count,
									submenu_operation_offset));

		menu_node_count += submenu_node_count;
		operation_count += submenu_operation_count;
	}

	menu_node_count++;

	main_menu_node_data = new SMainMenuNodeData[menu_node_count];

	SSubmenuNodeData	bar(MN::menu_node_type_bar, "", 0, 0, 0, 0, 0, 0);

	main_menu_node_data[0] = SMainMenuNodeData(bar, "", operation_count);

	int		j;
	int		k;
	int		index = 1;

	for (i=0; i<submenus.size(); i++)
	{
		submenu_id_map[submenu_configurations[i].submenu_id] = i;

		submenu_node_count		 = submenu_configurations[i].node_count;
		submenu_operation_count	 = submenu_configurations[i].operation_count;
		submenu_operation_offset = submenu_configurations[i].operation_offset;

		ostrstream		index_prefix;

		index_prefix << i << '\0';

		for (j=0; j<submenu_node_count; j++)
		{
			main_menu_node_data[index] =
				SMainMenuNodeData(	submenus[i].second[j],
									index_prefix.str(),
									operation_count);

			SMainMenuNodeData	&mmnd = main_menu_node_data[index];

			for (k=0; k<submenu_operation_count; k++)
				mmnd.operation_list[submenu_operation_offset + k] =
					submenus[i].second[j].operation_list[k];

			index++;
		}
	}
}

SMainMenuConfiguration::~SMainMenuConfiguration()
{
	delete menu_tree;

	for (int i=0; i<menu_node_count; i++)
		main_menu_node_data[i].DeleteOperationList();

	delete [] main_menu_node_data;
}

void	SMainMenuConfiguration::CreateMenu(QMenuBar *b)
{
	menu_tree = new CMenuBarNode<SMainMenuNodeData>(b, main_menu_node_data[0]);

	for (int i=1; i<menu_node_count; i++)
		menu_tree->AddMenuNode(main_menu_node_data[i]);
}

void	SMainMenuConfiguration::DestroyMenu()
{
	delete menu_tree;
}

bool	SMainMenuConfiguration::ModifyMenu(int id, int op, QObject *obj)
{
	SSubmenuConfiguration	&sc = submenu_configurations[submenu_id_map[id]];

	if (op < sc.operation_count)
		return menu_tree->ModifyMenu(sc.operation_offset + op, obj);
	else
		return false;
}

bool	SMainMenuConfiguration::DisableMenu()
{
	return menu_tree->ModifyMenu(operation_count, 0);
}

Q3PopupMenu		*SMainMenuConfiguration::GetSubMenu(const string &index)
{
	int		i;

	for (i=0; i<menu_node_count; i++)
		if (index == main_menu_node_data[i].tree_index)
			break;

	if (i < menu_node_count)
		return menu_tree->GetSubMenu(main_menu_node_data[i]);
	else
		return 0;
}

void	SMainMenuConfiguration::SetMenuFont(QFont &f)
{
	menu_tree->SetMenuFont(f);
}

void	SMainMenuConfiguration::SetMenuPalette(QPalette &p)
{
	menu_tree->SetMenuPalette(p);
}

int		GetSubmenuNodeCount(const SSubmenuNodeData *d)
{
	int		index = 0;
	while (d[index].node_type != MN::menu_node_type_end)
		index++;

	return index;
}

ostream &operator<<(ostream &os, const SSubmenuNodeData &d)
{
	os	<< "node_type         = " << d.node_type << endl;
	os	<< "tree_index        = " << d.tree_index << endl;
	os	<< "node_identifier   = " << d.node_identifier << endl;
	os	<< "text              = " << d.text << endl;
	os	<< "accelerator       = " << d.accelerator << endl;
	os	<< "slot              = " << d.slot << endl;
	os	<< "operation_count   = " << d.operation_count << endl;

	for (int i=0; i<d.operation_count; i++)
	{
		os << "operation_list[" << i << "] = ";
		
		switch (d.operation_list[i])
		{
			case MN::menu_node_operation_noop:
			os << "mn_noop" << endl;
			break;

			case MN::menu_node_operation_enable:
			os << "mn_enable" << endl;
			break;

			case MN::menu_node_operation_disable:
			os << "mn_disable" << endl;
			break;
		}
	}

	return os;
}

ostream &operator<<(ostream &os, const SMainMenuNodeData &d)
{
	os	<< "node_type         = " << d.node_type << endl;
	os	<< "tree_index        = " << d.tree_index << endl;
	os	<< "node_identifier   = " << d.node_identifier << endl;
	os	<< "text              = " << d.text << endl;
	os	<< "accelerator       = " << d.accelerator << endl;
	os	<< "slot              = " << d.slot << endl;
	os	<< "operation_count   = " << d.operation_count << endl;

	for (int i=0; i<d.GetOperationCount(); i++)
	{
		os << "operation_list[" << i << "] = ";
		
		switch (d.operation_list[i])
		{
			case MN::menu_node_operation_noop:
			os << "mn_noop" << endl;
			break;

			case MN::menu_node_operation_enable:
			os << "mn_enable" << endl;
			break;

			case MN::menu_node_operation_disable:
			os << "mn_disable" << endl;
			break;
		}
	}

	return os;
}

ostream &operator<<(ostream &os, const SMainMenuConfiguration &d)
{
	for (int i=0; i<d.menu_node_count; i++)
		os	<< "node data [" << i << "] =" << endl
			<< d.main_menu_node_data[i] << endl;

	return os;
}
