/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef OPTIONDIALOG_H
#define OPTIONDIALOG_H

#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <unistd.h>
#include <time.h>
#include <string.h>
#include <string>
#include <map>
#include <vector>
#include <list>
#include <algorithm>
#include <strstream>
#include <fstream>

#include <qnamespace.h>
#include <qstring.h>
#include <qfont.h>
#include <qfontinfo.h>
#include <qfontmetrics.h>
#include <qfontdatabase.h>
#include <qlayout.h>
#include <qwidget.h>
#include <qtabwidget.h>
#include <qspinbox.h>
#include <q3scrollview.h>
#include <q3listview.h>
#include <q3listbox.h>
#include <q3textedit.h>
#include <qstringlist.h>
#include <q3valuelist.h>
#include <qcolor.h>
#include <qpalette.h>
#include <q3painter.h>
#include <qpixmap.h>
#include <qevent.h>
#include <qregexp.h>

class CMessageDialog;
class CInformationDialog;
class CRootOrientationDialog;
class CViewOrderingDialog;
class CValueDialog;
class CFileDirectoryDialog;
class CAuxiliaryStringDialog;
class CAuxiliaryFontDialog;
class CMainviewTreeFontDialog;
class CAuxiliaryColorDialog;
class CPaletteColorDialog;
class CAuxiliaryPaletteDialog;
class CMainviewTreePaletteDialog;
class CAuxiliaryXpmImageDialog;
class CBrushXpmImageDialog;
class CAuxiliaryBrushDialog;
class CSizePositionDialog;

namespace OptionDialog
{
	extern CMessageDialog				*message_dialog;
	extern CInformationDialog			*information_dialog;
	extern CRootOrientationDialog		*root_orientation_dialog;
	extern CViewOrderingDialog			*view_ordering_dialog;
	extern CValueDialog					*value_dialog;
	extern CFileDirectoryDialog			*file_directory_dialog;
	extern CAuxiliaryStringDialog		*auxiliary_string_dialog;
	extern CAuxiliaryFontDialog			*auxiliary_font_dialog;
	extern CMainviewTreeFontDialog		*mainview_tree_font_dialog;
	extern CAuxiliaryColorDialog		*auxiliary_color_dialog;
	extern CPaletteColorDialog			*palette_color_dialog;
	extern CAuxiliaryPaletteDialog		*auxiliary_palette_dialog;
	extern CMainviewTreePaletteDialog	*mainview_tree_palette_dialog;
	extern CAuxiliaryXpmImageDialog		*auxiliary_xpm_image_dialog;
	extern CBrushXpmImageDialog			*brush_xpm_image_dialog;
	extern CAuxiliaryBrushDialog		*auxiliary_brush_dialog;
	extern CSizePositionDialog			*size_position_dialog;

	void	CreateOptionDialogs(QWidget *parent);
	void	DestroyOptionDialogs();
	void	SetPaletteAndFont(QWidget *w);

	const char * const  path_string_size = 
		"0123456789012345678901234567890123456789";

	const char * const  auxiliary_string_size = 
		"012345678901234567890123456789012345678901234567890123456789";
};

#include "fontchangeControl.h"
#include "optionData.h"
#include "filePath.h"
#include "optionEditView.h"

class CMessageDialog: public CResizeDialogFc
{
	Q_OBJECT
	public:
	CMessageDialog(QWidget *parent);
	virtual ~CMessageDialog() { }

	void	SetTitleAndMessageText(const string &title, const string &msg);

	protected:
	virtual void    CalculateSizeAndPosition();

	private:
	CLabelFc		*message_label;
	CPushButtonFc	*ok_button;
	CPushButtonFc	*cancel_button;
	CSpacerFc		*spacer;
};

class CInformationDialog: public CResizeDialogFc
{
	Q_OBJECT
	public:
	CInformationDialog(QWidget *parent);
	virtual ~CInformationDialog() { }

	void	SetTitleAndMessageText(const string &title, const string &msg);
	void	SetTextAlignment(int f);

	protected:
	virtual void    CalculateSizeAndPosition();

	private:
	CLabelFc		*message_label;
	CPushButtonFc	*ok_button;
	CSpacerFc		*spacer;
};

class CRootOrientationDialog: public CResizeDialogFc
{
	Q_OBJECT
	public:
	CRootOrientationDialog(QWidget *parent);
	virtual ~CRootOrientationDialog() { }

	void	SetAddNodePointer(Qt::Orientation *p)
	{ add_node = p; }

	public slots:
	void	AcceptOperation();

	protected:
	virtual void    CalculateSizeAndPosition();

	private:
	CLabelFc		*message_label;
	CHButtonGroupFc	*button_group;
	CRadioButtonFc	*horizontal_radio_button;
	CRadioButtonFc	*vertical_radio_button;
	CPushButtonFc	*ok_button;
	CPushButtonFc	*cancel_button;
	CSpacerFc		*spacer;

	Qt::Orientation		*add_node;
};

class CViewOrderingDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CViewOrderingDialog(QWidget *parent);
	virtual ~CViewOrderingDialog() { }

	typedef		vector<COptionData::SMainViewData *>		MainViewPtrs;
	typedef		MainViewPtrs::size_type						MainViewPtrsIndex;

	void	SetTitleAndResize(const string &title);
	void	SetPointers(MainViewPtrs *p1, vector<MainViewPtrsIndex> *p2);

	virtual void    setFont(const QFont &f);

	public slots:
	void	MoveUp();
	void	MoveDown();
	void	MoveToFirst();
	void	MoveToLast();

	protected:
	MainViewPtrs				*main_view_ptrs;
	vector<MainViewPtrsIndex>	*ordering_array;

	CListBoxFc		*main_view_listbox;
	CPushButtonFc	*move_up_button;
	CPushButtonFc	*move_down_button;
	CPushButtonFc	*move_to_first_button;
	CPushButtonFc	*move_to_last_button;
	CPushButtonFc	*ok_button;
	CPushButtonFc	*cancel_button;
};

class CValueDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CValueDialog(QWidget *parent);
	virtual ~CValueDialog() { }

	void	SetTitleAndLabelText(const string &title, const string &lt);
	void	SetValuePointer(string *p)
	{ value_pointer = p; }
	void	SetValueLineEdit(const QString &v)
	{ value_line_edit->setText(v); }

	virtual void    setFont(const QFont &f);

	public slots:
	void	AcceptOperation();

	private:
	string			*value_pointer;
	CLabelFc		*value_label;
	CLineEditFc		*value_line_edit;
	CPushButtonFc	*ok_button;
	CPushButtonFc	*cancel_button;
	CSpacerFc		*spacer;
};

class CEntryData
{
	public:
	CEntryData(string &d, string &e, string &fp,
				struct stat &data, QPixmap *u, QPixmap *s)
		: directory_path(d), entry_name(e), full_path(fp),
			status_data(data), unselected_pixmap(u), selected_pixmap(s) { }
	virtual ~CEntryData() { }

	bool	operator<(const CEntryData &ed) const
	{
		if (entry_name < ed.entry_name)
			return true;
		else
			return false;
	}

	string			directory_path;
	string			entry_name;
	string			full_path;
	struct stat		status_data;
	QPixmap			*unselected_pixmap;
	QPixmap			*selected_pixmap;
};

class CDirectoryEntry: public Q3ListBoxPixmap
{
	public:
	CDirectoryEntry(CEntryData &ed, QPixmap &p)
		: Q3ListBoxPixmap(p, ed.entry_name.c_str()), entry_data(ed) { }
	virtual ~CDirectoryEntry() { }

	CEntryData		&entry_data;
};

class CFileDirectoryDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CFileDirectoryDialog(QWidget *parent);
	virtual ~CFileDirectoryDialog();

	void	SetOpenFileMode()			{ check_file_exists_flag = true; }
	void	SetSaveAsFileMode()			{ check_file_exists_flag = false; }
	void	SetPathPointer(string *p)	{ path_pointer = p; }
	void	SetTitleAndResize(const string &title);
	void	SetDirectoryPath(const string &p);
	void	SetFileName(const string &f);
	void	SetFileTypes(vector< pair<string, string> > *types);

	int		DisplayOpenFileDialog(	string *path,
									const string &title,
									const string &directory,
									const string &file,
									vector< pair<string, string> > *types);

	int		DisplaySaveAsFileDialog(string *path,
									const string &title,
									const string &directory,
									const string &file,
									vector< pair<string, string> > *types);

	virtual void    setFont(const QFont &f);
	void			SetupPixmaps();
	void			CreateListBoxItems();
	void			ConnectListBox();
	void			DisconnectListBox();
	void			ConnectComboBox();
	void			DisconnectComboBox();

	public slots:
	void	AcceptOperation();
	void	DirectoryEntryHighlighted(Q3ListBoxItem *);
	void	DirectoryEntrySelected(Q3ListBoxItem *);
	void	DisplayStatus();
	void	FileTypeSelected(int);

	protected:
	list<CEntryData>				directory_entries;
	vector< pair<string, string> >	file_types;
	CDirectoryEntry					*current_entry;

	string			*path_pointer;
	bool			check_file_exists_flag;
	QPixmap			*unselected_file_pixmap;
	QPixmap			*selected_file_pixmap;
	QPixmap			*unselected_directory_pixmap;
	QPixmap			*selected_directory_pixmap;
	QPixmap			*unselected_alternate_pixmap;
	QPixmap			*selected_alternate_pixmap;

	CListBoxFc		*directory_entry_listbox;
	CLabelFc		*directory_label;
	CLineEditFc		*directory_line_edit;
	CLabelFc		*file_label;
	CLineEditFc		*file_line_edit;
	CPushButtonFc	*status_button;
	CLabelFc		*type_label;
	CComboBoxFc		*type_combo_box;
	CPushButtonFc	*ok_button;
	CPushButtonFc	*cancel_button;
};

class CAuxiliaryStringDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CAuxiliaryStringDialog(QWidget *parent);
	virtual ~CAuxiliaryStringDialog() { }

	void	SetTitleAndResize(const string &title);

	void	SetNamePointer(string *p)
	{ name_pointer = p; }
	void	SetValuePointer(string *p)
	{ value_pointer = p; }
	void	SetAuxiliaryName(const QString &n)
	{ name_line_edit->setText(n); name_changed_flag = false; }
	void	SetAuxiliaryValue(const QString &v)
	{ value_line_edit->setText(v); value_changed_flag = false; }
	bool	GetNameChangedFlag()
	{ return name_changed_flag; }
	bool	GetValueChangedFlag()
	{ return value_changed_flag; }

	virtual void    setFont(const QFont &f);

	public slots:
	void	AcceptOperation();
	void	NameChanged(const QString &s);
	void	ValueChanged(const QString &s);

	private:
	string			*name_pointer;
	string			*value_pointer;
	bool			name_changed_flag;
	bool			value_changed_flag;
	CLabelFc		*name_label;
	CLineEditFc		*name_line_edit;
	CLabelFc		*value_label;
	CLineEditFc		*value_line_edit;
	CPushButtonFc	*ok_button;
	CPushButtonFc	*cancel_button;
	CSpacerFc		*spacer;
};

class CBaseFontDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CBaseFontDialog(QWidget *parent);
	virtual ~CBaseFontDialog() { }

	void	SetNamePointer(string *p)	{ name_pointer = p; }
	void	SetValuePointer(string *p)	{ value_pointer = p; }
	bool	GetNameChangedFlag()		{ return name_changed_flag; }
	bool	GetValueChangedFlag()		{ return value_changed_flag; }

	void	SetTitleAndResize(const string &title);
	void	SetValueLineEdit(const QString &v);

	virtual void    setFont(const QFont &f);

	public slots:
	virtual void	AcceptOperation() = 0;
	void			ValueChanged(const QString &s);
	void			DisplayFont();
	void			SelectFamily(int index);
	void			SelectStyle(int index);
	void			SelectPointSize(int index);

	protected:
	string			*name_pointer;
	string			*value_pointer;
	bool			name_changed_flag;
	bool			value_changed_flag;

	QGridLayout     *subgrid_layout1;
	CLabelFc		*name_label;
	CPushButtonFc	*ok_button;
	CLabelFc		*value_label;
	CLineEditFc		*value_line_edit;
	CPushButtonFc	*display_font_button;
	CPushButtonFc	*cancel_button;
	QGridLayout     *subgrid_layout2;
	CLabelFc		*family_label;
	CLabelFc		*style_label;
	CLabelFc		*point_size_label;
	CLabelFc		*character_display_label;
	CListBoxFc		*family_listbox;
	CListBoxFc		*style_listbox;
	CListBoxFc		*point_size_listbox;
	Q3ScrollView	*scroll_view;
	CLabelFc		*font_display_label;

	typedef map<string, vector<int> >			StyleToPointSizeMap;
	typedef map<string, StyleToPointSizeMap>	FamilyToStyleMap;

	QFontDatabase			font_database;
	FamilyToStyleMap		database_map;
	StyleToPointSizeMap		current_style_map;
	vector<int>				current_point_size_vector;

	struct add_family_types_to_listbox
		: public unary_function<pair<string, StyleToPointSizeMap>, void>
	{
		explicit add_family_types_to_listbox(CListBoxFc *lb)
			: listbox(lb) { }

		void    operator()(pair<string, StyleToPointSizeMap> x)
		{
			listbox->insertItem(x.first.c_str());
		}

		private:
		CListBoxFc	*listbox;
	};

	struct add_style_types_to_listbox
		: public unary_function<pair<string, vector<int> >, void>
	{
		explicit add_style_types_to_listbox(CListBoxFc *lb)
			: listbox(lb) { }

		void    operator()(pair<string, vector<int> > x)
		{
			listbox->insertItem(x.first.c_str());
		}

		private:
		CListBoxFc	*listbox;
	};

	void		CreateFontDatabaseMap();
};

class CAuxiliaryFontDialog: public CBaseFontDialog
{
	Q_OBJECT
	public:
	CAuxiliaryFontDialog(QWidget *parent);
	virtual ~CAuxiliaryFontDialog() { }

	void	SetNameLineEdit(const QString &n);

	virtual void    setFont(const QFont &f);

	public slots:
	virtual void	AcceptOperation();
	void			NameChanged(const QString &s);

	protected:
	CLineEditFc		*name_line_edit;
};

class CMainviewTreeFontDialog: public CBaseFontDialog
{
	Q_OBJECT
	public:
	CMainviewTreeFontDialog(QWidget *parent);
	virtual ~CMainviewTreeFontDialog() { }

	void    SetNameComboBox(CAuxiliaryFontView *afv);

	virtual void    setFont(const QFont &f);

	public slots:
	virtual void	AcceptOperation();
	void			AddAuxiliaryFont();
	void			NameSelected(const QString &s);

	protected:
	CComboBoxFc		*name_combo_box;
	CPushButtonFc	*add_auxiliary_button;

	CAuxiliaryFontView	*auxiliary_font_view;

	void	UpdateComboBox(string *s);
};

class CBaseColorDialog;

class CColorSelectionWidget: public QWidget
{
	Q_OBJECT
	public:
	CColorSelectionWidget(CBaseColorDialog *parent, int b, int iw, int ih);
	virtual ~CColorSelectionWidget() { }

	virtual void	SetColorSelection(int h, int s, int v) = 0;

	protected:
	virtual void		focusInEvent(QFocusEvent *e);
	virtual void		focusOutEvent(QFocusEvent *e);
	void				DrawBorder();

	CBaseColorDialog	*base_color_dialog;
	int					border_width;
	int					interior_width;
	int					interior_height;
	bool				focus_flag;
};

class CHueSaturationWidget: public CColorSelectionWidget
{
	Q_OBJECT
	public:
	CHueSaturationWidget(CBaseColorDialog *parent);
	virtual ~CHueSaturationWidget();

	virtual void	SetColorSelection(int h, int s, int v);

	protected:
	virtual void	mousePressEvent(QMouseEvent *e);
	virtual void	mouseMoveEvent(QMouseEvent *e);
	virtual void	keyPressEvent(QKeyEvent *e);
	virtual void	paintEvent(QPaintEvent *e);

	private:
	static QPixmap		*hue_saturation_pixmap;
	static int			object_count;
	int					current_hue;
	int					current_saturation;
	int					indicator_radius;
	void				UpdateSelection(int x, int y);
	void				RestorePixels();
	void				DrawIndicator();
};

class CValueWidget: public CColorSelectionWidget
{
	Q_OBJECT
	public:
	CValueWidget(CBaseColorDialog *parent);
	virtual ~CValueWidget();

	virtual void	SetColorSelection(int h, int s, int v);

	protected:
	virtual void	mousePressEvent(QMouseEvent *e);
	virtual void	mouseMoveEvent(QMouseEvent *e);
	virtual void	keyPressEvent(QKeyEvent *e);
	virtual void	paintEvent(QPaintEvent *e);

	private:
	int					current_hue;
	int					current_saturation;
	int					current_value;
	int					indicator_width;
	int					indicator_pixel_count;
	int					*indicator_x;
	int					*indicator_y;
	void				UpdateSelection(int z);
	void				DrawValuePixmap();
	void				DrawIndicator();
};

class CColorComponentSpinBox: public QSpinBox
{
	Q_OBJECT
	public:
	enum ComponentId
	{
		NullId,
		ColorSelectionId,
		ColorNameId,
		RedId,
		GreenId,
		BlueId,
		HueId,
		SaturationId,
		ValueId
	};

	CColorComponentSpinBox(	ComponentId id,
							int minValue,
							int maxValue,
							int step = 1,
							CBaseColorDialog *parent = 0);
	virtual ~CColorComponentSpinBox() { }

	protected:
	virtual void		focusInEvent(QFocusEvent *e);
	virtual void		keyPressEvent(QKeyEvent *e);

	private:
	CBaseColorDialog	*base_color_dialog;
	ComponentId			component_id;
};

class CColorDisplayWidget: public QWidget
{
	Q_OBJECT
	public:
	CColorDisplayWidget(QWidget *parent,
						int bw,
						const QString &s = QString(""));
	virtual ~CColorDisplayWidget() { }

	void			SetColor(const QColor &c);
	void			SetColor(CPaletteData::SColorSpecifier *cs);
	void            CalculateGeometry();
	virtual void    setFont(const QFont &f);

	protected:
	virtual void	paintEvent(QPaintEvent *e);

	private:
	QColor			color;
	int				border_width;
	QString			size_string;
	void			DrawColor();
};

class CBaseColorDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CBaseColorDialog(QWidget *parent);
	virtual ~CBaseColorDialog() { }

	void	SetNamePointer(string *p)	{ name_pointer = p; }
	void	SetValuePointer(CPaletteData::SColorSpecifier **p)
	{ value_pointer = p; }
	bool	GetNameChangedFlag()		{ return name_changed_flag; }
	bool	GetValueChangedFlag()		{ return value_changed_flag; }

	void	SetTitleAndResize(const string &title);
	void	SetColorValue(CPaletteData::SColorSpecifier *v);
	void	StoreColorValue(CPaletteData::SColorSpecifier **p);

	void	HueSaturationSelection(int h, int s);
	void	ValueSelection(int v);
	void	SetWidgetColorSelections();
	void	SetColorComponents();
	void	SetRgbColorComponents();
	void	SetHsvColorComponents();
	void	DrawColorDisplayWidget(const QColor &c);
	void	SetupSpinboxConnections(CColorComponentSpinBox::ComponentId id);

	virtual void    setFont(const QFont &f);

	public slots:
	virtual void	AcceptOperation() = 0;
	void			RedChanged(int r);
	void			GreenChanged(int g);
	void			BlueChanged(int b);
	void			HueChanged(int h);
	void			SaturationChanged(int s);
	void			ValueChanged(int v);
	void			DisplayColorName();

	protected:
	string							*name_pointer;
	CPaletteData::SColorSpecifier	**value_pointer;
	bool							name_changed_flag;
	bool							value_changed_flag;

	CHueSaturationWidget	*hue_saturation_widget;
	CValueWidget			*value_widget;
	int						current_hue;
	int						current_saturation;
	int						current_value;

	CColorComponentSpinBox::ComponentId		current_connection_id;

	CHButtonGroupFc			*button_group;
	CRadioButtonFc			*rgb_radio_button;
	CRadioButtonFc			*hsv_radio_button;
	CRadioButtonFc			*color_name_radio_button;
	QGridLayout     		*subgrid_layout1;
	CColorDisplayWidget		*color_display_widget;
	CLabelFc				*red_label;
	CColorComponentSpinBox	*red_spinbox;
	CLabelFc				*green_label;
	CColorComponentSpinBox	*green_spinbox;
	CLabelFc				*blue_label;
	CColorComponentSpinBox	*blue_spinbox;
	CLabelFc				*hue_label;
	CColorComponentSpinBox	*hue_spinbox;
	CLabelFc				*saturation_label;
	CColorComponentSpinBox	*saturation_spinbox;
	CLabelFc				*value_label;
	CColorComponentSpinBox	*value_spinbox;
	QGridLayout     		*subgrid_layout2;
	CLabelFc				*color_name_label;
	CLineEditFc				*color_name_line_edit;
	CPushButtonFc			*display_button;
	QGridLayout     		*subgrid_layout3;
	CLabelFc				*name_label;
	CPushButtonFc			*ok_button;
	CPushButtonFc			*cancel_button;
};

class CAuxiliaryColorDialog: public CBaseColorDialog
{
	Q_OBJECT
	public:
	CAuxiliaryColorDialog(QWidget *parent);
	virtual ~CAuxiliaryColorDialog() { }

	void	SetNameLineEdit(const QString &n);

	virtual void    setFont(const QFont &f);

	public slots:
	virtual void	AcceptOperation();
	void			NameChanged(const QString &s);

	protected:
	CLineEditFc		*name_line_edit;
};

class CPaletteColorDialog: public CBaseColorDialog
{
	Q_OBJECT
	public:
	CPaletteColorDialog(QWidget *parent);
	virtual ~CPaletteColorDialog() { }

	void    SetNameComboBox(CAuxiliaryColorView *acv);

	virtual void    setFont(const QFont &f);

	public slots:
	virtual void	AcceptOperation();
	void			AddAuxiliaryColor();
	void			NameSelected(const QString &s);

	protected:
	CComboBoxFc		*name_combo_box;
	CPushButtonFc	*add_auxiliary_button;

	CAuxiliaryColorView		*auxiliary_color_view;

	void	UpdateComboBox(string *s);
};

class CPaletteDemoWidget: public CFrameFc
{
	Q_OBJECT
	public:
	CPaletteDemoWidget(QWidget *parent);
	virtual ~CPaletteDemoWidget() { }

	void	SetDemoPalette(CPaletteData *p);

	virtual void    setFont(const QFont &f);

	protected:
	CLabelFc				*active_raised_label;
	CLabelFc				*active_sunken_label;
	CPushButtonFc			*active_button;
	CLineEditFc				*active_line_edit;
	Q3TextEdit				*active_text_edit;
	CLabelFc				*disabled_raised_label;
	CLabelFc				*disabled_sunken_label;
	CPushButtonFc			*disabled_button;
	CLineEditFc				*disabled_line_edit;
	Q3TextEdit				*disabled_text_edit;
};

class CListViewPaletteDemo: public CPaletteDemoWidget
{
	Q_OBJECT
	public:
	CListViewPaletteDemo(QWidget *parent);
	virtual ~CListViewPaletteDemo() { }

	virtual void    setFont(const QFont &f);

	void	CalculateGeometry();
};

class CDialogPaletteDemo: public CPaletteDemoWidget
{
	Q_OBJECT
	public:
	CDialogPaletteDemo(QWidget *parent);
	virtual ~CDialogPaletteDemo() { }

	virtual void    setFont(const QFont &f);

	public slots:
	void	InactiveDisplay();
};

class CColorResetButton: public QPushButton
{
	Q_OBJECT
	public:
	CColorResetButton(QWidget *parent, int bw);
	virtual ~CColorResetButton() { }

	void			SetColor(const QColor &c);
	void            CalculateGeometry();
	virtual void    setFont(const QFont &f);

	private:
	QColor			color;
	int				border_width;
};

class CColorGroupWidget;
class CBasePaletteDialog;

class CColorRoleWidget: public CFrameFc
{
	Q_OBJECT
	public:
	CColorRoleWidget(CColorGroupWidget *parent, QColorGroup::ColorRole id);
	virtual ~CColorRoleWidget();

	CAuxiliaryColorView		*GetAuxiliaryColorView();

	void	InitializeColorRole();
	void	SetPrecalculatedColor(const QColor &c);
	void	SetColorSpecifier(CPaletteData::SColorSpecifier *cs);
	void	SetActivateIndicator(bool a);

	QColorGroup::ColorRole	GetRoleId() { return role_id; }

	virtual void    setFont(const QFont &f);

	public slots:
	void	ResetColor();
	void	SelectAndActivateColor();
	void    ActivateToggled(bool on);

	private:
	QCheckBox				*activate_check_box;
	CColorResetButton		*color_reset_button;
	CPushButtonFc			*color_selection_button;
	CColorDisplayWidget		*color_display_widget;

	CColorGroupWidget				*color_group_widget;
	QColorGroup::ColorRole  		role_id;
	CPaletteData::SColorSpecifier	*color_specifier;
	QColor							precalculate_color;
};

class CColorGroupWidget: public CFrameFc
{
	Q_OBJECT
	public:
	CColorGroupWidget(	QWidget *parent,
						CBasePaletteDialog *bpd,
						QPalette::ColorGroup id);
	virtual ~CColorGroupWidget() { }

	CAuxiliaryColorView		*GetAuxiliaryColorView();

	void	InitializeColorGroup();
	void	SetPrecalculatedColor(const QPalette &p);
	void	SetColorSpecifier(	QColorGroup::ColorRole role_id,
								CPaletteData::SColorSpecifier *cs);
	void	StoreColorSpecifier(QColorGroup::ColorRole role_id,
								CPaletteData::SColorSpecifier *cs);

	virtual void    setFont(const QFont &f);

	private:
	CColorRoleWidget		*background_color_role_widget;
	CColorRoleWidget		*foreground_color_role_widget;
	CColorRoleWidget		*base_color_role_widget;
	CColorRoleWidget		*text_color_role_widget;
	CColorRoleWidget		*button_color_role_widget;
	CColorRoleWidget		*button_text_color_role_widget;
	CColorRoleWidget		*light_color_role_widget;
	CColorRoleWidget		*midlight_color_role_widget;
	CColorRoleWidget		*dark_color_role_widget;
	CColorRoleWidget		*mid_color_role_widget;
	CColorRoleWidget		*shadow_color_role_widget;
	CColorRoleWidget		*highlight_color_role_widget;
	CColorRoleWidget		*highlighted_text_color_role_widget;
	CColorRoleWidget		*bright_text_color_role_widget;
	CColorRoleWidget		*link_color_role_widget;
	CColorRoleWidget		*link_visited_color_role_widget;

	CBasePaletteDialog		*base_palette_dialog;
	QPalette::ColorGroup	group_id;
};

class CBasePaletteDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CBasePaletteDialog(QWidget *parent);
	virtual ~CBasePaletteDialog();

	void    SetAuxiliaryColorView(CAuxiliaryColorView *acv)
	{ auxiliary_color_view = acv; }
	CAuxiliaryColorView		*GetAuxiliaryColorView()
	{ return auxiliary_color_view; }

	void	StoreColorSpecifier(QPalette::ColorGroup group_id,
								QColorGroup::ColorRole role_id,
								CPaletteData::SColorSpecifier *cs);

	void	SetNamePointer(string *p)	{ name_pointer = p; }
	void	SetValuePointer(CPaletteData **p)
	{ value_pointer = p; }
	bool	GetNameChangedFlag()		{ return name_changed_flag; }
	bool	GetValueChangedFlag()		{ return value_changed_flag; }

	void	SetTitleAndResize(const string &title);
	void	SetPaletteValue(CPaletteData *v);
	void	StorePaletteValue(CPaletteData **p);

	virtual void    setFont(const QFont &f);

	public slots:
	virtual void	AcceptOperation() = 0;
	void			CancelOperation();
	void			ResetColors();
	void    		PrecalculatedToggled(bool on);
	void			SelectPrecalculatedButtonColor();
	void			SelectPrecalculatedBackgroundColor();

	protected:
	string				*name_pointer;
	CPaletteData		**value_pointer;
	bool				name_changed_flag;
	bool				value_changed_flag;

	CPaletteData					*palette_data;
	CPaletteData::SColorSpecifier	*button_color_specifier;
	CPaletteData::SColorSpecifier	*background_color_specifier;
	CAuxiliaryColorView             *auxiliary_color_view;

	QTabWidget              *tab_widget;
	CColorGroupWidget		*active_color_group_widget;
	CColorGroupWidget		*inactive_color_group_widget;
	CColorGroupWidget		*disabled_color_group_widget;
	CDialogPaletteDemo		*dialog_palette_demo;
	QGridLayout     		*subgrid_layout1;
	CPushButtonFc			*reset_button;
	CHGroupBoxFc			*group_box;
	CCheckBoxFc				*precalculated_check_box;
	CPushButtonFc			*precalculated_button_button;
	CColorDisplayWidget		*precalculated_button_color;
	CPushButtonFc			*precalculated_background_button;
	CColorDisplayWidget		*precalculated_background_color;
	QGridLayout     		*subgrid_layout2;
	CLabelFc				*name_label;
	CPushButtonFc			*ok_button;
	CPushButtonFc			*cancel_button;
};

class CAuxiliaryPaletteDialog: public CBasePaletteDialog
{
	Q_OBJECT
	public:
	CAuxiliaryPaletteDialog(QWidget *parent);
	virtual ~CAuxiliaryPaletteDialog() { }

	void	SetNameLineEdit(const QString &n);

	virtual void    setFont(const QFont &f);

	public slots:
	virtual void	AcceptOperation();
	void			NameChanged(const QString &s);

	protected:
	CLineEditFc		*name_line_edit;
};

class CMainviewTreePaletteDialog: public CBasePaletteDialog
{
	Q_OBJECT
	public:
	CMainviewTreePaletteDialog(QWidget *parent);
	virtual ~CMainviewTreePaletteDialog() { }

	void    SetNameComboBox(CAuxiliaryPaletteView *apv);

	virtual void    setFont(const QFont &f);

	public slots:
	virtual void	AcceptOperation();
	void			AddAuxiliaryPalette();
	void			NameSelected(const QString &s);

	protected:
	CComboBoxFc		*name_combo_box;
	CPushButtonFc	*add_auxiliary_button;

	CAuxiliaryPaletteView		*auxiliary_palette_view;

	void	UpdateComboBox(string *s);
};

class CXpmImageDisplayWidget: public QWidget
{
	Q_OBJECT
	public:
	CXpmImageDisplayWidget(QWidget *parent, int bw,
							QColor bg = QColor(0, 0, 0, QColor::Rgb));
	virtual ~CXpmImageDisplayWidget() { }

	void			SetXpmImage(CXpmImage *x);
	void            CalculateGeometry();

	protected:
	virtual void	paintEvent(QPaintEvent *e);

	private:
	int				border_width;
	QColor			background;
	CXpmImage		*xpm_image;
	void			DrawXpmImage();
};

class CBrushDisplayWidget: public QWidget
{
	Q_OBJECT
	public:
	CBrushDisplayWidget(QWidget *parent,
						int bw,
						const QString &s = QString(""),
						QColor bg = QColor(0, 0, 0, QColor::Rgb));
	virtual ~CBrushDisplayWidget() { }

	void			SetBrush(CPaletteData::SBrushSpecifier *bs);
	void            CalculateGeometry();
	virtual void    setFont(const QFont &f);

	protected:
	virtual void	paintEvent(QPaintEvent *e);

	private:
	int				border_width;
	QString			size_string;
	QColor			background;
	QBrush			brush;
	void			DrawBrush();
};

class CBaseXpmImageDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CBaseXpmImageDialog(QWidget *parent);
	virtual ~CBaseXpmImageDialog();

	void	SetNamePointer(string *p)		{ name_pointer = p; }
	void	SetValuePointer(CXpmImage **p)	{ value_pointer = p; }
	bool	GetNameChangedFlag()			{ return name_changed_flag; }
	bool	GetValueChangedFlag()			{ return value_changed_flag; }

	void	SetTitleAndResize(const string &title);
	void	SetXpmImageValue(CXpmImage *v);
	void	StoreXpmImageValue(CXpmImage **p);
	void	SetXpmData();

	virtual void    setFont(const QFont &f);

	public slots:
	virtual void	AcceptOperation() = 0;
	void			CancelOperation();
	void			DisplayXpmImage();
	void			LoadFile();
	void    		SaveFile();

	protected:
	string			*name_pointer;
	CXpmImage		**value_pointer;
	bool			name_changed_flag;
	bool			value_changed_flag;

	CXpmImage		*xpm_image;

	CMultiLineEditFc		*xpm_data_multi_line_edit;
	CXpmImageDisplayWidget	*xpm_image_display_widget1;
	CXpmImageDisplayWidget	*xpm_image_display_widget2;
	QGridLayout     		*subgrid_layout1;
	CPushButtonFc			*display_xpm_image_button;
	CPushButtonFc			*load_file_button;
	CPushButtonFc			*save_file_button;
	CSpacerFc				*spacer;
	QGridLayout     		*subgrid_layout2;
	CLabelFc				*name_label;
	CPushButtonFc			*ok_button;
	CPushButtonFc			*cancel_button;
};

class CAuxiliaryXpmImageDialog: public CBaseXpmImageDialog
{
	Q_OBJECT
	public:
	CAuxiliaryXpmImageDialog(QWidget *parent);
	virtual ~CAuxiliaryXpmImageDialog() { }

	void	SetNameLineEdit(const QString &n);

	virtual void    setFont(const QFont &f);

	public slots:
	virtual void	AcceptOperation();
	void			NameChanged(const QString &s);

	protected:
	CLineEditFc		*name_line_edit;
};

class CBrushXpmImageDialog: public CBaseXpmImageDialog
{
	Q_OBJECT
	public:
	CBrushXpmImageDialog(QWidget *parent);
	virtual ~CBrushXpmImageDialog() { }

	void    SetNameComboBox(CAuxiliaryXpmImageView *axiv);

	virtual void    setFont(const QFont &f);

	public slots:
	virtual void	AcceptOperation();
	void			AddAuxiliaryXpmImage();
	void			NameSelected(const QString &s);

	protected:
	CComboBoxFc		*name_combo_box;
	CPushButtonFc	*add_auxiliary_button;

	CAuxiliaryXpmImageView		*auxiliary_xpm_image_view;

	void	UpdateComboBox(string *s);
};

class CAuxiliaryBrushDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CAuxiliaryBrushDialog(QWidget *parent);
	virtual ~CAuxiliaryBrushDialog();

	void    SetAuxiliaryColorView(CAuxiliaryColorView *acv)
	{ auxiliary_color_view = acv; }
	CAuxiliaryColorView		*GetAuxiliaryColorView()
	{ return auxiliary_color_view; }

	void    SetAuxiliaryXpmImageView(CAuxiliaryXpmImageView *axiv)
	{ auxiliary_xpm_image_view = axiv; }
	CAuxiliaryXpmImageView	*GetAuxiliaryXpmImageView()
	{ return auxiliary_xpm_image_view; }

	void	SetNamePointer(string *p)	{ name_pointer = p; }
	void	SetValuePointer(CPaletteData::SBrushSpecifier **p)
	{ value_pointer = p; }
	bool	GetNameChangedFlag()		{ return name_changed_flag; }
	bool	GetValueChangedFlag()		{ return value_changed_flag; }

	void	SetNameLineEdit(const QString &n);
	void	SetTitleAndResize(const string &title);
	void	SetBrushValue(CPaletteData::SBrushSpecifier *v);
	void	StoreBrushValue(CPaletteData::SBrushSpecifier **p);
	void	CreateNewBrush();

	virtual void    setFont(const QFont &f);

	public slots:
	void	AcceptOperation();
	void	CancelOperation();
	void	SelectStyle(int id);
	void	SelectBrushColor();
	void	SelectXpmImage();
	void	NameChanged(const QString &s);

	protected:
	string							*name_pointer;
	CPaletteData::SBrushSpecifier	**value_pointer;
	bool							name_changed_flag;
	bool							value_changed_flag;

	CPaletteData::SBrushSpecifier	*brush_data;
	Qt::BrushStyle					brush_style;
	CPaletteData::SColorSpecifier	*color_specifier;
	CXpmImage						*xpm_image;
	CAuxiliaryColorView             *auxiliary_color_view;
	CAuxiliaryXpmImageView			*auxiliary_xpm_image_view;
	map<int, Qt::BrushStyle>		int_to_brush_style_map;
	map<Qt::BrushStyle, int>		brush_style_to_int_map;

	CButtonGroupFc			*brush_style_button_group;
	CRadioButtonFc			*nobrush_button;
	CRadioButtonFc			*solidpattern_button;
	CRadioButtonFc			*dense1pattern_button;
	CRadioButtonFc			*dense2pattern_button;
	CRadioButtonFc			*dense3pattern_button;
	CRadioButtonFc			*dense4pattern_button;
	CRadioButtonFc			*dense5pattern_button;
	CRadioButtonFc			*dense6pattern_button;
	CRadioButtonFc			*dense7pattern_button;
	CRadioButtonFc			*horpattern_button;
	CRadioButtonFc			*verpattern_button;
	CRadioButtonFc			*crosspattern_button;
	CRadioButtonFc			*bdiagpattern_button;
	CRadioButtonFc			*fdiagpattern_button;
	CRadioButtonFc			*diagcrosspattern_button;
	CRadioButtonFc			*custompattern_button;
	CBrushDisplayWidget		*brush_display_widget1;
	CBrushDisplayWidget		*brush_display_widget2;
	CPushButtonFc			*brush_color_button;
	CColorDisplayWidget		*color_display_widget;
	CPushButtonFc			*brush_xpm_image_button;
	CXpmImageDisplayWidget	*xpm_image_display_widget;
	QGridLayout     		*subgrid_layout;
	CLabelFc				*name_label;
	CLineEditFc				*name_line_edit;
	CPushButtonFc			*ok_button;
	CPushButtonFc			*cancel_button;
};

class CSizePositionDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CSizePositionDialog(QWidget *parent);
	virtual ~CSizePositionDialog() { }

	void	SetInterfaceIdAndNameVector(vector< pair<int, string> > *v);
	void	SetResetDataFlagPointer(bool *b)
	{ reset_data_flag_pointer = b; }
	void	SetCaptureApplicationFlagPointer(bool *b)
	{ capture_application_flag_pointer = b; }
	void	SetCaptureHelpFlagPointer(bool *b)
	{ capture_help_flag_pointer = b; }
	void	SetSelectedIdVectorPointer(vector<int> *v)
	{ selected_id_vector_pointer = v; }

	void	SetTitleAndResize(const string &title);

	struct SOptionFileItem: public Q3ListBoxText
	{
		SOptionFileItem(Q3ListBox *listbox, const string &ofn, int id)
			: Q3ListBoxText(listbox, ofn.c_str()), interface_id(id) { }

		int		interface_id;
	};

	virtual void    setFont(const QFont &f);

	public slots:
	void	AcceptOperation();
	void	ResetDataToggled(bool on);

	protected:
	bool				*reset_data_flag_pointer;
	bool				*capture_application_flag_pointer;
	bool				*capture_help_flag_pointer;
	vector<int>			*selected_id_vector_pointer;

	QGridLayout			*subgrid_layout1;
	CSpacerFc			*spacer1;
	CCheckBoxFc			*reset_data_check_box;
	QGridLayout			*subgrid_layout2;
	CSpacerFc			*spacer2;
	CCheckBoxFc			*application_check_box;
	QGridLayout			*subgrid_layout3;
	CSpacerFc			*spacer3;
	CCheckBoxFc			*help_check_box;
	QGridLayout			*subgrid_layout4;
	CSpacerFc			*spacer4;
	CLabelFc			*option_file_label;
	CListBoxFc			*option_file_listbox;
	CSpacerFc			*spacer5;
	CPushButtonFc		*ok_button;
	CPushButtonFc		*cancel_button;
};

#endif
