/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "optionParserDriver.h"


COptionParserDriver::COptionParserDriver()
    : CParserDriver(
        Option_Terminal_Count_E,
        Option_Symbol_Count_A,
        Option_Rule_Count_A,
        Option_Parser_Empty_Symbol_Token,
        Option_Shift_Action,
        Option_Accept_Action,
        Option_Conflict_Entry,
        Option_State_Count,
        Option_Number_Of_Conflict_Entries,
        Option_Number_Of_Error_Indexes,
        Option_Action_Table,
        Option_Goto_Table,
        Option_Rule_Left_Symbol_Table,
        Option_Rule_Right_Length_Table)
{
    reduce_functions =
    new (int (COptionParserDriver::*[Option_Rule_Count_A - 1])(void *));

    error_functions =
    new (void (COptionParserDriver::*[Option_Number_Of_Error_Indexes + 1])());

    SetupFunctionTables();

}

COptionParserDriver::~COptionParserDriver()
{
    delete [] reduce_functions;
    delete [] error_functions;

}

int     COptionParserDriver::CallReduceFunction(int action, void *data)
{
    return (this->*reduce_functions[action])(data);
}

void    COptionParserDriver::CallConflictFunction(int index)
{
    (this->*conflict_functions[index])();
}

void    COptionParserDriver::CallErrorFunction(int index)
{
    (this->*error_functions[index])();
}

void    COptionParserDriver::DeleteGeneratedCode(CStackElement *s, int c)
{
    for (int i=c-1; i>=0; i--)
    {
        CStackElement   &se = s[i];

        if (se.type == StackCharArray)
            delete [] se.char_array;
        else if (se.type == StackData)
            (this->*reduce_functions[se.reduce_action])(se.data);
    }
}

//  rule reduce function definitions for COptionParserDriver

//  00    start            ->  application  help
//
int     COptionParserDriver::Reduce_00(void *data)
{
	if (!data)
	{
		COptionData		*d = new COptionData();

		COptionData::SApplicationData	*ad =
			(COptionData::SApplicationData *)STACK_DATA(0);

		COptionData::SHelpData	*hd =
			(COptionData::SHelpData *)STACK_DATA(1);

		d->SetApplicationData(ad);
		d->SetHelpData(hd);

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = d;
	}
	else
		delete (COptionData *)data;

	return 0;
}

//  01    start            ->  start  main_view
//
int     COptionParserDriver::Reduce_01(void *data)
{
	if (!data)
	{
		COptionData		*d = (COptionData *)STACK_DATA(0);

		COptionData::SMainViewData	*mv =
			(COptionData::SMainViewData *)STACK_DATA(1);

		d->AddMainViewPtr(mv);
	}
	else
		delete (COptionData *)data;

	return 0;
}

//  02    start            ->  start  AUXILIARY_PALETTE  identifier  palette
//
int     COptionParserDriver::Reduce_02(void *data)
{
	if (!data)
	{
		COptionData		*d	= (COptionData *)STACK_DATA(0);
		const char		*id	= (const char *)STACK_CHAR_ARRAY(2);
		CPaletteData	*p	= (CPaletteData *)STACK_DATA(3);

		d->AddAuxiliaryPalette(string(id), p);
	}
	else
		delete (COptionData *)data;

	return 0;
}

//  03    start            ->  start  AUXILIARY_COLOR  identifier  color_specifier
//
int     COptionParserDriver::Reduce_03(void *data)
{
	if (!data)
	{
		COptionData		*d	= (COptionData *)STACK_DATA(0);
		const char		*id	= (const char *)STACK_CHAR_ARRAY(2);
		CPaletteData::SColorSpecifier	*cs =
								(CPaletteData::SColorSpecifier *)STACK_DATA(3);

		d->AddAuxiliaryColor(string(id), cs);
	}
	else
		delete (COptionData *)data;

	return 0;
}

//  04    start            ->  start  AUXILIARY_BRUSH  identifier  brush
//
int     COptionParserDriver::Reduce_04(void *data)
{
	if (!data)
	{
		COptionData		*d	= (COptionData *)STACK_DATA(0);
		const char		*id	= (const char *)STACK_CHAR_ARRAY(2);
		CPaletteData::SBrushSpecifier	*bs =
								(CPaletteData::SBrushSpecifier *)STACK_DATA(3);

		d->AddAuxiliaryBrush(string(id), bs);
	}
	else
		delete (COptionData *)data;

	return 0;
}

//  05    start            ->  start  AUXILIARY_XPM_IMAGE  identifier  xpm_image
//
int     COptionParserDriver::Reduce_05(void *data)
{
	if (!data)
	{
		COptionData		*d	= (COptionData *)STACK_DATA(0);
		const char		*id	= (const char *)STACK_CHAR_ARRAY(2);
		CXpmImage		*xi = (CXpmImage *)STACK_DATA(3);

		d->AddAuxiliaryXpmImage(string(id), xi);
	}
	else
		delete (COptionData *)data;

	return 0;
}

//  06    start            ->  start  AUXILIARY_FONT  identifier  identifier
//
int     COptionParserDriver::Reduce_06(void *data)
{
	if (!data)
	{
		COptionData		*d	= (COptionData *)STACK_DATA(0);
		const char		*id	= (const char *)STACK_CHAR_ARRAY(2);
		const char		*fs	= (const char *)STACK_CHAR_ARRAY(3);

		d->AddAuxiliaryFont(string(id), string(fs));
	}
	else
		delete (COptionData *)data;

	return 0;
}

//  07    start            ->  start  AUXILIARY_STRING  identifier  identifier
//
int     COptionParserDriver::Reduce_07(void *data)
{
	if (!data)
	{
		COptionData		*d	= (COptionData *)STACK_DATA(0);
		const char		*id	= (const char *)STACK_CHAR_ARRAY(2);
		const char		*s	= (const char *)STACK_CHAR_ARRAY(3);

		d->AddAuxiliaryString(string(id), string(s));
	}
	else
		delete (COptionData *)data;

	return 0;
}

//  08    application      ->  APPLICATION
//
int     COptionParserDriver::Reduce_08(void *data)
{
	if (!data)
	{
		COptionData::SApplicationData	*ad =
			new COptionData::SApplicationData();

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = ad;
	}
	else
		delete (COptionData::SApplicationData *)data;

	return 0;
}

//  09    application      ->  application  position
//
int     COptionParserDriver::Reduce_09(void *data)
{
	if (!data)
	{
		COptionData::SApplicationData	*ad =
			(COptionData::SApplicationData *)STACK_DATA(0);

		QPoint	*p = (QPoint *)STACK_DATA(1);

		ad->SetPosition(*p);

		delete p;
	}
	else
		delete (COptionData::SApplicationData *)data;

	return 0;
}

//  10    application      ->  application  size
//
int     COptionParserDriver::Reduce_10(void *data)
{
	if (!data)
	{
		COptionData::SApplicationData	*ad =
			(COptionData::SApplicationData *)STACK_DATA(0);

		QSize	*s = (QSize *)STACK_DATA(1);

		ad->SetSize(*s);

		delete s;
	}
	else
		delete (COptionData::SApplicationData *)data;

	return 0;
}

//  11    application      ->  application  font
//
int     COptionParserDriver::Reduce_11(void *data)
{
	if (!data)
	{
		COptionData::SApplicationData	*ad =
			(COptionData::SApplicationData *)STACK_DATA(0);

		ad->SetFontString(string((const char *)STACK_CHAR_ARRAY(1)));

		delete [] STACK_CHAR_ARRAY(1);
	}
	else
		delete (COptionData::SApplicationData *)data;

	return 0;
}

//  12    application      ->  application  palette
//
int     COptionParserDriver::Reduce_12(void *data)
{
	if (!data)
	{
		COptionData::SApplicationData	*ad =
			(COptionData::SApplicationData *)STACK_DATA(0);

		CPaletteData	*p = (CPaletteData *)STACK_DATA(1);

		ad->SetPaletteData(p);
	}
	else
		delete (COptionData::SApplicationData *)data;

	return 0;
}

//  13    help             ->  HELP
//
int     COptionParserDriver::Reduce_13(void *data)
{
	if (!data)
	{
		COptionData::SHelpData	*hd = new COptionData::SHelpData();

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = hd;
	}
	else
		delete (COptionData::SHelpData *)data;

	return 0;
}

//  14    help             ->  help  position
//
int     COptionParserDriver::Reduce_14(void *data)
{
	if (!data)
	{
		COptionData::SHelpData	*hd =
			(COptionData::SHelpData *)STACK_DATA(0);

		QPoint	*p = (QPoint *)STACK_DATA(1);

		hd->SetPosition(*p);

		delete p;
	}
	else
		delete (COptionData::SHelpData *)data;

	return 0;
}

//  15    help             ->  help  size
//
int     COptionParserDriver::Reduce_15(void *data)
{
	if (!data)
	{
		COptionData::SHelpData	*hd =
			(COptionData::SHelpData *)STACK_DATA(0);

		QSize	*s = (QSize *)STACK_DATA(1);

		hd->SetSize(*s);

		delete s;
	}
	else
		delete (COptionData::SHelpData *)data;

	return 0;
}

//  16    help             ->  help  font
//
int     COptionParserDriver::Reduce_16(void *data)
{
	if (!data)
	{
		COptionData::SHelpData	*hd =
			(COptionData::SHelpData *)STACK_DATA(0);

		hd->SetFontString(string((const char *)STACK_CHAR_ARRAY(1)));

		delete [] STACK_CHAR_ARRAY(1);
	}
	else
		delete (COptionData::SHelpData *)data;

	return 0;
}

//  17    help             ->  help  palette
//
int     COptionParserDriver::Reduce_17(void *data)
{
	if (!data)
	{
		COptionData::SHelpData	*hd =
			(COptionData::SHelpData *)STACK_DATA(0);

		CPaletteData	*p = (CPaletteData *)STACK_DATA(1);

		hd->SetPaletteData(p);
	}
	else
		delete (COptionData::SHelpData *)data;

	return 0;
}

//  18    main_view        ->  MAIN_VIEW  identifier
//
int     COptionParserDriver::Reduce_18(void *data)
{
	if (!data)
	{
		COptionData::SMainViewData	*mv = new COptionData::SMainViewData();

		mv->SetMainViewName(string((const char *)STACK_CHAR_ARRAY(1)));

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = mv;

		delete [] STACK_CHAR_ARRAY(1);
	}
	else
		delete (COptionData::SMainViewData *)data;

	return 0;
}

//  19    main_view        ->  main_view  DEFAULT_DISPLAY
//
int     COptionParserDriver::Reduce_19(void *data)
{
	if (!data)
	{
		COptionData::SMainViewData	*mv =
			(COptionData::SMainViewData *)STACK_DATA(0);

		mv->SetDefaultDisplayFlag(true);
	}
	else
		delete (COptionData::SMainViewData *)data;

	return 0;
}

//  20    main_view        ->  main_view  position
//
int     COptionParserDriver::Reduce_20(void *data)
{
	if (!data)
	{
		COptionData::SMainViewData	*mv =
			(COptionData::SMainViewData *)STACK_DATA(0);

		QPoint	*p = (QPoint *)STACK_DATA(1);

		mv->SetPosition(*p);

		delete p;
	}
	else
		delete (COptionData::SMainViewData *)data;

	return 0;
}

//  21    main_view        ->  main_view  size
//
int     COptionParserDriver::Reduce_21(void *data)
{
	if (!data)
	{
		COptionData::SMainViewData	*mv =
			(COptionData::SMainViewData *)STACK_DATA(0);

		QSize	*s = (QSize *)STACK_DATA(1);

		mv->SetSize(*s);

		delete s;
	}
	else
		delete (COptionData::SMainViewData *)data;

	return 0;
}

//  22    main_view        ->  main_view  splitter
//
int     COptionParserDriver::Reduce_22(void *data)
{
	if (!data)
	{
		COptionData::SMainViewData	*mv =
			(COptionData::SMainViewData *)STACK_DATA(0);

		COptionData::SSplitterData	*sd =
			(COptionData::SSplitterData	*)STACK_DATA(1);

		mv->AddViewNodeDataPtr(sd);
	}
	else
		delete (COptionData::SMainViewData *)data;

	return 0;
}

//  23    main_view        ->  main_view  subview
//
int     COptionParserDriver::Reduce_23(void *data)
{
	if (!data)
	{
		COptionData::SMainViewData	*mv =
			(COptionData::SMainViewData *)STACK_DATA(0);

		COptionData::SSubViewData	*sd =
			(COptionData::SSubViewData *)STACK_DATA(1);

		mv->AddViewNodeDataPtr(sd);
	}
	else
		delete (COptionData::SMainViewData *)data;

	return 0;
}

//  24    splitter         ->  SPLITTER
//
int     COptionParserDriver::Reduce_24(void *data)
{
	if (!data)
	{
		COptionData::SSplitterData	*sd = new COptionData::SSplitterData();

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = sd;
	}
	else
		delete (COptionData::SSplitterData *)data;

	return 0;
}

//  25    splitter         ->  splitter  index
//
int     COptionParserDriver::Reduce_25(void *data)
{
	if (!data)
	{
		COptionData::SSplitterData	*sd =
			(COptionData::SSplitterData *)STACK_DATA(0);

		sd->SetIndex((vector<int> *)STACK_DATA(1));
	}
	else
		delete (COptionData::SSplitterData *)data;

	return 0;
}

//  26    splitter         ->  splitter  orientation
//
int     COptionParserDriver::Reduce_26(void *data)
{
	if (!data)
	{
		COptionData::SSplitterData	*sd =
			(COptionData::SSplitterData *)STACK_DATA(0);

		sd->SetOrientation((Qt::Orientation)STACK_INT(1));
	}
	else
		delete (COptionData::SSplitterData *)data;

	return 0;
}

//  27    splitter         ->  splitter  pane_size
//
int     COptionParserDriver::Reduce_27(void *data)
{
	if (!data)
	{
		COptionData::SSplitterData	*sd =
			(COptionData::SSplitterData *)STACK_DATA(0);

		sd->SetPaneSize((vector<int> *)STACK_DATA(1));
	}
	else
		delete (COptionData::SSplitterData *)data;

	return 0;
}

//  28    splitter         ->  splitter  font
//
int     COptionParserDriver::Reduce_28(void *data)
{
	if (!data)
	{
		COptionData::SSplitterData	*sd =
			(COptionData::SSplitterData *)STACK_DATA(0);

		sd->SetFontString(string((const char *)STACK_CHAR_ARRAY(1)));

		delete [] STACK_CHAR_ARRAY(1);
	}
	else
		delete (COptionData::SSplitterData *)data;

	return 0;
}

//  29    splitter         ->  splitter  palette
//
int     COptionParserDriver::Reduce_29(void *data)
{
	if (!data)
	{
		COptionData::SSplitterData	*sd =
			(COptionData::SSplitterData *)STACK_DATA(0);

		CPaletteData	*p = (CPaletteData *)STACK_DATA(1);

		sd->SetPaletteData(p);
	}
	else
		delete (COptionData::SSplitterData *)data;

	return 0;
}

//  30    orientation      ->  ORIENTATION  STRING
//
int     COptionParserDriver::Reduce_30(void *data)
{
	if (!data)
	{
		STACK_TYPE(0) = STACK_TYPE_SCALAR;

		if (!strcmp((const char *)STACK_CHAR_ARRAY(1), "Horizontal"))
			STACK_INT(0) = Qt::Horizontal;
		else if (!strcmp((const char *)STACK_CHAR_ARRAY(1), "Vertical"))
			STACK_INT(0) = Qt::Vertical;
		else
			STACK_INT(0) = Qt::Horizontal;

		delete [] STACK_CHAR_ARRAY(1);
	}

	return 0;
}

//  31    pane_size        ->  PANE_SIZE
//
int     COptionParserDriver::Reduce_31(void *data)
{
	if (!data)
	{
		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = new vector<int>;
	}
	else
		delete (vector<int> *)data;

	return 0;
}

//  32    pane_size        ->  pane_size  INTEGER
//
int     COptionParserDriver::Reduce_32(void *data)
{
	if (!data)
	{
		((vector<int> *)STACK_DATA(0))->push_back(STACK_INT(1));
	}
	else
		delete (vector<int> *)data;

	return 0;
}

//  33    subview          ->  SUBVIEW  identifier
//
int     COptionParserDriver::Reduce_33(void *data)
{
	if (!data)
	{
		COptionData::SSubViewData	*sv = new COptionData::SSubViewData();

		sv->SetSubViewName(string((const char *)STACK_CHAR_ARRAY(1)));

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = sv;

		delete [] STACK_CHAR_ARRAY(1);
	}
	else
		delete (COptionData::SSubViewData *)data;

	return 0;
}

//  34    subview          ->  subview  index
//
int     COptionParserDriver::Reduce_34(void *data)
{
	if (!data)
	{
		COptionData::SSubViewData	*sv =
			(COptionData::SSubViewData *)STACK_DATA(0);

		sv->SetIndex((vector<int> *)STACK_DATA(1));
	}
	else
		delete (COptionData::SSubViewData *)data;

	return 0;
}

//  35    subview          ->  subview  font
//
int     COptionParserDriver::Reduce_35(void *data)
{
	if (!data)
	{
		COptionData::SSubViewData	*sv =
			(COptionData::SSubViewData *)STACK_DATA(0);

		sv->SetFontString(string((const char *)STACK_CHAR_ARRAY(1)));

		delete [] STACK_CHAR_ARRAY(1);
	}
	else
		delete (COptionData::SSubViewData *)data;

	return 0;
}

//  36    subview          ->  subview  palette
//
int     COptionParserDriver::Reduce_36(void *data)
{
	if (!data)
	{
		COptionData::SSubViewData	*sv =
			(COptionData::SSubViewData *)STACK_DATA(0);

		CPaletteData	*p = (CPaletteData *)STACK_DATA(1);

		sv->SetPaletteData(p);
	}
	else
		delete (COptionData::SSubViewData *)data;

	return 0;
}

//  37    subview          ->  subview  interface
//
int     COptionParserDriver::Reduce_37(void *data)
{
	if (!data)
	{
		COptionData::SSubViewData	*sv =
			(COptionData::SSubViewData *)STACK_DATA(0);

		COptionData::SSubViewData::SInterfaceSpecifier	*is =
			(COptionData::SSubViewData::SInterfaceSpecifier	*)STACK_DATA(1);

		sv->AddInterfaceSpecifier(is);
	}
	else
		delete (COptionData::SSubViewData *)data;

	return 0;
}

//  38    interface        ->  INTERFACE  SCOPE  identifier
//
int     COptionParserDriver::Reduce_38(void *data)
{
	if (!data)
	{
		COptionData::SSubViewData::SInterfaceSpecifier	*is =
			new COptionData::SSubViewData::SInterfaceSpecifier();

		is->SetSubViewName(string((const char *)STACK_CHAR_ARRAY(2)));

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = is;

		delete [] STACK_CHAR_ARRAY(2);
	}
	else
		delete (COptionData::SSubViewData::SInterfaceSpecifier *)data;

	return 0;
}

//  39    interface        ->  INTERFACE  identifier  SCOPE  identifier
//
int     COptionParserDriver::Reduce_39(void *data)
{
	if (!data)
	{
		COptionData::SSubViewData::SInterfaceSpecifier	*is =
			new COptionData::SSubViewData::SInterfaceSpecifier();

		is->SetMainViewName(string((const char *)STACK_CHAR_ARRAY(1)));
		is->SetSubViewName(string((const char *)STACK_CHAR_ARRAY(3)));

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = is;

		delete [] STACK_CHAR_ARRAY(1);
		delete [] STACK_CHAR_ARRAY(3);
	}
	else
		delete (COptionData::SSubViewData::SInterfaceSpecifier *)data;

	return 0;
}

//  40    interface        ->  INTERFACE  identifier  SCOPE  index
//
int     COptionParserDriver::Reduce_40(void *data)
{
	if (!data)
	{
		COptionData::SSubViewData::SInterfaceSpecifier	*is =
			new COptionData::SSubViewData::SInterfaceSpecifier();

		is->SetMainViewName(string((const char *)STACK_CHAR_ARRAY(1)));
		is->SetIndex((vector<int> *)STACK_DATA(3));

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = is;

		delete [] STACK_CHAR_ARRAY(1);
	}
	else
		delete (COptionData::SSubViewData::SInterfaceSpecifier *)data;

	return 0;
}

//  41    index            ->  INDEX
//
int     COptionParserDriver::Reduce_41(void *data)
{
	if (!data)
	{
		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = new vector<int>;
	}
	else
		delete (vector<int> *)data;

	return 0;
}

//  42    index            ->  index  INTEGER
//
int     COptionParserDriver::Reduce_42(void *data)
{
	if (!data)
	{
		((vector<int> *)STACK_DATA(0))->push_back(STACK_INT(1));
	}
	else
		delete (vector<int> *)data;

	return 0;
}

//  43    identifier       ->  STRING
//
int     COptionParserDriver::Reduce_43(void *data)
{
	if (!data)
	{
	}
	else
		delete [] (unsigned char *)data;

	return 0;
}

//  44    identifier       ->  QUOTED_STRING
//
int     COptionParserDriver::Reduce_44(void *data)
{
	if (!data)
	{
	}
	else
		delete [] (unsigned char *)data;

	return 0;
}

//  45    position         ->  POSITION  INTEGER  INTEGER
//
int     COptionParserDriver::Reduce_45(void *data)
{
	if (!data)
	{
		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = new QPoint(STACK_INT(1), STACK_INT(2));
	}
	else
		delete (QPoint *)data;

	return 0;
}

//  46    size             ->  SIZE  INTEGER  INTEGER
//
int     COptionParserDriver::Reduce_46(void *data)
{
	if (!data)
	{
		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = new QSize(STACK_INT(1), STACK_INT(2));
	}
	else
		delete (QSize *)data;

	return 0;
}

//  47    font             ->  FONT  identifier
//
int     COptionParserDriver::Reduce_47(void *data)
{
	if (!data)
	{
		STACK_TYPE(0)		= STACK_TYPE_CHARARRAY;
		STACK_CHAR_ARRAY(0)	= STACK_CHAR_ARRAY(1);
	}
	else
		delete [] (unsigned char *)data;

	return 0;
}

//  48    palette          ->  PALETTE
//
int     COptionParserDriver::Reduce_48(void *data)
{
	if (!data)
	{
		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = new CPaletteData();
	}
	else
		delete (CPaletteData *)data;

	return 0;
}

//  49    palette          ->  palette  BUTTON_COLOR  color_specifier
//
int     COptionParserDriver::Reduce_49(void *data)
{
	if (!data)
	{
		CPaletteData	*p	= (CPaletteData *)STACK_DATA(0);
		CPaletteData::SColorSpecifier	*cs =
								(CPaletteData::SColorSpecifier *)STACK_DATA(2);

		p->SetPrecalculateButtonColor(cs);
	}
	else
		delete (CPaletteData *)data;

	return 0;
}

//  50    palette          ->  palette  BACKGROUND_COLOR  color_specifier
//
int     COptionParserDriver::Reduce_50(void *data)
{
	if (!data)
	{
		CPaletteData	*p	= (CPaletteData *)STACK_DATA(0);
		CPaletteData::SColorSpecifier	*cs =
								(CPaletteData::SColorSpecifier *)STACK_DATA(2);

		p->SetPrecalculateBackgroundColor(cs);
	}
	else
		delete (CPaletteData *)data;

	return 0;
}

//  51    palette          ->  palette  GROUP_ROLE  STRING  STRING  brush
//
int     COptionParserDriver::Reduce_51(void *data)
{
	if (!data)
	{
		CPaletteData	*p	= (CPaletteData *)STACK_DATA(0);
		const char		*g	= (const char *)STACK_CHAR_ARRAY(2);
		const char		*r	= (const char *)STACK_CHAR_ARRAY(3);
		CPaletteData::SBrushSpecifier	*bs =
								(CPaletteData::SBrushSpecifier *)STACK_DATA(4);

		CPaletteData::SGroupRoleEntry			gre =
						CPaletteData::SGroupRoleEntry(string(g), string(r));

		CPaletteData::SBrushGroupRoleSpecifier	*grs =
						new CPaletteData::SBrushGroupRoleSpecifier(bs);

		p->SetGroupRoleSpecifier(gre, grs);

		delete [] STACK_CHAR_ARRAY(2);
		delete [] STACK_CHAR_ARRAY(3);
	}
	else
		delete (CPaletteData *)data;

	return 0;
}

//  52    palette          ->  palette  GROUP_ROLE  STRING  STRING  color_specifier
//
int     COptionParserDriver::Reduce_52(void *data)
{
	if (!data)
	{
		CPaletteData	*p	= (CPaletteData *)STACK_DATA(0);
		const char		*g	= (const char *)STACK_CHAR_ARRAY(2);
		const char		*r	= (const char *)STACK_CHAR_ARRAY(3);
		CPaletteData::SColorSpecifier	*cs =
								(CPaletteData::SColorSpecifier *)STACK_DATA(4);

		CPaletteData::SGroupRoleEntry			gre =
						CPaletteData::SGroupRoleEntry(string(g), string(r));

		CPaletteData::SColorGroupRoleSpecifier	*grs =
						new CPaletteData::SColorGroupRoleSpecifier(cs);

		p->SetGroupRoleSpecifier(gre, grs);

		delete [] STACK_CHAR_ARRAY(2);
		delete [] STACK_CHAR_ARRAY(3);
	}
	else
		delete (CPaletteData *)data;

	return 0;
}

//  53    brush            ->  BRUSH  color_specifier  STRING
//
int     COptionParserDriver::Reduce_53(void *data)
{
	if (!data)
	{
		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = new CPaletteData::SStyleBrushSpecifier(
								(CPaletteData::SColorSpecifier *)STACK_DATA(1),
								string((const char *)STACK_CHAR_ARRAY(2)));

		delete [] STACK_CHAR_ARRAY(2);
	}
	else
		delete (CPaletteData::SStyleBrushSpecifier *)data;

	return 0;
}

//  54    brush            ->  BRUSH  color_specifier  xpm_image
//
int     COptionParserDriver::Reduce_54(void *data)
{
	if (!data)
	{
		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = new CPaletteData::SXpmImageBrushSpecifier(
								(CPaletteData::SColorSpecifier *)STACK_DATA(1),
								(CXpmImage *)STACK_DATA(2));
	}
	else
		delete (CPaletteData::SXpmImageBrushSpecifier *)data;

	return 0;
}

//  55    color_specifier  ->  RGB  INTEGER  INTEGER  INTEGER
//
int     COptionParserDriver::Reduce_55(void *data)
{
	if (!data)
	{
		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = new CPaletteData::SRgbSpecifier
							(STACK_INT(1), STACK_INT(2), STACK_INT(3));
	}
	else
		delete (CPaletteData::SRgbSpecifier *)data;

	return 0;
}

//  56    color_specifier  ->  HSV  INTEGER  INTEGER  INTEGER
//
int     COptionParserDriver::Reduce_56(void *data)
{
	if (!data)
	{
		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = new CPaletteData::SHsvSpecifier
							(STACK_INT(1), STACK_INT(2), STACK_INT(3));
	}
	else
		delete (CPaletteData::SHsvSpecifier *)data;

	return 0;
}

//  57    color_specifier  ->  COLOR_NAME  identifier
//
int     COptionParserDriver::Reduce_57(void *data)
{
	if (!data)
	{
		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = new CPaletteData::SColorNameSpecifier
							(string((const char *)STACK_CHAR_ARRAY(1)));

		delete [] STACK_CHAR_ARRAY(1);
	}
	else
		delete (CPaletteData::SColorNameSpecifier *)data;

	return 0;
}

//  58    xpm_image        ->  XPM_IMAGE
//
int     COptionParserDriver::Reduce_58(void *data)
{
	if (!data)
	{
		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = new CXpmImage();
	}
	else
		delete (CXpmImage *)data;

	return 0;
}

//  59    xpm_image        ->  xpm_image  QUOTED_STRING
//
int     COptionParserDriver::Reduce_59(void *data)
{
	if (!data)
	{
		CXpmImage	*xi = (CXpmImage *)STACK_DATA(0);

		xi->PushBackXpmCharData((const char *)STACK_CHAR_ARRAY(1));

		delete [] STACK_CHAR_ARRAY(1);
	}
	else
		delete (CXpmImage *)data;

	return 0;
}

//  conflict function definitions for COptionParserDriver

//  error function definitions for COptionParserDriver

// inaccessible error
//
void    COptionParserDriver::Error_1()
{
}

// accessible error
//
void    COptionParserDriver::Error_2()
{
}

void    COptionParserDriver::SetupFunctionTables()
{
    reduce_functions[ 0] = &COptionParserDriver::Reduce_00;
    reduce_functions[ 1] = &COptionParserDriver::Reduce_01;
    reduce_functions[ 2] = &COptionParserDriver::Reduce_02;
    reduce_functions[ 3] = &COptionParserDriver::Reduce_03;
    reduce_functions[ 4] = &COptionParserDriver::Reduce_04;
    reduce_functions[ 5] = &COptionParserDriver::Reduce_05;
    reduce_functions[ 6] = &COptionParserDriver::Reduce_06;
    reduce_functions[ 7] = &COptionParserDriver::Reduce_07;
    reduce_functions[ 8] = &COptionParserDriver::Reduce_08;
    reduce_functions[ 9] = &COptionParserDriver::Reduce_09;
    reduce_functions[10] = &COptionParserDriver::Reduce_10;
    reduce_functions[11] = &COptionParserDriver::Reduce_11;
    reduce_functions[12] = &COptionParserDriver::Reduce_12;
    reduce_functions[13] = &COptionParserDriver::Reduce_13;
    reduce_functions[14] = &COptionParserDriver::Reduce_14;
    reduce_functions[15] = &COptionParserDriver::Reduce_15;
    reduce_functions[16] = &COptionParserDriver::Reduce_16;
    reduce_functions[17] = &COptionParserDriver::Reduce_17;
    reduce_functions[18] = &COptionParserDriver::Reduce_18;
    reduce_functions[19] = &COptionParserDriver::Reduce_19;
    reduce_functions[20] = &COptionParserDriver::Reduce_20;
    reduce_functions[21] = &COptionParserDriver::Reduce_21;
    reduce_functions[22] = &COptionParserDriver::Reduce_22;
    reduce_functions[23] = &COptionParserDriver::Reduce_23;
    reduce_functions[24] = &COptionParserDriver::Reduce_24;
    reduce_functions[25] = &COptionParserDriver::Reduce_25;
    reduce_functions[26] = &COptionParserDriver::Reduce_26;
    reduce_functions[27] = &COptionParserDriver::Reduce_27;
    reduce_functions[28] = &COptionParserDriver::Reduce_28;
    reduce_functions[29] = &COptionParserDriver::Reduce_29;
    reduce_functions[30] = &COptionParserDriver::Reduce_30;
    reduce_functions[31] = &COptionParserDriver::Reduce_31;
    reduce_functions[32] = &COptionParserDriver::Reduce_32;
    reduce_functions[33] = &COptionParserDriver::Reduce_33;
    reduce_functions[34] = &COptionParserDriver::Reduce_34;
    reduce_functions[35] = &COptionParserDriver::Reduce_35;
    reduce_functions[36] = &COptionParserDriver::Reduce_36;
    reduce_functions[37] = &COptionParserDriver::Reduce_37;
    reduce_functions[38] = &COptionParserDriver::Reduce_38;
    reduce_functions[39] = &COptionParserDriver::Reduce_39;
    reduce_functions[40] = &COptionParserDriver::Reduce_40;
    reduce_functions[41] = &COptionParserDriver::Reduce_41;
    reduce_functions[42] = &COptionParserDriver::Reduce_42;
    reduce_functions[43] = &COptionParserDriver::Reduce_43;
    reduce_functions[44] = &COptionParserDriver::Reduce_44;
    reduce_functions[45] = &COptionParserDriver::Reduce_45;
    reduce_functions[46] = &COptionParserDriver::Reduce_46;
    reduce_functions[47] = &COptionParserDriver::Reduce_47;
    reduce_functions[48] = &COptionParserDriver::Reduce_48;
    reduce_functions[49] = &COptionParserDriver::Reduce_49;
    reduce_functions[50] = &COptionParserDriver::Reduce_50;
    reduce_functions[51] = &COptionParserDriver::Reduce_51;
    reduce_functions[52] = &COptionParserDriver::Reduce_52;
    reduce_functions[53] = &COptionParserDriver::Reduce_53;
    reduce_functions[54] = &COptionParserDriver::Reduce_54;
    reduce_functions[55] = &COptionParserDriver::Reduce_55;
    reduce_functions[56] = &COptionParserDriver::Reduce_56;
    reduce_functions[57] = &COptionParserDriver::Reduce_57;
    reduce_functions[58] = &COptionParserDriver::Reduce_58;
    reduce_functions[59] = &COptionParserDriver::Reduce_59;


    error_functions[1] = &COptionParserDriver::Error_1;
    error_functions[2] = &COptionParserDriver::Error_2;
}
