/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef PARSE_H
#define PARSE_H

#include <string.h>

#include "memoryAllocator.h"
#include "tlist.h"
#include "tvaluelist.h"
#include "trelation.h"

class CSymbolInformation
{
	public:
	CSymbolInformation()
	{
		name				= 0;
		regexp				= 0;
		left_symbol_indexes	= 0;
		right_symbol_count	= 0;
		lr0_passes_x		= 0;
		lr0_transition		= 0;
		follows_count		= 0;
		follows_x			= 0;
		first_count			= 0;
		first_x				= 0;
		lr1_passes_x		= 0;
		lr1_transition		= 0;
	}

	~CSymbolInformation()
	{
		delete [] name;
		delete [] regexp;
		delete [] left_symbol_indexes;
		delete lr0_passes_x;
		delete lr0_transition;
		delete [] follows_x;
		delete [] first_x;
		delete lr1_passes_x;
		delete lr1_transition;
	}

	void	Initialize(	const char *n, bool f,
						int lsc, int *lsi,
						const char *r, bool l, bool e)
	{
		int	length = strlen(n);
		name = new char[length + 1];
		strcpy(name, n);

		nonterminal_flag = f;
		if (nonterminal_flag)
		{
			left_symbol_count = lsc;
			if (left_symbol_count)
			{
				left_symbol_indexes = new int[lsc];
				for (int i=0; i<lsc; i++)
					left_symbol_indexes[i] = lsi[i];
			}
		}
		else
		{
			length = strlen(r);
			regexp = new char[length + 1];
			strcpy(regexp, r);

			literal_flag	= l;
			error_flag		= e;
		}
	}

	char		*name;
	char		*regexp;
	int			left_symbol_count;
	int			*left_symbol_indexes;
	bool		nonterminal_flag;
	bool		literal_flag;
	bool		error_flag;
	int			right_symbol_count;
	RelationInt	*lr0_passes_x;
	RelationInt	*lr0_transition;
	int			follows_count;
	int			*follows_x;
	int			first_count;
	int			*first_x;
	RelationInt	*lr1_passes_x;
	RelationInt	*lr1_transition;
};

class CRuleInformation
{
	public:
	CRuleInformation() { right_symbol_indexes = 0; }
	~CRuleInformation() { delete [] right_symbol_indexes; }

	void	Initialize(int l, int rc, int *ri)
	{
		left_symbol_index = l;
		right_symbol_count = rc;
		right_symbol_indexes = new int[rc];
		for (int i=0; i<rc; i++)
			right_symbol_indexes[i] = ri[i];
	}

	int		left_symbol_index;
	int		right_symbol_count;
	int		*right_symbol_indexes;
	int		item_core_block_index;
};

class CSymbolStatus
{
	public:
	bool	derives_terminal_flag;
	bool	accessible_flag;
	bool	derives_empty_flag;
};

class CItemCore
{
	public:
	CItemCore() { }
	~CItemCore() { }

	void	Initialize(int ici, int ri, int di)
	{
		item_core_index					= ici;
		rule_index						= ri;
		right_symbol_after_dot_index	= di;
		reduce_item_flag				= false;
	}

	int		item_core_index;
	int		rule_index;
	int		right_symbol_after_dot_index;
	bool	reduce_item_flag;
	int		lr1_item_block_index;
};

class CLR1Item
{
	public:
	CLR1Item() { }

	void	Initialize(int lii, int ici, int lti)
	{
		lr1_item_index				= lii;
		item_core_index				= ici;
		lookahead_terminal_index	= lti;
	}

	int		lr1_item_index;
	int		item_core_index;
	int		lookahead_terminal_index;
};

class CLR0MachineState
{
	public:
	CLR0MachineState(int msi, VListInt *is)
	{
		machine_state_index	= msi;
		item_set			= is;
		state_transitions	= new VListOrdPairInt(10);
	}

	~CLR0MachineState()
	{
		delete item_set;
		delete state_transitions;
	}

	int					machine_state_index;
	VListInt			*item_set;
	VListOrdPairInt		*state_transitions;
};

typedef TList<CLR0MachineState>				ListLR0MS;
typedef TValueList<ListLR0MS::listptr>		VListListLR0MSptr;

typedef CLR0MachineState					CLR1MachineState;
typedef TList<CLR1MachineState>				ListLR1MS;
typedef TValueList<ListLR1MS::listptr>		VListListLR1MSptr;

class CItemIndexNode
{
	public:
	CItemIndexNode(CItemIndexNode *p, int ici, bool msf)
		: lr1_item_index(item_core_index),
			initial_list_size(10), descendants(initial_list_size)
	{
		parent				= p;
		item_core_index		= ici;
		machine_state_flag	= msf;
	}

	~CItemIndexNode() { }

	CItemIndexNode	*InsertOrMatch()
	{
		if (item_listptr)
		{
			int		index = item_list->Data(item_listptr);

			TList<CItemIndexNode>::listptr	descendant_listptr;

			descendant_listptr = descendants.FirstListPtr();

			while (descendant_listptr)
			{
				CItemIndexNode	*dp = descendants.NextData(descendant_listptr);

				if (index == dp->item_core_index)
				{
					item_list->NextData(item_listptr);
					return dp;
				}
			}

			CItemIndexNode	*child = new CItemIndexNode(this, index, false);

			descendants.PushBack(child);

			item_list->NextData(item_listptr);
			return child;
		}
		else
		{
			final_node				= this;
			existing_machine_state	= machine_state_flag;

			return 0;
		}
	}

	void	*operator new(size_t size)
	{ return allocator->allocate_element(size); }

	void	operator delete(void *p)
	{ allocator->release_element(p); }

	int						item_core_index;
	int						&lr1_item_index;
	bool					machine_state_flag;
	ListLR0MS::listptr		machine_state_listptr;
	CItemIndexNode			*parent;
	const int				initial_list_size;
	TList<CItemIndexNode>	descendants;

	static VListInt 			*item_list;
	static VListInt::listptr	item_listptr;
	static CItemIndexNode		*final_node;
	static bool					existing_machine_state;
	static CMemoryAllocator		*allocator;
	static void					SetupAllocator(int block_size);
};

class CStateTransition
{
	public:
	CStateTransition() { }
	CStateTransition(int si, int msi)
	{
		symbol_index		= si;
		machine_state_index	= msi;
	}

	CStateTransition	&operator=(const CStateTransition &s)
	{
		if (this != &s)
		{
			symbol_index		= s.symbol_index;
			machine_state_index	= s.machine_state_index;
		}

		return *this;
	}

	int		symbol_index;
	int		machine_state_index;
};

class CMachineInformation
{
	public:
	CMachineInformation()
		: lr1_item_count(item_core_count), lr1_item_set(item_core_set)
	{
		item_core_set		= 0;
		state_transitions	= 0;
	}

	~CMachineInformation()
	{
		delete [] item_core_set;
		delete [] state_transitions;
	}

	void	Initialize(int msi, int icc, int stc)
	{
		machine_state_index		= msi;
		item_core_count			= icc;
		item_core_set			= new int[icc];
		state_transition_count	= stc;
		state_transitions		= new CStateTransition[stc];
	}

	int					machine_state_index;
	int					item_core_count;
	int					&lr1_item_count;
	int					*item_core_set;
	int					*&lr1_item_set;
	int					state_transition_count;
	CStateTransition	*state_transitions;
};

typedef CMachineInformation		CLR1MachineInformation;

class COnNonterminal
{
	public:
	void	Initialize(int msi, int ni)
	{
		machine_state_index	= msi;
		nonterminal_index	= ni;
	}

	int		machine_state_index;
	int		nonterminal_index;
};

class CContainsItem
{
	public:
	void	Initialize(int msi, int ici)
	{
		machine_state_index	= msi;
		item_core_index		= ici;
	}

	int		machine_state_index;
	int		item_core_index;
};

class CConflict
{
	public:
	CConflict(int msi, int tsi)
	{
		machine_state_index		= msi;
		terminal_symbol_index	= tsi;
		action_set				= new VListInt(10);
		resolve_listptr			= 0;
	}

	~CConflict()
	{
		delete action_set;
	}

	int					machine_state_index;
	int					terminal_symbol_index;
	VListInt			*action_set;
	VListInt::listptr	resolve_listptr;
	VListInt::listptr	default_listptr;
};

typedef 	TList<CConflict>	ListConflict;

typedef		STOrderedPair<OrdPairInt, ListConflict::listptr>
				PairIntToListConflictPtr;

typedef		TValueList<PairIntToListConflictPtr>	VListMapToConflictPtr;

class CPrecedenceInformation
{
	public:
	enum Associativity
	{
		LeftAssociative,
		RightAssociative,
		NonAssociative
	};

	class CPrecedenceEntry
	{
		public:
		enum EntryType
		{
			TerminalEntry,
			RuleEntry
		};

		EntryType	type;
		int			index;
	};

	CPrecedenceInformation() { entries = 0; }
	~CPrecedenceInformation() { delete [] entries; }

	void	Initialize(int a, int ec, int *type, int *index)
	{
		switch (a)
		{
			case 0: associativity = LeftAssociative; break;
			case 1: associativity = RightAssociative; break;
			case 2: associativity = NonAssociative; break;
		}

		entry_count = ec;

		entries = new CPrecedenceEntry[entry_count];

		for (int i=0; i<entry_count; i++)
		{
			if (type[i] == 0)
				entries[i].type = CPrecedenceEntry::TerminalEntry;
			else
				entries[i].type = CPrecedenceEntry::RuleEntry;

			entries[i].index = index[i];
		}
	}

	Associativity		associativity;
	int					entry_count;
	CPrecedenceEntry	*entries;
};

class CEEEDomain1SI
{
	public:
	void	Initialize(int msi, int ici)
	{
		machine_state_index	= msi;
		item_core_index		= ici;
	}

	int		machine_state_index;
	int		item_core_index;
};

class CEEEDomain2SN
{
	public:
	void	Initialize(int msi, int ni)
	{
		machine_state_index	= msi;
		nonterminal_index	= ni;
	}

	int		machine_state_index;
	int		nonterminal_index;
};

class CEEEDomain3ST
{
	public:
	void	Initialize(int msi, int ti)
	{
		machine_state_index			= msi;
		terminal_index				= ti;
		essential_error_entry_flag	= false;
	}

	int		machine_state_index;
	int		terminal_index;
	bool	essential_error_entry_flag;
};

class CEEERelationsOnA
{
	public:
	CEEERelationsOnA()
	{
		on_a_reduces_to				= 0;
		on_a_reduces_to_symbol_in	= 0;
		directly_on_a_passes_null	= 0;
		error_entry_on_a			= 0;
		may_on_a_access				= 0;
		on_a_passes_null			= 0;
		on_a_accesses				= 0;
		may_imply_a_essential		= 0;
		implies_a_essential			= 0;
	}

	~CEEERelationsOnA()
	{
		delete on_a_reduces_to;
		delete on_a_reduces_to_symbol_in;
		delete directly_on_a_passes_null;
		delete error_entry_on_a;
		delete may_on_a_access;
		delete on_a_passes_null;
		delete on_a_accesses;
		delete may_imply_a_essential;
		delete implies_a_essential;
	}

	RelationInt		*on_a_reduces_to;
	RelationInt		*on_a_reduces_to_symbol_in;
	RelationInt		*directly_on_a_passes_null;
	RelationInt		*error_entry_on_a;
	RelationInt		*may_on_a_access;
	RelationInt		*on_a_passes_null;
	RelationInt		*on_a_accesses;
	RelationInt		*may_imply_a_essential;
	RelationInt		*implies_a_essential;
};

class CLeftSymbolGoto
{
	public:
	CLeftSymbolGoto()
		: from_state_index_list(10) { }
	CLeftSymbolGoto(int tsi)
		: to_state_index(tsi), from_state_index_list(10) { }

	int					to_state_index;
	TValueList<int>		from_state_index_list;

	CLeftSymbolGoto		&operator=(const CLeftSymbolGoto &lsg)
	{
		if (this != &lsg)
		{
			to_state_index = lsg.to_state_index;

			from_state_index_list.Clear();

			VListIntPtr		int_listptr =
				lsg.from_state_index_list.FirstListPtr();

			while (int_listptr)
				from_state_index_list.PushBack(
					lsg.from_state_index_list.NextData(int_listptr));
		}

		return *this;
	}
};

typedef		TValueList<CLeftSymbolGoto>			TLeftSymbolGotoList;
typedef		TLeftSymbolGotoList::listptr		TLeftSymbolGotoListPtr;

class CErrorStateTerminal
{
	public:
	CErrorStateTerminal() { }

	int		state;
	int		terminal;
};

class CSLR1LookAhead
{
	public:
	CSLR1LookAhead() { }
	CSLR1LookAhead(int s, int t, int r)
		: state(s), terminal(t), rule_index(r) { }

	int		state;
	int		terminal;
	int		rule_index;
};

typedef TValueList<CSLR1LookAhead>		ListSLR1LookAhead;

typedef CSLR1LookAhead					CLR1LookAhead;
typedef TValueList<CLR1LookAhead>		ListLR1LookAhead;

class CParse
{
	public:
	enum ParserType
	{
		LR_1,
		LALR_1,
		SLR_1
	};

	enum ErrorCalculation
	{
		NoCalculation,
		ApproximateEssential,
		ExactEssential
	};

	enum ErrorFunctionNumbering
	{
		OneNumber,
		NumberPerState,
		NumberPerEntry
	};

	CParse(	int sc, int sca, CSymbolInformation *s,
			int rc, int rca, CRuleInformation *r,
			int esi, int asi, int ssi, int ari,
			int tc, int tce, int *ti,
			int nc, int nca, int *ni,
			int pc, CPrecedenceInformation *p)
	{
		symbol_count			= sc;
		symbol_count_a			= sca;
		symbols					= s;
		rule_count				= rc;
		rule_count_a			= rca;
		rules					= r;
		empty_symbol_index		= esi;
		augmented_symbol_index	= asi;
		start_symbol_index		= ssi;
		augmented_rule_index	= ari;
		terminal_count			= tc;
		terminal_count_e		= tce;
		terminal_indexes		= ti;
		nonterminal_count		= nc;
		nonterminal_count_a		= nca;
		nonterminal_indexes		= ni;
		precedence_count		= pc;
		precedences				= p;

		symbol_status			= 0;
		item_cores				= 0;
		lr1_items				= 0;
		machine					= 0;
		on_nonterminal			= 0;
		contains_item			= 0;
		goto_table				= 0;
		unit_goto_table			= 0;
		contains_table			= 0;
		on_nonterminal_map		= 0;
		action_table			= 0;
		error_action_table		= 0;
		unit_action_table		= 0;
		rule_left_symbol_table	= 0;
		rule_right_length_table	= 0;
		eee_domain1_si			= 0;
		eee_domain2_sn			= 0;
		eee_domain2_sn_map		= 0;
		eee_domain3_st			= 0;
		eee_domain3_st_map		= 0;
		essential_error_entries	= 0;
		calculation_status		= NoCalculation;

		essential_error_state_terminals	= 0;
		default_error_state_terminals	= 0;

		relation_domain		= 0;
		lr0_machine_states	= 0;
		parsing_conflicts	= 0;
		begins				= 0;
		ends				= 0;
		terminal			= 0;
		first_of			= 0;
		points				= 0;
		passes_any			= 0;
		passes_null			= 0;
		adjoins				= 0;
		follows				= 0;
		lr0descendant		= 0;
		lr0closure			= 0;
		has_transition_on	= 0;
		goes_to				= 0;
		has_null_transition	= 0;
		includes			= 0;
		lookback			= 0;
		directly_reads		= 0;
		reads				= 0;
		has_lalr_lookahead	= 0;
		symbol_in			= 0;
		eee_points			= 0;
		expands				= 0;
		entered_by			= 0;
		directly_descends	= 0;
		left_corner_in		= 0;
		relations_on_a		= 0;
		slr1_lookahead		= 0;
		lr1_first_prefix	= 0;
		lr1_first_symbols	= 0;
		lr1descendant		= 0;
		lr1closure			= 0;
		lr1_machine_states	= 0;
		lr1_machine			= 0;
		lr1_lookahead		= 0;
	}

	~CParse()
	{
		delete [] symbols;
		delete [] rules;
		delete [] terminal_indexes;
		delete [] nonterminal_indexes;
		delete [] precedences;

		delete [] symbol_status;
		delete [] item_cores;
		delete [] lr1_items;
		delete [] machine;
		delete [] on_nonterminal;
		delete [] contains_item;
		delete [] goto_table;
		delete [] unit_goto_table;
		delete [] contains_table;
		delete [] on_nonterminal_map;
		delete [] action_table;
		delete [] error_action_table;
		delete [] unit_action_table;
		delete [] rule_left_symbol_table;
		delete [] rule_right_length_table;
		delete [] eee_domain1_si;
		delete [] eee_domain2_sn;
		delete [] eee_domain2_sn_map;
		delete [] eee_domain3_st;
		delete [] eee_domain3_st_map;
		delete [] essential_error_entries;
		delete [] essential_error_state_terminals;
		delete [] default_error_state_terminals;

		delete relation_domain;
		delete lr0_machine_states;
		delete parsing_conflicts;
		delete begins;
		delete ends;
		delete terminal;
		delete first_of;
		delete points;
		delete passes_any;
		delete passes_null;
		delete adjoins;
		delete follows;
		delete lr0descendant;
		delete lr0closure;
		delete has_transition_on;
		delete goes_to;
		delete has_null_transition;
		delete includes;
		delete lookback;
		delete directly_reads;
		delete reads;
		delete has_lalr_lookahead;
		delete symbol_in;
		delete eee_points;
		delete expands;
		delete entered_by;
		delete directly_descends;
		delete left_corner_in;
		delete [] relations_on_a;
		delete slr1_lookahead;
		delete lr1_first_prefix;
		delete lr1_first_symbols;
		delete lr1descendant;
		delete lr1closure;
		delete lr1_machine_states;
		delete [] lr1_machine;
		delete lr1_lookahead;
	}

	int						symbol_count;
	int						symbol_count_a;
	CSymbolInformation		*symbols;
	int						rule_count;
	int						rule_count_a;
	CRuleInformation		*rules;
	int						empty_symbol_index;
	int						augmented_symbol_index;
	int						start_symbol_index;
	int						augmented_rule_index;
	int						terminal_count;
	int						terminal_count_e;
	int						*terminal_indexes;
	int						nonterminal_count;
	int						nonterminal_count_a;
	int						*nonterminal_indexes;
	int						precedence_count;
	CPrecedenceInformation	*precedences;

	CSymbolStatus		*symbol_status;
	bool				derives_terminal_flag;
	bool				accessible_flag;
	bool				derives_empty_flag;
	int					item_core_count;
	int					item_points_count;
	int					maximum_right_symbol_count;
	int					lr1_item_count;
	CItemCore			*item_cores;
	CLR1Item			*lr1_items;
	int					machine_count;
	int					unit_machine_count;
	int					transition_count;
	int					on_nonterminal_count;
	int					on_nullable_count;
	CMachineInformation	*machine;
	COnNonterminal		*on_nonterminal;
	int					contains_item_count;
	CContainsItem		*contains_item;
	int					*goto_table;
	int					*unit_goto_table;
	int					*contains_table;
	int					*on_nonterminal_map;
	int					*action_table;
	int					*error_action_table;
	int					*unit_action_table;
	int					*rule_left_symbol_table;
	int					*rule_right_length_table;
	int					error_action;
	int					shift_action;
	int					accept_action;
	int					conflict_entry;
	int					unresolved_conflict_count;
	int					eee_domain1_si_count;
	CEEEDomain1SI		*eee_domain1_si;
	int					eee_domain2_sn_count;
	CEEEDomain2SN		*eee_domain2_sn;
	int					*eee_domain2_sn_map;
	int					eee_domain3_st_count;
	CEEEDomain3ST		*eee_domain3_st;
	int					*eee_domain3_st_map;
	int					default_error_entry_count;
	int					essential_error_entry_count;
	bool				*essential_error_entries;
	CErrorStateTerminal	*essential_error_state_terminals;
	CErrorStateTerminal	*default_error_state_terminals;
	ErrorCalculation	calculation_status;
	ParserType			parser_type;

	VListInt			*relation_domain;
	ListLR0MS			*lr0_machine_states;
	ListConflict		*parsing_conflicts;
	RelationInt			*begins;
	RelationInt			*ends;
	RelationInt			*terminal;
	RelationInt			*first_of;
	RelationInt			*points;
	RelationInt			*passes_any;
	RelationInt			*passes_null;
	RelationInt			*adjoins;
	RelationInt			*follows;
	RelationInt			*lr0descendant;
	RelationInt			*lr0closure;
	RelationInt			*has_transition_on;
	RelationInt			*goes_to;
	RelationInt			*has_null_transition;
	RelationInt			*includes;
	RelationInt			*lookback;
	RelationInt			*directly_reads;
	RelationInt			*reads;
	RelationInt			*has_lalr_lookahead;
	RelationInt			*symbol_in;
	RelationInt			*eee_points;
	RelationInt			*expands;
	RelationInt			*entered_by;
	RelationInt			*directly_descends;
	RelationInt			*left_corner_in;
	CEEERelationsOnA	*relations_on_a;
	ListSLR1LookAhead	*slr1_lookahead;
	int					lookahead_terminal_index;
	VListInt			*lr1_first_prefix;
	VListInt			*lr1_first_symbols;
	RelationInt			*lr1descendant;
	RelationInt			*lr1closure;
	ListLR1MS			*lr1_machine_states;
	CLR1MachineInformation	*lr1_machine;
	ListLR1LookAhead	*lr1_lookahead;

	bool	CalculateParser(ParserType type);
	void	ResetCalculationStatus();
	void	CalculateEssentialErrorEntries(
				ErrorCalculation c, ErrorFunctionNumbering n);
	void	CreateEssentialErrorActionTable(ErrorFunctionNumbering n);
	void	CalculateUnitRuleElimination(int u_count, int *order_list);
	bool	ValidateConflict(int index, int state, int symbol, int action);
	void	ModifyActionTable(int index, int state, int symbol, int action);
	bool	DerivesTerminal();
	bool	AccessibleSymbol();
	void	DerivesEmpty();
	void	ItemCores();
	void	LR1Items();
	void	LR1First();
	void	RelationLR0Domain();
	void	RelationLR1Domain();
	void	RelationBegins();
	void	RelationEnds();
	void	RelationTerminal();
	void	RelationFirstOf();
	void	RelationPoints();
	void	RelationAdjoins();
	void	RelationFollows();
	void	RelationLR0Descendant();
	void	RelationLR1Descendant();
	void	RelationLR0PassesX();
	void	RelationLR1PassesX();
	void	RelationLR0Machine();
	void	RelationLR1Machine();
	void	ComputeLR0Machine();
	void	ComputeLR1Machine();
	void	ComputeLALR1Domains();
	void	ComputeLALR1Relations();
	void	ComputeLALR1Lookaheads();
	bool	ComputeLALR1ActionTable();
	void	ComputeSLR1Lookaheads();
	bool	ComputeSLR1ActionTable();
	void	ComputeLR1Lookaheads();
	bool	ComputeLR1ActionTable();
	void	DefaultConflictResolution();
	void	ComputeEEEDomains();
	void	ComputeEEERelations();
	void	ComputeApproximateEssentialErrorEntries();
	void	ComputeExactEssentialErrorEntries();
	void	ComputeLR1ErrorEntries();
};

#endif
