/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef PARSERDIALOG_H
#define PARSERDIALOG_H

#include <qwidget.h>
#include <qfont.h>
#include <qpalette.h>

#include "optionData.h"

class CCalculateDialog;
class CErrorEntriesDialog;
class CUnitRulesDialog;
class CGenerateCodeDialog;
class CSimulatorErrorDialog;
class CSimulatorControlDialog;

namespace ParserDialog
{
	extern CCalculateDialog			*calculate_dialog;
	extern CErrorEntriesDialog		*error_entries_dialog;
	extern CUnitRulesDialog			*unit_rules_dialog;
	extern CGenerateCodeDialog		*generate_code_dialog;
	extern CSimulatorErrorDialog	*simulator_error_dialog;
	extern CSimulatorControlDialog	*simulator_control_dialog;

	void	CreateParserDialogs(QWidget *parent);
	void	DestroyParserDialogs();
	void	SetCalculatePaletteAndFont(COptionData *d);
	void	SetErrorEntriesPaletteAndFont(COptionData *d);
	void	SetUnitRulesPaletteAndFont(COptionData *d);
	void	SetGenerateCodePaletteAndFont(COptionData *d);
	void	SetSimulatorErrorPaletteAndFont(COptionData *d);
	void	SetSimulatorControlPaletteAndFont(COptionData *d);

	const char * const	line_edit_string_size =
		"0123456789012345678901234567890123456789";
}

#include "fontchangeControl.h"
#include "compilerData.h"
#include "compilerInterface.h"
#include "stringToken.h"
#include "filePath.h"

class CCalculateDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CCalculateDialog(QWidget *parent);
	virtual	~CCalculateDialog() { }

	void	SetTitleAndResize(const string &title);
	void	SetCompilerInterfacePointer(CCompilerInterface *c);

	public slots:
	void	Calculate();

	private:
	CCompilerInterface	*compiler_interface_pointer;
	CSpacerFc			*spacer1;
	CCheckBoxFc			*lexical_check_box;
	CPushButtonFc		*calculate_button;
	CPushButtonFc		*close_button;
	CHButtonGroupFc		*range_button_group;
	CRadioButtonFc		*r128_radio_button;
	CRadioButtonFc		*r256_radio_button;
	CHButtonGroupFc		*lexical_button_group;
	CRadioButtonFc		*singlechar_radio_button;
	CRadioButtonFc		*regexp_radio_button;
	CSpacerFc			*spacer2;
	CCheckBoxFc			*parser_check_box;
	CHButtonGroupFc		*parser_button_group;
	CRadioButtonFc		*slr1_radio_button;
	CRadioButtonFc		*lalr1_radio_button;
	CRadioButtonFc		*lr1_radio_button;
	CMultiLineEditFc	*status_multi_line_edit;
	CSpacerFc			*spacer3;
};

class CErrorEntriesDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CErrorEntriesDialog(QWidget *parent);
	virtual	~CErrorEntriesDialog() { }

	void	SetTitleAndResize(const string &title);
	void	SetCompilerInterfacePointer(CCompilerInterface *c);

	public slots:
	void	Calculate();
	void	NumberingSelected(int id);

	private:
	CCompilerInterface	*compiler_interface_pointer;
	CHButtonGroupFc		*calculation_button_group;
	CRadioButtonFc		*no_calculation_radio_button;
	CRadioButtonFc		*approximate_radio_button;
	CRadioButtonFc		*exact_radio_button;
	CHButtonGroupFc		*numbering_button_group;
	CRadioButtonFc		*one_number_radio_button;
	CRadioButtonFc		*number_per_state_radio_button;
	CRadioButtonFc		*number_per_entry_radio_button;
	CHButtonGroupFc		*aggregation_button_group;
	CRadioButtonFc		*one_function_radio_button;
	CRadioButtonFc		*function_per_state_radio_button;
	CRadioButtonFc		*function_per_entry_radio_button;
	CMultiLineEditFc	*status_multi_line_edit;
	CPushButtonFc		*calculate_button;
	CPushButtonFc		*close_button;
	CSpacerFc			*spacer1;
};

class CUnitRulesDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CUnitRulesDialog(QWidget *parent);
	virtual ~CUnitRulesDialog() { }

	void	SetTitleAndResize(const string &title);
	void	SetCompilerInterfacePointer(CCompilerInterface *c);

	public slots:
	void	MoveUp();
	void	MoveDown();
	void	MoveToFirst();
	void	MoveToLast();
	void	Calculate();

	private:
	CCompilerInterface	*compiler_interface_pointer;
	vector<int>			ordering_array;
	CListBoxFc			*unit_rule_listbox;
	CPushButtonFc		*move_up_button;
	CPushButtonFc		*move_down_button;
	CPushButtonFc		*move_to_first_button;
	CPushButtonFc		*move_to_last_button;
	CMultiLineEditFc	*status_multi_line_edit;
	CPushButtonFc		*calculate_button;
	CPushButtonFc		*close_button;
	CSpacerFc			*spacer1;
};

class CGenerateCodeDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CGenerateCodeDialog(QWidget *parent);
	virtual	~CGenerateCodeDialog() { }

	void	SetTitleAndResize(const string &title);
	void	SetCompilerInterfacePointer(CCompilerInterface *c);

	virtual void	setFont(const QFont &f);

	public slots:
	void	GenerateCode();

	private:
	CCompilerInterface	*compiler_interface_pointer;
	QGridLayout			*subgrid_layout1;
	CSpacerFc			*spacer1;
	CCheckBoxFc			*lexical_check_box;
	CSpacerFc			*spacer2;
	CCheckBoxFc			*parser_check_box;
	CHButtonGroupFc		*table_type_button_group;
	CRadioButtonFc		*without_unit_radio_button;
	CRadioButtonFc		*with_unit_radio_button;
	QGridLayout			*subgrid_layout2;
	CLabelFc			*directory_label;
	CLineEditFc			*directory_line_edit;
	CLabelFc			*lexical_prefix_label;
	CLineEditFc			*lexical_prefix_line_edit;
	CLabelFc			*parser_prefix_label;
	CLineEditFc			*parser_prefix_line_edit;
	CLabelFc			*base_prefix_label;
	CLineEditFc			*base_prefix_line_edit;
	QGridLayout			*subgrid_layout3;
	CSpacerFc			*spacer7;
	CCheckBoxFc			*generate_base_classes_check_box;
	CSpacerFc			*spacer8;
	CSpacerFc			*spacer3;
	CCheckBoxFc			*tty_check_box;
	CSpacerFc			*spacer4;
	CCheckBoxFc			*regexp_check_box;
	CSpacerFc			*spacer5;
	CPushButtonFc		*generate_code_button;
	CPushButtonFc		*close_button;
	CMultiLineEditFc	*status_multi_line_edit;
	CSpacerFc			*spacer6;
};

class CSimulatorErrorDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CSimulatorErrorDialog(QWidget *parent);
	virtual ~CSimulatorErrorDialog() { }

	void	SetTitleAndResize(const string &title);
	void	SetValuePointer(int *v) { value_pointer = v; }
	void	SetCompilerDataPointer(CCompilerData *d);

	public slots:
	void	SetErrorToken();

	private:
	int					*value_pointer;
	CCompilerData		*compiler_data_pointer;
	CListBoxFc			*error_token_listbox;
	CPushButtonFc		*ok_button;
	CPushButtonFc		*close_button;
	CSpacerFc			*spacer1;
};

class CSimulatorControlDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CSimulatorControlDialog(QWidget *parent);
	virtual	~CSimulatorControlDialog() { }

	void	SetTitleAndResize(const string &title);
	void	SetCompilerInterfacePointer(CCompilerInterface *c);
	void	SetLexicalFlagPointer(bool *f)
	{ lexical_flag_pointer = f; }
	void	SetParserFlagPointer(bool *f)
	{ parser_flag_pointer = f; }
	void	SetDiscardLexicalErrorFlagPointer(bool *f)
	{ discard_lexical_error_flag_pointer = f; }
	void	SetWithUnitRuleEliminationsFlagPointer(bool *f)
	{ with_unit_rule_eliminations_flag_pointer = f; }
	void	SetTrapLexicalListPointer(list< pair<bool, string> > *t)
	{ trap_lexical_list_pointer = t; }
	void	SetTrapParserListPointer(list< pair<bool, string> > *t)
	{ trap_parser_list_pointer = t; }
	void	SetTrapLexicalList();
	void	SetTrapParserList();
	void	StoreTrapLexicalList();
	void	StoreTrapParserList();

	virtual void	setFont(const QFont &f);

	public slots:
	void	SetOptions();
	void	LexicalRadioToggled(bool on);
	void	ParserRadioToggled(bool on);

	private:
	CCompilerInterface			*compiler_interface_pointer;
	bool						*lexical_flag_pointer;
	bool						*parser_flag_pointer;
	bool						*discard_lexical_error_flag_pointer;
	bool						*with_unit_rule_eliminations_flag_pointer;
	bool						lexical_list_set_flag;
	bool						parser_list_set_flag;
	list< pair<bool, string> >	*trap_lexical_list_pointer;
	list< pair<bool, string> >	*trap_parser_list_pointer;
	CVButtonGroupFc				*simulate_type_button_group;
	CRadioButtonFc				*lexical_radio_button;
	CRadioButtonFc				*parser_radio_button;
	CSpacerFc					*spacer1;
	CCheckBoxFc					*discard_lexical_error_check_box;
	CSpacerFc					*spacer2;
	CCheckBoxFc					*with_unit_rule_eliminations_check_box;
	Q3ListView					*trap_symbol_list_view;
	QGridLayout					*subgrid_layout;
	CPushButtonFc				*ok_button;
	CPushButtonFc				*cancel_button;
	CSpacerFc					*spacer3;
};

#endif
