/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef PRECEDENCEVIEW_H
#define	PRECEDENCEVIEW_H

class CPrecedenceListView;
class CPrecedenceVBoxWidget;
class CPrecedenceView;

#include <qobject.h>
#include <qwidget.h>
#include <q3listview.h>
#include <q3header.h>
#include <qevent.h>
#include <qcolor.h>
#include <qpalette.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "grammarDialog.h"

class CPrecedenceListView: public Q3ListView
{
	Q_OBJECT
	public:
	CPrecedenceListView(CPrecedenceVBoxWidget *v)
		: Q3ListView((QWidget *)v, 0, 0), precedence_vbox(v) { }
	~CPrecedenceListView() { }

	void	InitializePalette(const QPalette &p);

	protected:
	virtual void	keyPressEvent(QKeyEvent *e);
	virtual void	focusInEvent(QFocusEvent *e);
	virtual void	focusOutEvent(QFocusEvent *e);
	virtual void	mouseDoubleClickEvent(QMouseEvent *e);

	private:
	CPrecedenceVBoxWidget	*precedence_vbox;
	QColor					active_highlight;
	QColor					active_highlighted_text;
	QColor					inactive_highlight;
	QColor					inactive_highlighted_text;
};

class CPrecedenceVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CPrecedenceVBoxWidget(	QWidget *parent,
							CCompilerInterface *ci,
							SMainViewControl *mvc,
							COptionData::SSubViewData *d,
							CPrecedenceView *pv);

	virtual ~CPrecedenceVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializePalette(const QPalette &p)
	{ list_view->InitializePalette(p); }
	void	InitializeModulePointers();

	void	InsertBeforePrecedence();
	void	InsertAfterPrecedence();
	void	EditPrecedence();
	void	DeletePrecedence();
	void	MovePrecedenceUp();
	void	MovePrecedenceDown();
	void	UpdateListView();
	void	RestoreUndoData();

	private:
	CLabelFc				*label;
	CPrecedenceListView		*list_view;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CPrecedenceView				*precedence_view;
	ModulePtrMap				&module_ptr_map;

	void	SetSelectedItem(int i);
	void	InsertBeforePrecedence(int i, const CPrecedence &t);
	void	InsertAfterPrecedence(int i, const CPrecedence &t);
	void	UpdatePrecedence(int i, const CPrecedence &t);
	void	DeletePrecedence(int i);
	void	MovePrecedenceUp(int i);
	void	MovePrecedenceDown(int i);
};

class CPrecedenceView: public CSubView
{
	public:
	CPrecedenceView(QWidget *p,
					CViewNode *n,
					CInterfaceControl *ic,
					SMainViewControl *mvc,
					const string &dfs,
					CPaletteData *dpd,
					COptionData::SSubViewData *d);

	virtual ~CPrecedenceView();

	virtual CPrecedenceVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	InsertAfterPrecedence();
	void	InsertBeforePrecedence();
	void	EditPrecedence();
	void	DeletePrecedence();
	void	MovePrecedenceUp();
	void	MovePrecedenceDown();
	void	UpdateListView();
	void	RestoreUndoData();

	private:
	CPrecedenceVBoxWidget		*frame;
};

#endif
