/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef REPLACENODE_H
#define REPLACENODE_H

#include <qnamespace.h>
#include <string>

enum NavigationType
{
	MoveDownTree,
	MoveUpTree,
	MoveLeftTree,
	MoveRightTree
};

enum AddNodeType
{
	AddBefore,
	AddAfter
};

struct SReplaceNode
{
	SReplaceNode(Qt::Orientation o, int c)
		: modify_with_splitter(true), orientation(o), count(c) { }
	SReplaceNode(string &s)
		: modify_with_splitter(false), subview_name(s) { }

	void	SetRootOrientation(Qt::Orientation ro)
	{ root_orientation = ro; }

	bool				modify_with_splitter;
	Qt::Orientation		root_orientation;
	Qt::Orientation		orientation;
	int					count;
	string				subview_name;
};

typedef SReplaceNode	SAddNode;

#endif
