/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef RULEVIEW_H
#define	RULEVIEW_H

class CRuleListView;
class CRuleVBoxWidget;
class CRuleView;

#include <qobject.h>
#include <qwidget.h>
#include <q3listview.h>
#include <q3header.h>
#include <qevent.h>
#include <qcolor.h>
#include <qpalette.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "implicitView.h"
#include "precedenceView.h"
#include "ruleSelectView.h"
#include "grammarDialog.h"

class CRuleListView: public Q3ListView
{
	Q_OBJECT
	public:
	CRuleListView(CRuleVBoxWidget *v)
		: Q3ListView((QWidget *)v, 0, 0), rule_vbox(v) { }
	~CRuleListView() { }

	void	InitializePalette(const QPalette &p);

	protected:
	virtual void	keyPressEvent(QKeyEvent *e);
	virtual void	focusInEvent(QFocusEvent *e);
	virtual void	focusOutEvent(QFocusEvent *e);
	virtual void	mouseDoubleClickEvent(QMouseEvent *e);

	private:
	CRuleVBoxWidget		*rule_vbox;
	QColor				active_highlight;
	QColor				active_highlighted_text;
	QColor				inactive_highlight;
	QColor				inactive_highlighted_text;
};

class CRuleVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CRuleVBoxWidget(QWidget *parent,
					CCompilerInterface *ci,
					SMainViewControl *mvc,
					COptionData::SSubViewData *d,
					CRuleView *rv);

	virtual ~CRuleVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializePalette(const QPalette &p)
	{ list_view->InitializePalette(p); }
	void	InitializeModulePointers();

	void	InsertBeforeRule();
	void	InsertAfterRule();
	void	EditRule();
	void	DeleteRule();
	void	MoveRuleUp();
	void	MoveRuleDown();
	void	UpdateListView();
	void	RestoreUndoData();

	private:
	CLabelFc			*label;
	CRuleListView		*list_view;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CRuleView					*rule_view;
	ModulePtrMap				&module_ptr_map;

	void	SetSelectedItem(int i);
	void	InsertBeforeRule(int i, const CRule &t);
	void	InsertAfterRule(int i, const CRule &t);
	void	UpdateRule(int i, const CRule &t);
	void	DeleteRule(int i);
	void	MoveRuleUp(int i);
	void	MoveRuleDown(int i);
};

class CRuleView: public CSubView
{
	public:
	CRuleView(	QWidget *p,
				CViewNode *n,
				CInterfaceControl *ic,
				SMainViewControl *mvc,
				const string &dfs,
				CPaletteData *dpd,
				COptionData::SSubViewData *d);

	virtual ~CRuleView();

	virtual CRuleVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	InsertAfterRule();
	void	InsertBeforeRule();
	void	EditRule();
	void	DeleteRule();
	void	MoveRuleUp();
	void	MoveRuleDown();
	void	UpdateListView();
	void	RestoreUndoData();

	private:
	CRuleVBoxWidget		*frame;
};

#endif
