/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef TERMINALVIEW_H
#define	TERMINALVIEW_H

class CStartContextWidget;
class CTerminalListView;
class CTerminalVBoxWidget;
class CTerminalView;

#include <qobject.h>
#include <qwidget.h>
#include <q3listview.h>
#include <q3header.h>
#include <qevent.h>
#include <qcolor.h>
#include <qpalette.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "errorTokenView.h"
#include "nonterminalView.h"
#include "implicitView.h"
#include "precedenceView.h"
#include "ruleView.h"
#include "terminalSelectView.h"
#include "grammarDialog.h"
#include "optionDialog.h"

class CStartContextWidget: public CFrameFc
{
	Q_OBJECT
	public:
	CStartContextWidget(CTerminalVBoxWidget *v);
	~CStartContextWidget() { }

	CLineEditFc		*GetStartContextLineEdit() const
	{ return start_context_line_edit; }

	public slots:
	void	ModifyStartContext();

	private:
	CTerminalVBoxWidget		*terminal_vbox;
	CPushButtonFc			*start_context_button;
	CLineEditFc				*start_context_line_edit;
};

class CTerminalListView: public Q3ListView
{
	Q_OBJECT
	public:
	CTerminalListView(CTerminalVBoxWidget *v)
		: Q3ListView((QWidget *)v, 0, 0), terminal_vbox(v) { }
	~CTerminalListView() { }

	void	InitializePalette(const QPalette &p);

	protected:
	virtual void	keyPressEvent(QKeyEvent *e);
	virtual void	focusInEvent(QFocusEvent *e);
	virtual void	focusOutEvent(QFocusEvent *e);
	virtual void	mouseDoubleClickEvent(QMouseEvent *e);

	private:
	CTerminalVBoxWidget		*terminal_vbox;
	QColor					active_highlight;
	QColor					active_highlighted_text;
	QColor					inactive_highlight;
	QColor					inactive_highlighted_text;
};

class CTerminalVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CTerminalVBoxWidget(	QWidget *parent,
							CCompilerInterface *ci,
							SMainViewControl *mvc,
							COptionData::SSubViewData *d,
							CTerminalView *tv);

	virtual ~CTerminalVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializePalette(const QPalette &p)
	{ list_view->InitializePalette(p); }
	void	InitializeModulePointers();

	void	ModifyStartContext();
	void	InsertBeforeTerminal();
	void	InsertAfterTerminal();
	void	EditTerminal();
	void	DeleteTerminal();
	void	MoveTerminalUp();
	void	MoveTerminalDown();
	void	UpdateListView();
	void	RestoreUndoData();

	private:
	CLabelFc				*label;
	CStartContextWidget		*start_context_widget;
	CTerminalListView		*list_view;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CTerminalView				*terminal_view;
	ModulePtrMap				&module_ptr_map;

	void	SetSelectedItem(int i);
	void	InsertBeforeTerminal(int i, const CTerminal &t);
	void	InsertAfterTerminal(int i, const CTerminal &t);
	void	UpdateTerminal(int i, const CTerminal &t);
	void	DeleteTerminal(int i);
	void	MoveTerminalUp(int i);
	void	MoveTerminalDown(int i);
};

class CTerminalView: public CSubView
{
	public:
	CTerminalView(	QWidget *p,
					CViewNode *n,
					CInterfaceControl *ic,
					SMainViewControl *mvc,
					const string &dfs,
					CPaletteData *dpd,
					COptionData::SSubViewData *d);

	virtual ~CTerminalView();

	virtual CTerminalVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	ModifyStartContext();
	void	InsertAfterTerminal();
	void	InsertBeforeTerminal();
	void	EditTerminal();
	void	DeleteTerminal();
	void	MoveTerminalUp();
	void	MoveTerminalDown();
	void	UpdateListView();
	void	RestoreUndoData();

	private:
	CTerminalVBoxWidget		*frame;
};

#endif
