/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "undefinedView.h"

CUndefinedFrameWidget::CUndefinedFrameWidget(	QWidget *parent,
												CInterfaceControl *ic,
												SMainViewControl *mvc,
												COptionData::SSubViewData *d,
												CUndefinedView *uv)
	: CFrameWidget(parent, ic, mvc), interface_control(ic),
		subview_data(d), undefined_view(uv)
{
	QFontInfo		fi(font());

	int		pixel_size = fi.pixelSize();

	int		m = grid_layout_margin_data[pixel_size];
	int		s = grid_layout_spacing_data[pixel_size];

	grid_layout = new QGridLayout(this, 1, 1, m, s);

	grid_layout->setRowStretch(0, 1);
	grid_layout->setColStretch(0, 1);

	ostrstream		text_stream;
	vector<int>		*v = d->GetIndex();

	CreateIndexText(text_stream, *v);

	index_text = text_stream.str();

	label = new CLabelFc(("UNDEFINED_VIEW\n" + index_text).c_str(), this);

	label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);

	grid_layout->addWidget(label, 0, 0);
}

CUndefinedFrameWidget::~CUndefinedFrameWidget()
{
}

void	CUndefinedFrameWidget::CreateIndexText(	ostrstream &s,
												const vector<int> &index,
												bool f)
{
	if (f)
		s << "Index = (";

	if (index.size())
	{
		vector<int>::size_type	i;

		for(i=0; i<index.size()-1; i++)
			s << index[i] << ", ";

		s << index[index.size()-1];
	}

	if (f)
		s << ")";

	s << '\0';
}

CUndefinedView::CUndefinedView(	QWidget *p,
								CViewNode *n,
								CInterfaceControl *ic,
								SMainViewControl *mvc,
								const string &dfs,
								CPaletteData *dpd,
								COptionData::SSubViewData *d)
	: CSubView(p, n, ic, mvc, dfs, dpd, d)
{
	frame = new CUndefinedFrameWidget(p, ic, mvc, d, this);

	QFont		view_node_font;
	QPalette	view_node_palette;

	if (SetupViewNodeFont(view_node_font))
		frame->setFont(view_node_font);
	else
		frame->setFont(frame->font());

	if (SetupViewNodePalette(view_node_palette))
		frame->setPalette(view_node_palette);
	else
		frame->setPalette(frame->palette());
}

CUndefinedView::~CUndefinedView()
{
	delete frame;
}

void	CUndefinedView::SetHighlightPalette(CPaletteData *pd)
{
	restore_palette = frame->palette();

	QPalette	highlight_palette;

	pd->SetupPalette(highlight_palette);

	frame->setPalette(highlight_palette);
}

void	CUndefinedView::RestorePalette()
{
	frame->setPalette(restore_palette);
}
